/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.reflect.contained;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.morimekta.providence.PEnumBuilder;
import net.morimekta.providence.PEnumValue;
import net.morimekta.providence.descriptor.PEnumDescriptor;
import net.morimekta.providence.reflect.contained.CAnnotatedDescriptor;
import net.morimekta.providence.reflect.contained.CEnumDescriptor;

public class CEnumValue
implements PEnumValue<CEnumValue>,
CAnnotatedDescriptor {
    private final int value;
    private final String name;
    private final PEnumDescriptor<CEnumValue> type;
    private final String comment;
    private final Map<String, String> annotations;

    public CEnumValue(String comment, int value, String name, PEnumDescriptor<CEnumValue> type, Map<String, String> annotations) {
        this.comment = comment;
        this.value = value;
        this.name = name;
        this.type = type;
        this.annotations = annotations;
    }

    @Override
    public String getDocumentation() {
        return this.comment;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public int asInteger() {
        return this.value;
    }

    public String asString() {
        return this.name;
    }

    @Override
    public Set<String> getAnnotations() {
        if (this.annotations != null) {
            return this.annotations.keySet();
        }
        return Collections.EMPTY_SET;
    }

    @Override
    public boolean hasAnnotation(String name) {
        if (this.annotations != null) {
            return this.annotations.containsKey(name);
        }
        return false;
    }

    @Override
    public String getAnnotationValue(String name) {
        if (this.annotations != null) {
            return this.annotations.get(name);
        }
        return null;
    }

    public PEnumDescriptor<CEnumValue> descriptor() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !(o instanceof CEnumValue)) {
            return false;
        }
        CEnumValue other = (CEnumValue)o;
        return other.descriptor().getQualifiedName().equals(this.type.getQualifiedName()) && other.getName().equals(this.name) && other.getValue() == this.value;
    }

    public int hashCode() {
        return Objects.hash(CEnumValue.class, this.descriptor().getQualifiedName(), this.name, this.value);
    }

    public int compareTo(CEnumValue other) {
        return Integer.compare(this.value, other.value);
    }

    public String toString() {
        return this.name.toUpperCase();
    }

    public static class Builder
    extends PEnumBuilder<CEnumValue> {
        private final CEnumDescriptor mType;
        private CEnumValue mValue = null;

        public Builder(CEnumDescriptor type) {
            this.mType = type;
        }

        public CEnumValue build() {
            return this.mValue;
        }

        public boolean valid() {
            return this.mValue != null;
        }

        public Builder setByValue(int id) {
            this.mValue = this.mType.getValueById(id);
            return this;
        }

        public Builder setByName(String name) {
            this.mValue = this.mType.getValueByName(name);
            return this;
        }
    }
}

