/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.reflect.parser.internal;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.morimekta.providence.reflect.parser.ParseException;
import net.morimekta.providence.reflect.parser.internal.Token;
import net.morimekta.util.Strings;
import net.morimekta.util.io.IOUtils;

public class Tokenizer
extends InputStream {
    private final byte[] buffer;
    private int readOffset;
    private int lineNo;
    private int linePos;
    private Token nextToken;

    public Tokenizer(InputStream in) throws IOException {
        ByteArrayOutputStream tmp = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)in, (OutputStream)tmp);
        this.buffer = tmp.toByteArray();
        this.readOffset = -1;
        this.lineNo = 1;
        this.linePos = -1;
    }

    @Override
    public int read() {
        if (++this.readOffset >= this.buffer.length) {
            this.readOffset = this.buffer.length;
            return -1;
        }
        int ret = this.buffer[this.readOffset];
        if (ret == 10) {
            ++this.lineNo;
            this.linePos = -1;
        } else {
            ++this.linePos;
        }
        return ret > 0 ? ret : 256 + ret;
    }

    private void unread() {
        if (this.readOffset == this.buffer.length) {
            --this.readOffset;
            return;
        }
        if (this.buffer[this.readOffset--] == 10) {
            --this.lineNo;
        } else {
            --this.linePos;
        }
    }

    public Token expect(String message) throws IOException, ParseException {
        if (!this.hasNext()) {
            throw new ParseException("Expected %s, but got end of file", message);
        }
        Token next = this.nextToken;
        this.nextToken = null;
        return next;
    }

    public Token peek(String message) throws IOException, ParseException {
        if (!this.hasNext()) {
            throw new ParseException("Expected %s, but got end of file", message);
        }
        return this.nextToken;
    }

    public Token peek() throws IOException, ParseException {
        this.hasNext();
        return this.nextToken;
    }

    public char expectSymbol(String message, char ... symbols) throws IOException, ParseException {
        if (!this.hasNext()) {
            throw new ParseException("Expected %s, but got end of file", message);
        }
        for (char symbol : symbols) {
            if (!this.nextToken.isSymbol(symbol)) continue;
            this.nextToken = null;
            return symbol;
        }
        throw new ParseException(this, this.nextToken, "Expected %s, but got '%s'", message, Strings.escape((CharSequence)this.nextToken.asString()));
    }

    public Token expectIdentifier(String message) throws IOException, ParseException {
        if (!this.hasNext()) {
            throw new ParseException("Expected %s, but got end of file", message);
        }
        if (this.nextToken.isIdentifier()) {
            Token next = this.nextToken;
            this.nextToken = null;
            return next;
        }
        throw new ParseException(this, this.nextToken, "Expected %s, but got '%s'", message, Strings.escape((CharSequence)this.nextToken.asString()));
    }

    public Token expectQualifiedIdentifier(String message) throws IOException, ParseException {
        if (!this.hasNext()) {
            throw new ParseException("Expected %s, but got end of file", message);
        }
        if (this.nextToken.isQualifiedIdentifier()) {
            Token next = this.nextToken;
            this.nextToken = null;
            return next;
        }
        throw new ParseException(this, this.nextToken, "Expected %s, but got '%s'", message, Strings.escape((CharSequence)this.nextToken.asString()));
    }

    public Token expectStringLiteral(String message) throws IOException, ParseException {
        if (!this.hasNext()) {
            throw new ParseException("Expected %s, but got end of file", message);
        }
        if (this.nextToken.isStringLiteral()) {
            Token next = this.nextToken;
            this.nextToken = null;
            return next;
        }
        throw new ParseException(this, this.nextToken, "Expected %s, but got '%s'", message, Strings.escape((CharSequence)this.nextToken.asString()));
    }

    public Token expectInteger(String message) throws IOException, ParseException {
        if (!this.hasNext()) {
            throw new ParseException("Expected %s, but got end of file", message);
        }
        if (this.nextToken.isInteger()) {
            Token next = this.nextToken;
            this.nextToken = null;
            return next;
        }
        throw new ParseException(this, this.nextToken, "Expected integer, but found '%s' while %s", Strings.escape((CharSequence)this.nextToken.asString()), message);
    }

    public boolean hasNext() throws IOException, ParseException {
        if (this.nextToken == null) {
            this.nextToken = this.nextInternal();
        }
        return this.nextToken != null;
    }

    public Token next() throws IOException, ParseException {
        if (this.nextToken != null) {
            Token tmp = this.nextToken;
            this.nextToken = null;
            return tmp;
        }
        return this.nextInternal();
    }

    private Token nextStringLiteral(int startQuote) throws ParseException {
        int startOffset = this.readOffset;
        int startLinePos = this.linePos;
        boolean escaped = false;
        while (true) {
            int r;
            if ((r = this.read()) < 32 || r == 127) {
                int pos = startOffset - this.readOffset;
                if (r == -1) {
                    throw new ParseException(this, new Token(this.buffer, this.readOffset, 1, this.lineNo, startLinePos + pos), "Expected end of literal, but got end of file", new Object[0]);
                }
                throw new ParseException(this, new Token(this.buffer, this.readOffset, 1, this.lineNo, startLinePos + pos), "Invalid string literal char '" + Strings.escape((CharSequence)new String(new char[]{(char)r})) + "'", new Object[0]);
            }
            if (escaped) {
                escaped = false;
                continue;
            }
            if (r == 92) {
                escaped = true;
                continue;
            }
            if (startQuote == r) break;
        }
        return new Token(this.buffer, startOffset, this.readOffset - startOffset + 1, this.lineNo, startLinePos);
    }

    private Token nextInternal() throws IOException, ParseException {
        int r;
        int startOffset = this.readOffset;
        while ((r = this.read()) != -1) {
            if (r == 32 || r == 9 || r == 13 || r == 10) continue;
            startOffset = this.readOffset;
            break;
        }
        if (r < 0) {
            return null;
        }
        if ("{}:=()<>,;#[]".indexOf(r) >= 0) {
            return new Token(this.buffer, startOffset, 1, this.lineNo, this.linePos);
        }
        if (r == 39 || r == 34) {
            return this.nextStringLiteral(r);
        }
        if (r == 46 || r == 45 || r >= 48 && r <= 57) {
            return this.nextNumber(r);
        }
        if (r == 47) {
            int s = this.read();
            if (s == -1) {
                throw new ParseException(this, new Token(this.buffer, this.readOffset, 1, this.lineNo, this.linePos), "Expected java comment continuation, got end of stream", new Object[0]);
            }
            Token token = new Token(this.buffer, startOffset, 2, this.lineNo, this.linePos++);
            if (s == 47 || s == 42) {
                return token;
            }
            if (s < 32 || s >= 127) {
                throw new ParseException(this, token, "Invalid start of comment '/%s'", Strings.escape((CharSequence)String.valueOf((char)s)));
            }
            throw new ParseException(this, token, "Invalid start of comment '/%c'. Must be '/*' or '//'", Character.valueOf((char)s));
        }
        if (r == 95 || r >= 97 && r <= 122 || r >= 65 && r <= 90) {
            return this.nextIdentifier();
        }
        throw new ParseException(this, new Token(this.buffer, startOffset, this.readOffset - startOffset, this.lineNo, this.linePos), String.format("Unknown token initiator: %s", Strings.escape((CharSequence)String.valueOf((char)r))), new Object[0]);
    }

    private Token nextNumber(int lastByte) throws ParseException {
        int startLinePos = this.linePos;
        int startOffset = this.readOffset;
        int len = 0;
        if (lastByte == 45) {
            lastByte = this.read();
            ++len;
            if (lastByte < 0) {
                throw new ParseException("Unexpected end of stream on line " + this.lineNo, new Object[0]);
            }
            if (lastByte != 46 && (lastByte < 48 || lastByte > 57)) {
                throw new ParseException(this, new Token(this.buffer, startOffset, len, this.lineNo, startLinePos), "No decimal after negative indicator.", new Object[0]);
            }
        } else if (lastByte == 48) {
            lastByte = this.read();
            ++len;
            if (lastByte == 120) {
                while ((lastByte = this.read()) != -1) {
                    if (lastByte >= 48 && lastByte <= 57 || lastByte >= 97 && lastByte <= 102 || lastByte >= 65 && lastByte <= 70) {
                        ++len;
                        continue;
                    }
                    this.unread();
                    break;
                }
                return new Token(this.buffer, startOffset, len, this.lineNo, startLinePos);
            }
            while ((lastByte = this.read()) != -1) {
                if (lastByte >= 48 && lastByte <= 55) {
                    ++len;
                    continue;
                }
                this.unread();
                break;
            }
            return new Token(this.buffer, startOffset, len, this.lineNo, startLinePos);
        }
        while (lastByte >= 48 && lastByte <= 57) {
            ++len;
            lastByte = this.read();
            if (lastByte >= 0) continue;
        }
        if (lastByte == 46) {
            ++len;
            lastByte = this.read();
            if (lastByte >= 0) {
                while (lastByte >= 48 && lastByte <= 57) {
                    ++len;
                    lastByte = this.read();
                    if (lastByte >= 0) continue;
                }
            }
        }
        if (lastByte == 101 || lastByte == 69) {
            ++len;
            lastByte = this.read();
            if (lastByte >= 0) {
                if (lastByte == 45 || lastByte == 43) {
                    ++len;
                    lastByte = this.read();
                }
                while (lastByte >= 48 && lastByte <= 57) {
                    ++len;
                    lastByte = this.read();
                    if (lastByte >= 0) continue;
                }
            }
        }
        Token token = new Token(this.buffer, startOffset, len, this.lineNo, startLinePos);
        if (lastByte < 0 || lastByte == 32 || lastByte == 9 || lastByte == 10 || lastByte == 13 || lastByte == 58 || lastByte == 125 || lastByte == 44 || lastByte == 59 || lastByte == 47 || lastByte == 35 || lastByte == 41) {
            if ("{}:=()<>,;#[]".indexOf(lastByte) >= 0) {
                this.unread();
            }
            return token;
        }
        throw new ParseException(this, token, "Wrongly terminated number: %c.", Character.valueOf((char)lastByte));
    }

    private Token nextIdentifier() throws ParseException {
        int r;
        int startOffset = this.readOffset;
        int startLinePos = this.linePos;
        int len = 1;
        boolean dot = false;
        while ((r = this.read()) != -1) {
            if (r == 46) {
                if (dot) {
                    Token token = new Token(this.buffer, startOffset, len, this.lineNo, startLinePos);
                    throw new ParseException(this, token, "Identifier with double '..' at line %d pos %d", this.lineNo, startLinePos);
                }
                dot = true;
                ++len;
                continue;
            }
            dot = false;
            if (r == 95 || r >= 48 && r <= 57 || r >= 97 && r <= 122 || r >= 65 && r <= 90) {
                ++len;
                continue;
            }
            this.unread();
            break;
        }
        Token token = new Token(this.buffer, startOffset, len, this.lineNo, startLinePos);
        if (dot) {
            throw new ParseException(this, token, "Identifier trailing with '.' at line %d pos &d", this.lineNo, startLinePos);
        }
        if (r == -1 || r == 32 || r == 9 || r == 10 || r == 13 || r == 47 || "{}:=()<>,;#[]".indexOf(r) >= 0) {
            return token;
        }
        throw new ParseException(this, token, "Wrongly terminated identifier: %c.", Character.valueOf((char)r));
    }

    public String getLine(int line) throws IOException {
        if (line < 1) {
            throw new IllegalArgumentException("Oops!!!");
        }
        this.readOffset = -1;
        this.lineNo = 1;
        this.linePos = -1;
        while (--line > 0) {
            if (IOUtils.skipUntil((InputStream)this, (byte)10)) continue;
            throw new IOException("Oops");
        }
        return IOUtils.readString((InputStream)this, (String)"\n");
    }
}

