/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.reflect.parser.internal;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Objects;
import java.util.regex.Pattern;
import net.morimekta.util.Slice;

@SuppressFBWarnings(value={"MS_MUTABLE_ARRAY", "MS_PKGPROTECT"})
public class Token
extends Slice {
    public static final char kMessageStart = '{';
    public static final char kMessageEnd = '}';
    public static final char kFieldIdSep = ':';
    public static final char kFieldValueSep = '=';
    public static final char kParamsStart = '(';
    public static final char kParamsEnd = ')';
    public static final char kGenericStart = '<';
    public static final char kGenericEnd = '>';
    public static final char kLineSep1 = ',';
    public static final char kLineSep2 = ';';
    public static final char kLiteralEscape = '\\';
    public static final char kLiteralQuote = '\'';
    public static final char kLiteralDoubleQuote = '\"';
    public static final char kListStart = '[';
    public static final char kListEnd = ']';
    public static final char kJavaCommentStart = '/';
    public static final char kShellComment = '#';
    public static final String kSymbols = "{}:=()<>,;#[]";
    public static final byte[] kJavaComment = new byte[]{47, 47};
    public static final byte[] kBlockCommentStart = new byte[]{47, 42};
    public static final byte[] kBlockCommentEnd = new byte[]{42, 47};
    public static final byte[] kInclude = new byte[]{105, 110, 99, 108, 117, 100, 101};
    public static final byte[] kNamespace = new byte[]{110, 97, 109, 101, 115, 112, 97, 99, 101};
    public static final byte[] kEnum = new byte[]{101, 110, 117, 109};
    public static final byte[] kStruct = new byte[]{115, 116, 114, 117, 99, 116};
    public static final byte[] kUnion = new byte[]{117, 110, 105, 111, 110};
    public static final byte[] kException = new byte[]{101, 120, 99, 101, 112, 116, 105, 111, 110};
    public static final byte[] kService = new byte[]{115, 101, 114, 118, 105, 99, 101};
    public static final byte[] kConst = new byte[]{99, 111, 110, 115, 116};
    public static final byte[] kTypedef = new byte[]{116, 121, 112, 101, 100, 101, 102};
    public static final byte[] kRequired = new byte[]{114, 101, 113, 117, 105, 114, 101, 100};
    public static final byte[] kOptional = new byte[]{111, 112, 116, 105, 111, 110, 97, 108};
    public static final byte[] kOneway = new byte[]{111, 110, 101, 119, 97, 121};
    public static final byte[] kThrows = new byte[]{116, 104, 114, 111, 119, 115};
    public static final byte[] kExtends = new byte[]{101, 120, 116, 101, 110, 100, 115};
    public static final byte[] kVoid = new byte[]{118, 111, 105, 100};
    public static final byte[] kBool = new byte[]{98, 111, 111, 108};
    public static final byte[] kByte = new byte[]{98, 121, 116, 101};
    public static final byte[] kI8 = new byte[]{105, 56};
    public static final byte[] kI16 = new byte[]{105, 49, 54};
    public static final byte[] kI32 = new byte[]{105, 51, 50};
    public static final byte[] kI64 = new byte[]{105, 54, 52};
    public static final byte[] kDouble = new byte[]{100, 111, 117, 98, 108, 101};
    public static final byte[] kString = new byte[]{115, 116, 114, 105, 110, 103};
    public static final byte[] kBinary = new byte[]{98, 105, 110, 97, 114, 121};
    public static final byte[] kList = new byte[]{108, 105, 115, 116};
    public static final byte[] kSet = new byte[]{115, 101, 116};
    public static final byte[] kMap = new byte[]{109, 97, 112};
    private static final Pattern RE_IDENTIFIER = Pattern.compile("[_a-zA-Z][_a-zA-Z0-9]*");
    private static final Pattern RE_QUALIFIED_IDENTIFIER = Pattern.compile("([_a-zA-Z][_a-zA-Z0-9]*[.])*[_a-zA-Z][_a-zA-Z0-9]*");
    private static final Pattern RE_INTEGER = Pattern.compile("-?(0|[1-9][0-9]*|0[0-7]+|0x[0-9a-fA-F]+)");
    private static final Pattern RE_DOUBLE = Pattern.compile("-?((0|[1-9][0-9]*)[.]|([0-9]*[.][0-9][0-9]*))([eE][-+]?[0-9][0-9]*)?");
    private final int lineNo;
    private final int linePos;

    public Token(byte[] fb, int off, int len, int lineNo, int linePos) {
        super(fb, off, len);
        this.lineNo = lineNo;
        this.linePos = linePos;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !((Object)((Object)this)).getClass().equals(o.getClass())) {
            return false;
        }
        Token other = (Token)((Object)o);
        return super.equals(o) && this.lineNo == other.lineNo && this.linePos == other.linePos;
    }

    public int hashCode() {
        return Objects.hash(Token.class, super.hashCode(), this.lineNo, this.linePos);
    }

    public int getLineNo() {
        return this.lineNo;
    }

    public int getLinePos() {
        return this.linePos;
    }

    public boolean startsLineComment() {
        return this.isSymbol('#') || this.strEquals(kJavaComment);
    }

    public boolean startsBlockComment() {
        return this.strEquals(kBlockCommentStart);
    }

    public boolean isSymbol(char symbol) {
        return this.len == 1 && this.fb[this.off] == symbol;
    }

    public boolean isStringLiteral() {
        return this.length() > 1 && (this.charAt(0) == '\"' && this.charAt(-1) == '\"' || this.charAt(0) == '\'' && this.charAt(-1) == '\'');
    }

    public boolean isIdentifier() {
        return RE_IDENTIFIER.matcher(this.asString()).matches();
    }

    public boolean isQualifiedIdentifier() {
        return RE_QUALIFIED_IDENTIFIER.matcher(this.asString()).matches();
    }

    public boolean isInteger() {
        return RE_INTEGER.matcher(this.asString()).matches();
    }

    public boolean isDouble() {
        return RE_DOUBLE.matcher(this.asString()).matches();
    }

    public String decodeStringLiteral() {
        String tmp = this.substring(1, -1).asString();
        int l = tmp.length();
        StringBuilder out = new StringBuilder(l);
        boolean esc = false;
        for (int i = 0; i < l; ++i) {
            if (esc) {
                esc = false;
                char ch = tmp.charAt(i);
                switch (ch) {
                    case 'b': {
                        out.append('\b');
                        break;
                    }
                    case 'f': {
                        out.append('\f');
                        break;
                    }
                    case 'n': {
                        out.append('\n');
                        break;
                    }
                    case 'r': {
                        out.append('\r');
                        break;
                    }
                    case 't': {
                        out.append('\t');
                        break;
                    }
                    case '\"': 
                    case '\'': 
                    case '\\': {
                        out.append(ch);
                        break;
                    }
                    case 'u': {
                        if (l < i + 5) {
                            out.append('?');
                        } else {
                            String n = tmp.substring(i + 1, i + 5);
                            try {
                                int cp = Integer.parseInt(n, 16);
                                out.append((char)cp);
                            }
                            catch (NumberFormatException e) {
                                out.append('?');
                            }
                        }
                        i += 4;
                        break;
                    }
                    default: {
                        out.append('?');
                        break;
                    }
                }
                continue;
            }
            if (tmp.charAt(i) == '\\') {
                esc = true;
                continue;
            }
            out.append(tmp.charAt(i));
        }
        return out.toString();
    }

    public String toString() {
        return String.format("Token('%s',%d:%d-%d)", this.asString(), this.lineNo, this.linePos, this.linePos + this.len);
    }
}

