/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.reflect.parser.internal;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import net.morimekta.providence.PEnumBuilder;
import net.morimekta.providence.PEnumValue;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.PType;
import net.morimekta.providence.descriptor.PDeclaredDescriptor;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PEnumDescriptor;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PList;
import net.morimekta.providence.descriptor.PMap;
import net.morimekta.providence.descriptor.PSet;
import net.morimekta.providence.descriptor.PStructDescriptor;
import net.morimekta.providence.reflect.parser.ParseException;
import net.morimekta.providence.reflect.parser.internal.Token;
import net.morimekta.providence.reflect.parser.internal.Tokenizer;
import net.morimekta.providence.util.TypeRegistry;
import net.morimekta.util.Base64;
import net.morimekta.util.Strings;
import net.morimekta.util.json.JsonException;
import net.morimekta.util.json.JsonToken;
import net.morimekta.util.json.JsonTokenizer;

public class ConstParser {
    private final TypeRegistry registry;
    private final String program;

    public ConstParser(TypeRegistry registry, String program) {
        this.registry = registry;
        this.program = program;
    }

    public Object parse(InputStream inputStream, PDescriptor type) throws ParseException {
        try {
            Tokenizer tokenizer = new Tokenizer(inputStream);
            return this.parseTypedValue(tokenizer.expect("const value"), tokenizer, type);
        }
        catch (IOException e) {
            throw new ParseException(e, "Unable to read const data from input: " + e.getMessage(), new Object[0]);
        }
    }

    private <Message extends PMessage<Message, Field>, Field extends PField> Message parseMessage(Tokenizer tokenizer, PStructDescriptor<Message, Field> type) throws ParseException, IOException {
        Token token;
        PMessageBuilder builder = type.builder();
        if (tokenizer.peek("checking for empty").isSymbol('}')) {
            tokenizer.next();
            return (Message)((PMessage)builder.build());
        }
        do {
            PField field;
            if ((field = type.getField((token = tokenizer.expectStringLiteral("message field name")).decodeStringLiteral())) == null) {
                throw new ParseException(tokenizer, token, "Not a valid field name: " + token.decodeStringLiteral(), new Object[0]);
            }
            tokenizer.expectSymbol("parsing message key-value sep", ':');
            builder.set(field.getKey(), this.parseTypedValue(tokenizer.expect("parsing field value"), tokenizer, field.getDescriptor()));
            token = tokenizer.peek("optional line sep or message end");
            if (!token.isSymbol(',') && !token.isSymbol(';')) continue;
            tokenizer.next();
            token = tokenizer.peek("optional message end");
        } while (!token.isSymbol('}'));
        tokenizer.next();
        return (Message)((PMessage)builder.build());
    }

    private Object parseTypedValue(Token token, Tokenizer tokenizer, PDescriptor valueType) throws ParseException, IOException {
        switch (valueType.getType()) {
            case BOOL: {
                if (token.isIdentifier()) {
                    return Boolean.parseBoolean(token.asString());
                }
                if (token.isInteger()) {
                    return token.parseInteger() != 0L;
                }
                throw new ParseException(tokenizer, token, "Not boolean value for bool: " + token.asString(), new Object[0]);
            }
            case BYTE: {
                if (token.isInteger()) {
                    return (byte)token.parseInteger();
                }
                return (byte)this.findEnumValue(token.asString(), token, tokenizer, "byte");
            }
            case I16: {
                if (token.isInteger()) {
                    return (short)token.parseInteger();
                }
                return (short)this.findEnumValue(token.asString(), token, tokenizer, "i16");
            }
            case I32: {
                if (token.isInteger()) {
                    return (int)token.parseInteger();
                }
                return this.findEnumValue(token.asString(), token, tokenizer, "i32");
            }
            case I64: {
                if (token.isInteger()) {
                    return token.parseInteger();
                }
                return (long)this.findEnumValue(token.asString(), token, tokenizer, "i64");
            }
            case DOUBLE: {
                if (token.isInteger() || token.isDouble()) {
                    return token.parseDouble();
                }
                throw new ParseException(tokenizer, token, token.asString() + " is not a valid double value.", new Object[0]);
            }
            case STRING: {
                if (token.isStringLiteral()) {
                    return token.decodeStringLiteral();
                }
                throw new ParseException(tokenizer, token, "Not a valid string value.", new Object[0]);
            }
            case BINARY: {
                if (token.isStringLiteral()) {
                    return this.parseBinary(token.substring(1, -1).asString());
                }
                throw new ParseException(tokenizer, token, "Not a valid binary value.", new Object[0]);
            }
            case ENUM: {
                Object ev;
                PEnumBuilder eb = ((PEnumDescriptor)valueType).builder();
                String name = token.asString();
                if (name.startsWith(valueType.getName())) {
                    name = name.substring(valueType.getName().length() + 1);
                }
                if ((ev = eb.setByName(name).build()) == null) {
                    throw new ParseException(tokenizer, token, "No such " + valueType.getQualifiedName() + " enum value.", new Object[0]);
                }
                return ev;
            }
            case MESSAGE: {
                if (token.isSymbol('{')) {
                    return this.parseMessage(tokenizer, (PStructDescriptor)valueType);
                }
                throw new ParseException(tokenizer, token, "Not a valid message start.", new Object[0]);
            }
            case LIST: {
                Token sep;
                PDescriptor itemType = ((PList)valueType).itemDescriptor();
                LinkedList<Object> list = new LinkedList<Object>();
                if (tokenizer.peek("checking for empty list").isSymbol(']')) {
                    tokenizer.next();
                    return list;
                }
                do {
                    list.add(this.parseTypedValue(tokenizer.expect("list item value"), tokenizer, itemType));
                    sep = tokenizer.peek("optional item sep");
                    if (!sep.isSymbol(',') && !sep.isSymbol(';')) continue;
                    tokenizer.next();
                    sep = tokenizer.peek("check for set end");
                } while (!sep.isSymbol(']'));
                tokenizer.next();
                return list;
            }
            case SET: {
                Token sep;
                PDescriptor itemType = ((PSet)valueType).itemDescriptor();
                HashSet<Object> set = new HashSet<Object>();
                if (tokenizer.peek("checking for empty list").isSymbol(']')) {
                    tokenizer.next();
                    return set;
                }
                do {
                    set.add(this.parseTypedValue(tokenizer.expect("set item value"), tokenizer, itemType));
                    sep = tokenizer.peek("optional item sep");
                    if (!sep.isSymbol(',') && !sep.isSymbol(';')) continue;
                    tokenizer.next();
                    sep = tokenizer.peek("check for set end");
                } while (!sep.isSymbol(']'));
                tokenizer.next();
                return set;
            }
            case MAP: {
                Token sep;
                PDescriptor itemType = ((PMap)valueType).itemDescriptor();
                PDescriptor keyType = ((PMap)valueType).keyDescriptor();
                HashMap<Object, Object> map = new HashMap<Object, Object>();
                if (tokenizer.peek("checking for empty map").isSymbol('}')) {
                    tokenizer.next();
                    return map;
                }
                do {
                    Object key;
                    if ((token = tokenizer.expect("map key")).isStringLiteral()) {
                        key = this.parsePrimitiveKey(token.decodeStringLiteral(), token, tokenizer, keyType);
                    } else {
                        if (keyType.getType().equals((Object)PType.STRING) || keyType.getType().equals((Object)PType.BINARY)) {
                            throw new ParseException(tokenizer, token, "Expected string literal for string key", new Object[0]);
                        }
                        key = this.parsePrimitiveKey(token.asString(), token, tokenizer, keyType);
                    }
                    tokenizer.expectSymbol("map key-value separator", ':');
                    map.put(key, this.parseTypedValue(tokenizer.expect("map value"), tokenizer, itemType));
                    sep = tokenizer.peek("optional item sep");
                    if (!sep.isSymbol(',') && !sep.isSymbol(';')) continue;
                    tokenizer.next();
                    sep = tokenizer.peek("check for map end");
                } while (!sep.isSymbol('}'));
                tokenizer.next();
                return map;
            }
        }
        throw new IllegalArgumentException("Unhandled item type " + valueType.getQualifiedName());
    }

    private Object parsePrimitiveKey(String key, Token token, Tokenizer tokenizer, PDescriptor keyType) throws ParseException {
        switch (keyType.getType()) {
            case ENUM: {
                PEnumBuilder eb = ((PEnumDescriptor)keyType).builder();
                if (Strings.isInteger((String)key)) {
                    return eb.setByValue(Integer.parseInt(key)).build();
                }
                if (key.startsWith(keyType.getProgramName() + "." + keyType.getName() + ".")) {
                    key = key.substring(keyType.getProgramName().length() + keyType.getName().length() + 2);
                } else if (key.startsWith(keyType.getName() + ".")) {
                    key = key.substring(keyType.getName().length() + 1);
                }
                return eb.setByName(key).build();
            }
            case BOOL: {
                return Boolean.parseBoolean(key);
            }
            case BYTE: {
                if (Strings.isInteger((String)key)) {
                    return Byte.parseByte(key);
                }
                return (byte)this.findEnumValue(key, token, tokenizer, "byte");
            }
            case I16: {
                if (Strings.isInteger((String)key)) {
                    return Short.parseShort(key);
                }
                return (short)this.findEnumValue(key, token, tokenizer, "i16");
            }
            case I32: {
                if (Strings.isInteger((String)key)) {
                    return Integer.parseInt(key);
                }
                return this.findEnumValue(key, token, tokenizer, "i32");
            }
            case I64: {
                if (Strings.isInteger((String)key)) {
                    return Long.parseLong(key);
                }
                return (long)this.findEnumValue(key, token, tokenizer, "i64");
            }
            case DOUBLE: {
                try {
                    ByteArrayInputStream bais = new ByteArrayInputStream(key.getBytes(StandardCharsets.US_ASCII));
                    JsonTokenizer tokener = new JsonTokenizer((InputStream)bais);
                    JsonToken jt = tokener.expect("parsing double value");
                    return jt.doubleValue();
                }
                catch (IOException | JsonException e) {
                    throw new ParseException(e, "Unable to parse double value", new Object[0]);
                }
            }
            case STRING: {
                return key;
            }
            case BINARY: {
                return this.parseBinary(key);
            }
        }
        throw new ParseException("Illegal key type: " + keyType.getType(), new Object[0]);
    }

    private int findEnumValue(String identifier, Token token, Tokenizer tokenizer, String expectedType) throws ParseException {
        PEnumDescriptor desc;
        PEnumValue value;
        String valueName;
        String typeName;
        String[] parts = identifier.split("[.]");
        if (parts.length == 3) {
            typeName = parts[0] + "." + parts[1];
            valueName = parts[2];
        } else if (parts.length == 2) {
            typeName = parts[0];
            valueName = parts[1];
        } else {
            throw new ParseException(tokenizer, token, identifier + " is not a valid " + expectedType + " value.", new Object[0]);
        }
        PDeclaredDescriptor descriptor = this.registry.getDeclaredType(typeName, this.program);
        if (descriptor != null && descriptor instanceof PEnumDescriptor && (value = (desc = (PEnumDescriptor)descriptor).getValueByName(valueName)) != null) {
            return value.getValue();
        }
        throw new ParseException(tokenizer, token, identifier + " is not a valid " + expectedType + " value.", new Object[0]);
    }

    private byte[] parseBinary(String value) {
        return Base64.decode((String)value);
    }
}

