/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.reflect.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import net.morimekta.providence.descriptor.PDeclaredDescriptor;
import net.morimekta.providence.descriptor.PDescriptorProvider;
import net.morimekta.providence.descriptor.PEnumDescriptor;
import net.morimekta.providence.descriptor.PPrimitive;
import net.morimekta.providence.descriptor.PRequirement;
import net.morimekta.providence.descriptor.PServiceProvider;
import net.morimekta.providence.model.ConstType;
import net.morimekta.providence.model.Declaration;
import net.morimekta.providence.model.EnumType;
import net.morimekta.providence.model.EnumValue;
import net.morimekta.providence.model.FieldType;
import net.morimekta.providence.model.FunctionType;
import net.morimekta.providence.model.MessageType;
import net.morimekta.providence.model.ProgramType;
import net.morimekta.providence.model.ServiceType;
import net.morimekta.providence.reflect.contained.CConst;
import net.morimekta.providence.reflect.contained.CEnumDescriptor;
import net.morimekta.providence.reflect.contained.CEnumValue;
import net.morimekta.providence.reflect.contained.CExceptionDescriptor;
import net.morimekta.providence.reflect.contained.CField;
import net.morimekta.providence.reflect.contained.CProgram;
import net.morimekta.providence.reflect.contained.CService;
import net.morimekta.providence.reflect.contained.CServiceMethod;
import net.morimekta.providence.reflect.contained.CStructDescriptor;
import net.morimekta.providence.reflect.contained.CUnionDescriptor;
import net.morimekta.providence.reflect.util.ConstProvider;
import net.morimekta.providence.reflect.util.ProgramRegistry;

public class ProgramConverter {
    private final ProgramRegistry registry;

    public ProgramConverter(ProgramRegistry registry) {
        this.registry = registry;
    }

    public CProgram convert(ProgramType document) {
        ImmutableList.Builder declaredTypes = ImmutableList.builder();
        ImmutableList.Builder constants = ImmutableList.builder();
        ImmutableMap.Builder typedefs = ImmutableMap.builder();
        ImmutableList.Builder services = ImmutableList.builder();
        for (Declaration decl : document.getDecl()) {
            switch (decl.unionField()) {
                case DECL_ENUM: {
                    EnumType enumType = decl.getDeclEnum();
                    int nextValue = 0;
                    Object type = new CEnumDescriptor(enumType.getDocumentation(), document.getProgramName(), enumType.getName(), enumType.getAnnotations());
                    LinkedList<CEnumValue> values = new LinkedList<CEnumValue>();
                    for (EnumValue enumValue : enumType.getValues()) {
                        int v = enumValue.hasValue() ? enumValue.getValue() : nextValue;
                        nextValue = v + 1;
                        values.add(new CEnumValue(enumValue.getDocumentation(), enumValue.getValue(), enumValue.getName(), (PEnumDescriptor<CEnumValue>)type, enumValue.getAnnotations()));
                    }
                    ((CEnumDescriptor)type).setValues(values);
                    declaredTypes.add(type);
                    this.registry.putDeclaredType((PDeclaredDescriptor)type);
                    break;
                }
                case DECL_STRUCT: {
                    Object type;
                    MessageType messageType = decl.getDeclStruct();
                    LinkedList<CField> fields = new LinkedList<CField>();
                    if (messageType.hasFields()) {
                        fields.addAll(messageType.getFields().stream().map(field -> this.makeField(document.getProgramName(), (FieldType)field)).collect(Collectors.toList()));
                    }
                    switch (messageType.getVariant()) {
                        case STRUCT: {
                            type = new CStructDescriptor(messageType.getDocumentation(), document.getProgramName(), messageType.getName(), fields, messageType.getAnnotations());
                            break;
                        }
                        case UNION: {
                            type = new CUnionDescriptor(messageType.getDocumentation(), document.getProgramName(), messageType.getName(), fields, messageType.getAnnotations());
                            break;
                        }
                        case EXCEPTION: {
                            type = new CExceptionDescriptor(messageType.getDocumentation(), document.getProgramName(), messageType.getName(), fields, messageType.getAnnotations());
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Unhandled struct type " + (Object)((Object)messageType.getVariant()));
                        }
                    }
                    declaredTypes.add(type);
                    this.registry.putDeclaredType((PDeclaredDescriptor)type);
                    break;
                }
                case DECL_CONST: {
                    ConstType constant = decl.getDeclConst();
                    constants.add((Object)this.makeConst(document.getProgramName(), constant));
                    break;
                }
                case DECL_TYPEDEF: {
                    typedefs.put((Object)decl.getDeclTypedef().getName(), (Object)decl.getDeclTypedef().getType());
                    this.registry.putTypedef(decl.getDeclTypedef().getName(), document.getProgramName(), decl.getDeclTypedef().getType());
                    break;
                }
                case DECL_SERVICE: {
                    ServiceType serviceType = decl.getDeclService();
                    ImmutableList.Builder methodBuilder = ImmutableList.builder();
                    for (FunctionType sm : serviceType.getMethods()) {
                        LinkedList<CField> rqFields = new LinkedList<CField>();
                        if (sm.numParams() > 0) {
                            for (FieldType field2 : sm.getParams()) {
                                rqFields.add(this.makeField(document.getProgramName(), field2));
                            }
                        }
                        CStructDescriptor cStructDescriptor = new CStructDescriptor(null, document.getProgramName(), sm.getName() + "___request", rqFields, null);
                        CUnionDescriptor response = null;
                        if (!sm.isOneWay()) {
                            CField success;
                            LinkedList<CField> rsFields = new LinkedList<CField>();
                            if (sm.getReturnType() != null) {
                                PDescriptorProvider type = this.registry.getProvider(sm.getReturnType(), document.getProgramName(), sm.getAnnotations());
                                success = new CField(null, 0, PRequirement.OPTIONAL, "success", type, null, null);
                            } else {
                                success = new CField(null, 0, PRequirement.OPTIONAL, "success", (PDescriptorProvider)PPrimitive.VOID.provider(), null, null);
                            }
                            rsFields.add(success);
                            if (sm.numExceptions() > 0) {
                                for (FieldType field3 : sm.getExceptions()) {
                                    rsFields.add(this.makeField(document.getProgramName(), field3));
                                }
                            }
                            response = new CUnionDescriptor(null, document.getProgramName(), sm.getName() + "___response", rsFields, null);
                        }
                        CServiceMethod method = new CServiceMethod(sm.getDocumentation(), sm.getName(), sm.isOneWay(), cStructDescriptor, response, sm.getAnnotations());
                        methodBuilder.add((Object)method);
                    }
                    PServiceProvider extendsProvider = null;
                    if (serviceType.hasExtend()) {
                        extendsProvider = this.registry.getServiceProvider(serviceType.getExtend(), document.getProgramName());
                    }
                    CService service = new CService(serviceType.getDocumentation(), document.getProgramName(), serviceType.getName(), extendsProvider, (Collection<CServiceMethod>)methodBuilder.build(), serviceType.getAnnotations());
                    services.add((Object)service);
                    this.registry.putService(service);
                }
            }
        }
        return new CProgram(document.getDocumentation(), document.getProgramName(), document.getNamespaces(), (Collection<String>)this.getIncludedProgramNames(document), (Collection<String>)document.getIncludes(), (Map<String, String>)typedefs.build(), (Collection<PDeclaredDescriptor<?>>)declaredTypes.build(), (Collection<CService>)services.build(), (Collection<CConst>)constants.build());
    }

    private Set<String> getIncludedProgramNames(ProgramType document) {
        TreeSet<String> out = new TreeSet<String>();
        for (String include : document.getIncludes()) {
            int i = include.lastIndexOf(46);
            if (i > 0) {
                include = include.substring(0, i);
            }
            if (include.contains("/")) {
                include = include.replaceAll(".*[/]", "");
            }
            out.add(include);
        }
        return out;
    }

    private CConst makeConst(String pkg, ConstType field) {
        PDescriptorProvider type = this.registry.getProvider(field.getType(), pkg, field.getAnnotations());
        ConstProvider defaultValue = null;
        if (field.hasValue()) {
            defaultValue = new ConstProvider(this.registry, field.getType(), pkg, field.getValue());
        }
        CConst made = new CConst(field.getDocumentation(), field.getName(), type, defaultValue, field.getAnnotations());
        return made;
    }

    private CField makeField(String pkg, FieldType field) {
        PDescriptorProvider type = this.registry.getProvider(field.getType(), pkg, field.getAnnotations());
        ConstProvider defaultValue = null;
        if (field.hasDefaultValue()) {
            defaultValue = new ConstProvider(this.registry, field.getType(), pkg, field.getDefaultValue());
        }
        CField made = new CField(field.getDocumentation(), field.getKey(), PRequirement.valueOf((String)field.getRequirement().getName()), field.getName(), type, defaultValue, field.getAnnotations());
        return made;
    }
}

