/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.reflect.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PValueProvider;
import net.morimekta.providence.reflect.parser.ParseException;
import net.morimekta.providence.reflect.parser.internal.ConstParser;
import net.morimekta.providence.reflect.util.ProgramRegistry;

public class ConstProvider
implements PValueProvider<Object> {
    private final ProgramRegistry mRegistry;
    private final String mTypeName;
    private final String mPackageContext;
    private final String mDefaultValue;
    private Object mParsedValue;

    public ConstProvider(ProgramRegistry registry, String typeName, String packageContext, String defaultValue) {
        this.mRegistry = registry;
        this.mTypeName = typeName;
        this.mPackageContext = packageContext;
        this.mDefaultValue = defaultValue;
        this.mParsedValue = null;
    }

    public Object get() {
        if (this.mParsedValue == null) {
            ConstParser parser = new ConstParser();
            PDescriptor type = this.mRegistry.getProvider(this.mTypeName, this.mPackageContext, Collections.EMPTY_MAP).descriptor();
            try (ByteArrayInputStream in = new ByteArrayInputStream(this.mDefaultValue.getBytes(StandardCharsets.UTF_8));){
                this.mParsedValue = parser.parse(in, type);
            }
            catch (IOException | ParseException e) {
                e.printStackTrace();
            }
        }
        return this.mParsedValue;
    }
}

