/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.reflect.parser.internal;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import net.morimekta.providence.PEnumBuilder;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.PType;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PEnumDescriptor;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PList;
import net.morimekta.providence.descriptor.PMap;
import net.morimekta.providence.descriptor.PSet;
import net.morimekta.providence.descriptor.PStructDescriptor;
import net.morimekta.providence.reflect.parser.ParseException;
import net.morimekta.util.Base64;
import net.morimekta.util.Strings;
import net.morimekta.util.json.JsonException;
import net.morimekta.util.json.JsonToken;
import net.morimekta.util.json.JsonTokenizer;

public class ConstParser {
    public Object parse(InputStream inputStream, PDescriptor type) throws ParseException {
        try {
            JsonTokenizer tokenizer = new JsonTokenizer(inputStream);
            return this.parseTypedValue(tokenizer.expect("const value"), tokenizer, type);
        }
        catch (JsonException e) {
            throw new ParseException(e, "Unable to parse JSON: " + e.getMessage(), new Object[0]);
        }
        catch (IOException e) {
            throw new ParseException(e, "Unable to read JSON data from input: " + e.getMessage(), new Object[0]);
        }
    }

    private <Message extends PMessage<Message, Field>, Field extends PField> Message parseMessage(JsonTokenizer tokenizer, PStructDescriptor<Message, Field> type) throws IOException, JsonException {
        PMessageBuilder builder = type.builder();
        if (tokenizer.peek("checking for empty").isSymbol('}')) {
            tokenizer.next();
            return (Message)((PMessage)builder.build());
        }
        int sep = 123;
        while (sep != 125) {
            JsonToken token = tokenizer.expectString("message field name");
            PField field = type.getField(token.substring(1, -1).asString());
            if (field == null) {
                throw new JsonException("Not a valid field name: " + token.substring(1, -1));
            }
            tokenizer.expectSymbol("parsing message key-value sep", new char[]{':'});
            builder.set(field.getKey(), this.parseTypedValue(tokenizer.expect("parsing field value"), tokenizer, field.getDescriptor()));
            sep = tokenizer.expectSymbol("", new char[]{',', '}'});
        }
        return (Message)((PMessage)builder.build());
    }

    private Object parseTypedValue(JsonToken token, JsonTokenizer tokenizer, PDescriptor valueType) throws IOException, JsonException {
        switch (valueType.getType()) {
            case BOOL: {
                if (token.isBoolean()) {
                    return token.booleanValue();
                }
                if (token.isInteger()) {
                    return token.longValue() != 0L;
                }
                throw new JsonException("Not boolean value for bool: " + token.asString(), tokenizer, token);
            }
            case BYTE: {
                if (token.isInteger()) {
                    return token.byteValue();
                }
                throw new JsonException(token.asString() + " is not a valid byte value.", tokenizer, token);
            }
            case I16: {
                if (token.isInteger()) {
                    return token.shortValue();
                }
                throw new JsonException(token.asString() + " is not a valid short value.", tokenizer, token);
            }
            case I32: {
                if (token.isInteger()) {
                    return token.intValue();
                }
                throw new JsonException(token.asString() + " is not a valid int value.", tokenizer, token);
            }
            case I64: {
                if (token.isInteger()) {
                    return token.longValue();
                }
                throw new JsonException(token.asString() + " is not a valid long value.", tokenizer, token);
            }
            case DOUBLE: {
                if (token.isInteger() || token.isDouble()) {
                    return token.doubleValue();
                }
                throw new JsonException(token.asString() + " is not a valid double value.", tokenizer, token);
            }
            case STRING: {
                if (token.isLiteral()) {
                    return token.decodeJsonLiteral();
                }
                throw new JsonException("Not a valid string value.", tokenizer, token);
            }
            case BINARY: {
                if (token.isLiteral()) {
                    return this.parseBinary(token.substring(1, -1).asString());
                }
                throw new JsonException("Not a valid binary value.", tokenizer, token);
            }
            case ENUM: {
                Object ev;
                PEnumBuilder eb = ((PEnumDescriptor)valueType).builder();
                String name = token.asString();
                if (name.startsWith(valueType.getName())) {
                    name = name.substring(valueType.getName().length() + 1);
                }
                if ((ev = eb.setByName(name).build()) == null) {
                    throw new JsonException("No such " + valueType.getQualifiedName(null) + " enum value.", tokenizer, token);
                }
                return ev;
            }
            case MESSAGE: {
                if (token.isSymbol('{')) {
                    return this.parseMessage(tokenizer, (PStructDescriptor)valueType);
                }
                throw new JsonException("Not a valid message start.", tokenizer, token);
            }
            case LIST: {
                PDescriptor itemType = ((PList)valueType).itemDescriptor();
                LinkedList<Object> list = new LinkedList<Object>();
                if (tokenizer.peek("checking for empty list").isSymbol(']')) {
                    return list;
                }
                int sep = 91;
                while (sep != 93) {
                    list.add(this.parseTypedValue(tokenizer.expect("list item value"), tokenizer, itemType));
                    sep = tokenizer.expectSymbol("parsing list item separator", new char[]{']', ','});
                }
                return list;
            }
            case SET: {
                PDescriptor itemType = ((PSet)valueType).itemDescriptor();
                HashSet<Object> set = new HashSet<Object>();
                if (tokenizer.peek("checking for empty list").isSymbol(']')) {
                    return set;
                }
                int sep = 91;
                while (sep != 93) {
                    set.add(this.parseTypedValue(tokenizer.expect("set item value"), tokenizer, itemType));
                    sep = tokenizer.expectSymbol("parsing set item separator", new char[]{']', ','});
                }
                return set;
            }
            case MAP: {
                PDescriptor itemType = ((PMap)valueType).itemDescriptor();
                PDescriptor keyType = ((PMap)valueType).keyDescriptor();
                HashMap<Object, Object> map = new HashMap<Object, Object>();
                if (tokenizer.peek("checking for empty map").isSymbol('}')) {
                    return map;
                }
                int sep = 123;
                while (sep != 125) {
                    Object key;
                    if (token.isLiteral()) {
                        key = this.parsePrimitiveKey(token.decodeJsonLiteral(), keyType);
                    } else {
                        if (keyType.getType().equals((Object)PType.STRING) || keyType.getType().equals((Object)PType.BINARY)) {
                            throw new JsonException("Expected string literal for string key", tokenizer, token);
                        }
                        key = this.parsePrimitiveKey(token.asString(), keyType);
                    }
                    tokenizer.expectSymbol("parsing map (kv)", new char[]{':'});
                    map.put(key, this.parseTypedValue(tokenizer.expect("parsing map value."), tokenizer, itemType));
                    sep = tokenizer.expectSymbol("parsing set item separator", new char[]{'}', ','});
                }
                return map;
            }
        }
        throw new IllegalArgumentException("Unhandled item type " + valueType.getQualifiedName(null));
    }

    private Object parsePrimitiveKey(String key, PDescriptor keyType) throws IOException {
        switch (keyType.getType()) {
            case ENUM: {
                PEnumBuilder eb = ((PEnumDescriptor)keyType).builder();
                if (Strings.isInteger((String)key)) {
                    return eb.setByValue(Integer.parseInt(key)).build();
                }
                if (key.startsWith(keyType.getName())) {
                    key = key.substring(keyType.getName().length() + 1);
                }
                return eb.setByName(key).build();
            }
            case BOOL: {
                return Boolean.parseBoolean(key);
            }
            case BYTE: {
                return Byte.parseByte(key);
            }
            case I16: {
                return Short.parseShort(key);
            }
            case I32: {
                return Integer.parseInt(key);
            }
            case I64: {
                return Long.parseLong(key);
            }
            case DOUBLE: {
                try {
                    ByteArrayInputStream bais = new ByteArrayInputStream(key.getBytes(StandardCharsets.US_ASCII));
                    JsonTokenizer tokener = new JsonTokenizer((InputStream)bais);
                    JsonToken token = tokener.expect("parsing double value");
                    return token.doubleValue();
                }
                catch (JsonException e) {
                    throw new IllegalArgumentException("Unable to parse double from key \"" + key + "\"", e);
                }
            }
            case STRING: {
                return key;
            }
            case BINARY: {
                return this.parseBinary(key);
            }
        }
        throw new IllegalArgumentException("Illegal key type: " + keyType.getType());
    }

    private byte[] parseBinary(String value) throws IOException {
        return Base64.decode((String)value);
    }
}

