/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.reflect.contained;

import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.PType;
import net.morimekta.providence.PUnion;
import net.morimekta.providence.descriptor.PList;
import net.morimekta.providence.descriptor.PMap;
import net.morimekta.providence.descriptor.PSet;
import net.morimekta.providence.descriptor.PStructDescriptor;
import net.morimekta.providence.reflect.contained.CField;
import net.morimekta.providence.reflect.contained.CMessage;
import net.morimekta.providence.reflect.contained.CUnionDescriptor;

public class CUnion
extends CMessage<CUnion, CField>
implements PUnion<CUnion, CField> {
    private final CUnionDescriptor descriptor;
    private final CField unionField;

    private CUnion(Builder builder) {
        super(builder.getValueMap());
        this.unionField = builder.unionField;
        this.descriptor = builder.descriptor;
    }

    public PMessageBuilder<CUnion, CField> mutate() {
        return new Builder(this.descriptor);
    }

    public CUnionDescriptor descriptor() {
        return this.descriptor;
    }

    public CField unionField() {
        return this.unionField;
    }

    public static class Builder
    extends PMessageBuilder<CUnion, CField> {
        private final CUnionDescriptor descriptor;
        private CField unionField;
        private Object currentValue;

        public Builder(CUnionDescriptor descriptor) {
            this.descriptor = descriptor;
        }

        private Map<Integer, Object> getValueMap() {
            if (this.unionField == null) {
                return ImmutableMap.of();
            }
            if (this.currentValue == null) {
                throw new IllegalStateException("Union field set, but value is null.");
            }
            switch (this.unionField.getType()) {
                case LIST: {
                    return ImmutableMap.of((Object)this.unionField.getKey(), (Object)((PList.Builder)this.currentValue).build());
                }
                case SET: {
                    return ImmutableMap.of((Object)this.unionField.getKey(), (Object)((PSet.Builder)this.currentValue).build());
                }
                case MAP: {
                    return ImmutableMap.of((Object)this.unionField.getKey(), (Object)((PMap.Builder)this.currentValue).build());
                }
                case MESSAGE: {
                    if (!(this.currentValue instanceof PMessageBuilder)) break;
                    return ImmutableMap.of((Object)this.unionField.getKey(), (Object)((PMessageBuilder)this.currentValue).build());
                }
            }
            return ImmutableMap.of((Object)this.unionField.getKey(), (Object)this.currentValue);
        }

        public PMessageBuilder mutator(int key) {
            CField field = this.descriptor.getField(key);
            if (field == null) {
                throw new IllegalArgumentException("No such unionField ID " + key);
            }
            if (field.getType() != PType.MESSAGE) {
                throw new IllegalArgumentException("Not a message unionField ID " + key + ": " + field.getName());
            }
            if (this.unionField != field) {
                this.unionField = field;
                this.currentValue = null;
            }
            if (this.currentValue == null) {
                this.currentValue = ((PStructDescriptor)field.getDescriptor()).builder();
            } else if (this.currentValue instanceof PMessage) {
                this.currentValue = ((PMessage)this.currentValue).mutate();
            } else if (!(this.currentValue instanceof PMessageBuilder)) {
                throw new IllegalArgumentException("Invalid currentValue in map on message type: " + this.currentValue.getClass().getSimpleName());
            }
            return (PMessageBuilder)this.currentValue;
        }

        public Builder merge(CUnion from) {
            if (this.unionField == null || this.unionField != from.unionField()) {
                this.set(from.unionField.getKey(), from.get(from.unionField.getKey()));
            } else {
                int key = this.unionField.getKey();
                switch (this.unionField.getType()) {
                    case MESSAGE: {
                        PMessage src = (PMessage)this.currentValue;
                        PMessage toMerge = (PMessage)from.get(key);
                        this.currentValue = src.mutate().merge(toMerge).build();
                        break;
                    }
                    case SET: {
                        ((PSet.Builder)this.currentValue).addAll((Collection)((Set)from.get(key)));
                        break;
                    }
                    case MAP: {
                        ((PMap.Builder)this.currentValue).putAll((Map)from.get(key));
                        break;
                    }
                    default: {
                        this.set(key, from.get(key));
                    }
                }
            }
            return this;
        }

        public PStructDescriptor<CUnion, CField> descriptor() {
            return this.descriptor;
        }

        public CUnion build() {
            return new CUnion(this);
        }

        public boolean isValid() {
            return this.unionField != null;
        }

        public void validate() {
            if (!this.isValid()) {
                throw new IllegalStateException("No union field set in " + this.descriptor().getQualifiedName(null));
            }
        }

        public Builder set(int key, Object value) {
            CField field = this.descriptor.getField(key);
            if (field == null) {
                return this;
            }
            if (value == null) {
                return this.clear(key);
            }
            this.unionField = field;
            switch (field.getType()) {
                case SET: {
                    this.currentValue = ((PSet)field.getDescriptor()).builder().addAll((Collection)value);
                    break;
                }
                case LIST: {
                    this.currentValue = ((PList)field.getDescriptor()).builder().addAll((Collection)value);
                    break;
                }
                case MAP: {
                    this.currentValue = ((PMap)field.getDescriptor()).builder().putAll((Map)value);
                    break;
                }
                default: {
                    this.currentValue = value;
                }
            }
            return this;
        }

        public Builder addTo(int key, Object value) {
            CField field = this.descriptor.getField(key);
            if (field == null) {
                return this;
            }
            if (this.unionField != field || this.currentValue == null) {
                this.unionField = field;
                switch (field.getType()) {
                    case LIST: {
                        PList lType = (PList)field.getDescriptor();
                        this.currentValue = lType.builder();
                        break;
                    }
                    case SET: {
                        PSet lType = (PSet)field.getDescriptor();
                        this.currentValue = lType.builder();
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unable to accept addTo on non-list unionField " + field.getName());
                    }
                }
            }
            if (value == null) {
                throw new IllegalArgumentException("Adding null item to collection " + field.getName());
            }
            switch (field.getType()) {
                case LIST: {
                    ((PList.Builder)this.currentValue).add(value);
                    break;
                }
                case SET: {
                    ((PList.Builder)this.currentValue).add(value);
                    break;
                }
            }
            return this;
        }

        public Builder clear(int key) {
            if (this.unionField != null && this.unionField.getKey() == key) {
                this.unionField = null;
                this.currentValue = null;
            }
            return this;
        }
    }
}

