/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.reflect.contained;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.morimekta.providence.descriptor.PDeclaredDescriptor;
import net.morimekta.providence.reflect.contained.CConst;
import net.morimekta.providence.reflect.contained.CService;

public class CProgram {
    private final String comment;
    private final String programName;
    private final Set<String> includedPrograms;
    private final List<String> includedFiles;
    private final Map<String, String> namespaces;
    private final Map<String, String> typedefs;
    private final List<PDeclaredDescriptor<?>> declaredTypes;
    private final List<CService> services;
    private final List<CConst> constants;

    public CProgram(String comment, String programName, Map<String, String> namespaces, Collection<String> includedPrograms, Collection<String> includedFies, Map<String, String> typedefs, Collection<PDeclaredDescriptor<?>> declaredTypes, Collection<CService> services, Collection<CConst> constants) {
        this.comment = comment;
        this.programName = programName;
        this.namespaces = ImmutableMap.copyOf(namespaces);
        this.includedPrograms = ImmutableSet.copyOf(includedPrograms);
        this.includedFiles = ImmutableList.copyOf(includedFies);
        this.typedefs = ImmutableMap.copyOf(typedefs);
        this.declaredTypes = ImmutableList.copyOf(declaredTypes);
        this.services = ImmutableList.copyOf(services);
        this.constants = ImmutableList.copyOf(constants);
    }

    public String getComment() {
        return this.comment;
    }

    public String getProgramName() {
        return this.programName;
    }

    public Set<String> getIncludedPrograms() {
        return this.includedPrograms;
    }

    public List<String> getIncludedFiles() {
        return this.includedFiles;
    }

    public Map<String, String> getNamespaces() {
        return this.namespaces;
    }

    public Map<String, String> getTypedefs() {
        return this.typedefs;
    }

    public List<PDeclaredDescriptor<?>> getDeclaredTypes() {
        return this.declaredTypes;
    }

    public List<CService> getServices() {
        return this.services;
    }

    public List<CConst> getConstants() {
        return this.constants;
    }

    public String getNamespaceForLanguage(String language) {
        return this.namespaces.get(language);
    }
}

