/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.reflect.contained;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.morimekta.providence.PEnumValue;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PPrimitive;
import net.morimekta.providence.descriptor.PStructDescriptor;
import net.morimekta.providence.serializer.PrettySerializer;
import net.morimekta.util.Binary;

public abstract class CMessage<Message extends PMessage<Message, Field>, Field extends PField>
implements PMessage<Message, Field> {
    private static final PrettySerializer PRETTY_SERIALIZER = new PrettySerializer("", "", "", ",", true, false);
    private final Map<Integer, Object> values;

    CMessage(Map<Integer, Object> fields) {
        this.values = fields;
    }

    public boolean has(int key) {
        PField field = this.descriptor().getField(key);
        if (field == null) {
            return false;
        }
        return this.values.containsKey(key);
    }

    public int num(int key) {
        PField field = this.descriptor().getField(key);
        if (field == null) {
            return 0;
        }
        if (!this.values.containsKey(key)) {
            return 0;
        }
        switch (field.getDescriptor().getType()) {
            case MAP: {
                return ((Map)this.values.get(key)).size();
            }
            case LIST: 
            case SET: {
                return ((Collection)this.values.get(key)).size();
            }
        }
        return 0;
    }

    public Object get(int key) {
        PField field = this.descriptor().getField(key);
        if (field != null) {
            Object value = this.values.get(key);
            if (value != null) {
                return value;
            }
            if (field.hasDefaultValue()) {
                return field.getDefaultValue();
            }
            if (field.getDescriptor() instanceof PPrimitive) {
                return ((PPrimitive)field.getDescriptor()).getDefaultValue();
            }
        }
        return null;
    }

    public boolean compact() {
        if (!this.descriptor().isCompactible()) {
            return false;
        }
        boolean missing = false;
        for (PField field : this.descriptor().getFields()) {
            if (this.has(field.getKey())) {
                if (!missing) continue;
                return false;
            }
            missing = true;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof CMessage)) {
            return false;
        }
        CMessage other = (CMessage)o;
        PStructDescriptor type = other.descriptor();
        if (!this.descriptor().getQualifiedName(null).equals(type.getQualifiedName(null)) || !this.descriptor().getVariant().equals((Object)type.getVariant())) {
            return false;
        }
        for (PField field : this.descriptor().getFields()) {
            int id = field.getKey();
            if (this.has(id) != other.has(id)) {
                return false;
            }
            if (Objects.equals(this.get(id), other.get(id))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        for (Map.Entry<Integer, Object> entry : this.values.entrySet()) {
            PField field = this.descriptor().getField(entry.getKey().intValue());
            hash += Objects.hash(field, entry.getValue());
        }
        return hash;
    }

    public int compareTo(Message other) {
        return CMessage.compare(this, other);
    }

    public String toString() {
        return this.descriptor().getQualifiedName(null) + this.asString();
    }

    public String asString() {
        return CMessage.asString(this);
    }

    protected static <T extends PMessage<T, F>, F extends PField> String asString(T message) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PRETTY_SERIALIZER.serialize((OutputStream)baos, message);
        return new String(baos.toByteArray(), StandardCharsets.UTF_8);
    }

    protected static <T extends Comparable<T>> int compare(T o1, T o2) {
        if (o1 == null || o2 == null) {
            return Boolean.compare(o1 != null, o2 != null);
        }
        if (o1 instanceof Boolean && o2 instanceof Boolean) {
            return Boolean.compare((Boolean)o1, (Boolean)o2);
        }
        if (o1 instanceof Short && o2 instanceof Short) {
            return Short.compare((Short)o1, (Short)o2);
        }
        if (o1 instanceof Integer && o2 instanceof Integer) {
            return Integer.compare((Integer)o1, (Integer)o2);
        }
        if (o1 instanceof Long && o2 instanceof Long) {
            return Long.compare((Long)o1, (Long)o2);
        }
        if (o1 instanceof Double && o2 instanceof Double) {
            return Double.compare((Double)o1, (Double)o2);
        }
        if (o1 instanceof String && o2 instanceof String) {
            return ((String)((Object)o1)).compareTo((String)((Object)o2));
        }
        if (o1 instanceof Binary && o2 instanceof Binary) {
            return ((Binary)o1).compareTo((Binary)o2);
        }
        if (o1 instanceof PEnumValue && o2 instanceof PEnumValue) {
            return Integer.compare(((PEnumValue)o1).getValue(), ((PEnumValue)o2).getValue());
        }
        if (o1 instanceof PMessage && o2 instanceof PMessage) {
            return CMessage.compareMessages((PMessage)o1, (PMessage)o2);
        }
        if (o1 instanceof Map && o2 instanceof Map || o1 instanceof Set && o2 instanceof Set || !(o1 instanceof List) || o2 instanceof List) {
            // empty if block
        }
        return 0;
    }

    private static <T extends PMessage<T, F>, F extends PField> int compareMessages(T m1, T m2) {
        int c = 0;
        c = m1.descriptor().getQualifiedName(null).compareTo(m2.descriptor().getQualifiedName(null));
        if (c != 0) {
            return c;
        }
        for (PField field : m1.descriptor().getFields()) {
            c = Boolean.compare(m1.has(field.getKey()), m2.has(field.getKey()));
            if (c != 0) {
                return c;
            }
            if (!m1.has(field.getKey()) || (c = CMessage.compare((Comparable)m1.get(field.getKey()), (Comparable)m2.get(field.getKey()))) == 0) continue;
            return c;
        }
        return 0;
    }
}

