/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.reflect;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import net.morimekta.providence.model.ProgramType;
import net.morimekta.providence.reflect.contained.CProgram;
import net.morimekta.providence.reflect.parser.ParseException;
import net.morimekta.providence.reflect.parser.ProgramParser;
import net.morimekta.providence.reflect.util.ProgramConverter;
import net.morimekta.providence.reflect.util.ProgramRegistry;

public class TypeLoader {
    private final ProgramRegistry mRegistry;
    private final ProgramConverter mConverter;
    private final ProgramParser mParser;
    private final Map<String, ProgramType> mLoadedDocuments;
    private final Collection<File> mIncludes;

    public TypeLoader(Collection<File> includes, ProgramParser parser) {
        this(includes, parser, new ProgramRegistry());
    }

    private TypeLoader(Collection<File> includes, ProgramParser parser, ProgramRegistry registry) {
        this(includes, parser, registry, new ProgramConverter(registry));
    }

    protected TypeLoader(Collection<File> includes, ProgramParser parser, ProgramRegistry registry, ProgramConverter converter) {
        this.mIncludes = includes;
        this.mParser = parser;
        this.mRegistry = registry;
        this.mConverter = converter;
        this.mLoadedDocuments = new LinkedHashMap<String, ProgramType>();
    }

    public Collection<ProgramType> loadedPrograms() {
        return this.mLoadedDocuments.values();
    }

    public CProgram load(File file) throws IOException, ParseException {
        if (!(file = file.getCanonicalFile()).exists()) {
            throw new IllegalArgumentException("No such file " + file.getCanonicalPath());
        }
        if (file.isDirectory()) {
            throw new IllegalArgumentException("Unable to load thrift definition from directory: " + file.getCanonicalPath());
        }
        CProgram cdoc = this.mRegistry.getDocument(file.getCanonicalPath());
        if (cdoc != null) {
            return cdoc;
        }
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
        ProgramType doc = this.mParser.parse(in, file.getName());
        LinkedList<File> queue = new LinkedList<File>();
        for (String string : doc.getIncludes()) {
            File location = new File(file.getParent(), string).getCanonicalFile();
            if (!location.exists()) {
                for (File inc : this.mIncludes) {
                    File i = new File(inc, string);
                    if (!i.exists()) continue;
                    location = i.getCanonicalFile();
                    break;
                }
            }
            if (!location.exists() || queue.contains(location)) continue;
            queue.add(location);
        }
        Collections.reverse(queue);
        this.mLoadedDocuments.put(file.getCanonicalPath(), doc);
        for (File file2 : queue) {
            if (this.mLoadedDocuments.containsKey(file2.getCanonicalPath())) continue;
            this.load(file2);
        }
        cdoc = this.mConverter.convert(doc);
        this.mRegistry.putDocument(file.getCanonicalPath(), cdoc);
        return cdoc;
    }

    public ProgramRegistry getRegistry() {
        return this.mRegistry;
    }
}

