/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.reflect.contained;

import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.PType;
import net.morimekta.providence.descriptor.PList;
import net.morimekta.providence.descriptor.PMap;
import net.morimekta.providence.descriptor.PPrimitive;
import net.morimekta.providence.descriptor.PRequirement;
import net.morimekta.providence.descriptor.PSet;
import net.morimekta.providence.descriptor.PStructDescriptor;
import net.morimekta.providence.reflect.contained.CExceptionDescriptor;
import net.morimekta.providence.reflect.contained.CField;
import net.morimekta.providence.reflect.contained.CMessage;

public class CException
extends Throwable
implements PMessage<CException, CField> {
    private final CExceptionDescriptor descriptor;
    private final Map<Integer, Object> values;

    private CException(Builder builder) {
        this.values = builder.getValueMap();
        this.descriptor = builder.descriptor;
    }

    public boolean has(int key) {
        CField field = this.descriptor().getField(key);
        if (field == null) {
            return false;
        }
        return this.values.containsKey(key);
    }

    public int num(int key) {
        CField field = this.descriptor().getField(key);
        if (field == null) {
            return 0;
        }
        if (!this.values.containsKey(key)) {
            return 0;
        }
        switch (field.getDescriptor().getType()) {
            case MAP: {
                return ((Map)this.values.get(key)).size();
            }
            case LIST: 
            case SET: {
                return ((Collection)this.values.get(key)).size();
            }
        }
        return 0;
    }

    public Object get(int key) {
        CField field = this.descriptor().getField(key);
        if (field != null) {
            Object value = this.values.get(key);
            if (value != null) {
                return value;
            }
            if (field.hasDefaultValue()) {
                return field.getDefaultValue();
            }
            if (field.getDescriptor() instanceof PPrimitive) {
                return ((PPrimitive)field.getDescriptor()).getDefaultValue();
            }
        }
        return null;
    }

    public boolean compact() {
        if (!this.descriptor().isCompactible()) {
            return false;
        }
        boolean missing = false;
        for (CField field : this.descriptor().getFields()) {
            if (this.has(field.getKey())) {
                if (!missing) continue;
                return false;
            }
            missing = true;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof CException)) {
            return false;
        }
        CException other = (CException)o;
        CExceptionDescriptor type = other.descriptor();
        if (!this.descriptor().getQualifiedName(null).equals(type.getQualifiedName(null)) || !this.descriptor().getVariant().equals((Object)type.getVariant())) {
            return false;
        }
        for (CField field : this.descriptor().getFields()) {
            int id = field.getKey();
            if (this.has(id) != other.has(id)) {
                return false;
            }
            if (!Objects.equals(this.get(id), other.get(id))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        for (Map.Entry<Integer, Object> entry : this.values.entrySet()) {
            CField field = this.descriptor().getField(entry.getKey());
            hash ^= Objects.hash(field, entry.getValue());
        }
        return hash;
    }

    public int compareTo(CException other) {
        return CMessage.compare(this, other);
    }

    @Override
    public String toString() {
        return this.descriptor().getQualifiedName(null) + this.asString();
    }

    public String asString() {
        return CMessage.asString(this);
    }

    public PMessageBuilder<CException, CField> mutate() {
        return new Builder(this.descriptor);
    }

    public CExceptionDescriptor descriptor() {
        return this.descriptor;
    }

    public static class Builder
    extends PMessageBuilder<CException, CField> {
        private final CExceptionDescriptor descriptor;
        private final Map<Integer, Object> values;

        public Builder(CExceptionDescriptor type) {
            this.descriptor = type;
            this.values = new TreeMap<Integer, Object>();
        }

        public Builder merge(CException from) {
            block5: for (CField field : this.descriptor.getFields()) {
                int key = field.getKey();
                if (!from.has(key)) continue;
                switch (field.getType()) {
                    case MESSAGE: {
                        if (this.values.containsKey(key)) {
                            PMessage src = (PMessage)this.values.get(key);
                            PMessage toMerge = (PMessage)from.get(key);
                            this.values.put(key, src.mutate().merge(toMerge).build());
                            continue block5;
                        }
                        this.set(key, from.get(key));
                        continue block5;
                    }
                    case SET: {
                        if (this.values.containsKey(key)) {
                            ((PSet.Builder)this.values.get(key)).addAll((Collection)from.get(key));
                            continue block5;
                        }
                        this.set(key, from.get(key));
                        continue block5;
                    }
                    case MAP: {
                        if (this.values.containsKey(key)) {
                            ((PMap.Builder)this.values.get(key)).putAll((Map)from.get(key));
                            continue block5;
                        }
                        this.set(key, from.get(key));
                        continue block5;
                    }
                    default: {
                        this.set(key, from.get(key));
                    }
                }
            }
            return this;
        }

        public PStructDescriptor<CException, CField> descriptor() {
            return this.descriptor;
        }

        public CException build() {
            return new CException(this);
        }

        public boolean isValid() {
            return this.values.size() == 1;
        }

        public void validate() {
            LinkedList<String> missing = new LinkedList<String>();
            for (CField field : this.descriptor.getFields()) {
                if (field.getRequirement() != PRequirement.REQUIRED || this.values.containsKey(field.getKey())) continue;
                missing.add(field.getName());
            }
            if (missing.size() > 0) {
                throw new IllegalStateException("Missing required fields " + String.join((CharSequence)",", missing) + " in message " + this.descriptor().getQualifiedName(null));
            }
        }

        public Builder set(int key, Object value) {
            CField field = this.descriptor.getField(key);
            if (field == null) {
                return this;
            }
            if (value == null) {
                this.values.remove(key);
            } else {
                switch (field.getType()) {
                    case LIST: {
                        PList.Builder builder = ((PList)field.getDescriptor()).builder();
                        builder.addAll((Collection)value);
                        this.values.put(key, builder);
                        break;
                    }
                    case SET: {
                        PSet.Builder builder = ((PSet)field.getDescriptor()).builder();
                        builder.addAll((Collection)value);
                        this.values.put(key, builder);
                        break;
                    }
                    case MAP: {
                        PMap.Builder builder = ((PMap)field.getDescriptor()).builder();
                        builder.putAll((Map)value);
                        this.values.put(key, builder);
                        break;
                    }
                    default: {
                        this.values.put(key, value);
                    }
                }
            }
            return this;
        }

        public Builder addTo(int key, Object value) {
            CField field = this.descriptor.getField(key);
            if (field == null) {
                return this;
            }
            if (value != null) {
                if (field.getType() == PType.LIST) {
                    LinkedList<Object> list = (LinkedList<Object>)this.values.get(field.getKey());
                    if (list == null) {
                        list = new LinkedList<Object>();
                        this.values.put(field.getKey(), list);
                    }
                    list.add(value);
                } else if (field.getType() == PType.SET) {
                    HashSet<Object> set = (HashSet<Object>)this.values.get(field.getKey());
                    if (set == null) {
                        set = new HashSet<Object>();
                        this.values.put(field.getKey(), set);
                    }
                    set.add(value);
                } else {
                    throw new IllegalArgumentException("Key " + key + " is not a collection: " + field.getType());
                }
            }
            return this;
        }

        public Builder clear(int key) {
            this.values.remove(key);
            return this;
        }

        public PMessageBuilder mutator(int key) {
            CField field = this.descriptor.getField(key);
            if (field == null) {
                throw new IllegalArgumentException("No such field ID " + key);
            }
            if (field.getType() != PType.MESSAGE) {
                throw new IllegalArgumentException("Not a message field ID " + key + ": " + field.getName());
            }
            Object current = this.values.get(key);
            if (current == null) {
                current = ((PStructDescriptor)field.getDescriptor()).builder();
                this.values.put(key, current);
            } else if (current instanceof PMessage) {
                current = ((PMessage)current).mutate();
                this.values.put(key, current);
            } else if (!(current instanceof PMessageBuilder)) {
                throw new IllegalArgumentException("Invalid value in map on message type: " + current.getClass().getSimpleName());
            }
            return (PMessageBuilder)current;
        }

        private Map<Integer, Object> getValueMap() {
            ImmutableMap.Builder out = ImmutableMap.builder();
            block6: for (CField field : this.descriptor.getFields()) {
                int key = field.getKey();
                if (!this.values.containsKey(key)) continue;
                switch (field.getType()) {
                    case SET: {
                        out.put((Object)key, (Object)((PSet.Builder)this.values.get(key)).build());
                        continue block6;
                    }
                    case LIST: {
                        out.put((Object)key, (Object)((PList.Builder)this.values.get(key)).build());
                        continue block6;
                    }
                    case MAP: {
                        out.put((Object)key, (Object)((PMap.Builder)this.values.get(key)).build());
                        continue block6;
                    }
                    case MESSAGE: {
                        Object current = this.values.get(key);
                        if (current instanceof PMessageBuilder) {
                            out.put((Object)key, ((PMessageBuilder)current).build());
                            continue block6;
                        }
                        out.put((Object)key, current);
                        continue block6;
                    }
                    default: {
                        out.put((Object)key, this.values.get(key));
                    }
                }
            }
            return out.build();
        }
    }
}

