/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.reflect.util;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import net.morimekta.providence.descriptor.PDeclaredDescriptor;
import net.morimekta.providence.descriptor.PDescriptorProvider;
import net.morimekta.providence.descriptor.PList;
import net.morimekta.providence.descriptor.PMap;
import net.morimekta.providence.descriptor.PPrimitive;
import net.morimekta.providence.descriptor.PService;
import net.morimekta.providence.descriptor.PServiceProvider;
import net.morimekta.providence.descriptor.PSet;
import net.morimekta.providence.reflect.contained.CDocument;
import net.morimekta.providence.reflect.parser.ThriftDocumentParser;
import net.morimekta.providence.reflect.util.ThriftAnnotation;
import net.morimekta.providence.reflect.util.ThriftCollection;

public class TypeRegistry {
    private final Map<String, PDeclaredDescriptor<?>> declaredTypes = new LinkedHashMap();
    private final Map<String, String> typedefs = new LinkedHashMap<String, String>();
    private final Map<String, CDocument> documents;
    private final Map<String, PService> services = new LinkedHashMap<String, PService>();

    public TypeRegistry() {
        this.documents = new LinkedHashMap<String, CDocument>();
    }

    public boolean putDocument(String path, CDocument doc) {
        if (!this.documents.containsKey(path)) {
            this.documents.put(path, doc);
            return true;
        }
        return false;
    }

    public CDocument getDocument(String path) {
        return this.documents.get(path);
    }

    public CDocument getDocumentForPackage(String packageContext) {
        for (CDocument document : this.documents.values()) {
            if (!document.getPackageName().equals(packageContext)) continue;
            return document;
        }
        return null;
    }

    public <T extends PDeclaredDescriptor<T>> T getDescriptor(String name, String packageContext) {
        String declaredTypeName = name;
        if (!name.contains(".") && packageContext != null) {
            declaredTypeName = packageContext + "." + name;
        } else {
            int dot = declaredTypeName.indexOf(46);
            packageContext = declaredTypeName.substring(0, dot);
            name = declaredTypeName.substring(dot + 1);
        }
        if (this.declaredTypes.containsKey(declaredTypeName)) {
            return (T)this.declaredTypes.get(declaredTypeName);
        }
        if (this.getDocumentForPackage(packageContext) == null) {
            throw new IllegalArgumentException("No such package \"" + packageContext + "\" exists");
        }
        throw new IllegalArgumentException("No such type \"" + name + "\" in package \"" + packageContext + "\"");
    }

    public <T> void putDeclaredType(PDeclaredDescriptor<T> declaredType) {
        String declaredTypeName = declaredType.getQualifiedName(null);
        if (this.declaredTypes.containsKey(declaredTypeName)) {
            throw new IllegalStateException("Type " + declaredTypeName + " already exists");
        }
        this.declaredTypes.put(declaredTypeName, declaredType);
    }

    public void putTypedef(String typeName, String identifier) {
        if (identifier == null || typeName == null) {
            throw new IllegalArgumentException("NOOO!");
        }
        this.typedefs.put(identifier, typeName);
    }

    public PDescriptorProvider getProvider(String typeName, String packageContext, Map<String, String> annotations) {
        String itemType;
        PPrimitive primitive;
        while (this.typedefs.containsKey(typeName)) {
            typeName = this.typedefs.get(typeName);
        }
        if (annotations == null) {
            annotations = Collections.EMPTY_MAP;
        }
        if ((primitive = PPrimitive.findByName((String)typeName)) != null) {
            return primitive.provider();
        }
        if (typeName.startsWith("map<") && typeName.endsWith(">")) {
            String[] parts = typeName.substring(4, typeName.length() - 1).split(",", 2);
            if (parts.length != 2) {
                throw new IllegalArgumentException(typeName + " is not a valid map descriptor, wrong number of types.");
            }
            String keyType = parts[0];
            String valueType = parts[1];
            switch (ThriftCollection.forName((String)annotations.get(ThriftAnnotation.COLLECTION.id))) {
                case SORTED: {
                    return PMap.sortedProvider((PDescriptorProvider)this.getProvider(keyType, packageContext, null), (PDescriptorProvider)this.getProvider(valueType, packageContext, null));
                }
                case ORDERED: {
                    return PMap.orderedProvider((PDescriptorProvider)this.getProvider(keyType, packageContext, null), (PDescriptorProvider)this.getProvider(valueType, packageContext, null));
                }
                case DEFAULT: {
                    return PMap.provider((PDescriptorProvider)this.getProvider(keyType, packageContext, null), (PDescriptorProvider)this.getProvider(valueType, packageContext, null));
                }
            }
        }
        if (typeName.startsWith("set<") && typeName.endsWith(">")) {
            itemType = typeName.substring(4, typeName.length() - 1);
            switch (ThriftCollection.forName((String)annotations.get(ThriftAnnotation.COLLECTION.id))) {
                case SORTED: {
                    return PSet.sortedProvider((PDescriptorProvider)this.getProvider(itemType, packageContext, null));
                }
                case ORDERED: {
                    return PSet.orderedProvider((PDescriptorProvider)this.getProvider(itemType, packageContext, null));
                }
                case DEFAULT: {
                    return PSet.provider((PDescriptorProvider)this.getProvider(itemType, packageContext, null));
                }
            }
        }
        if (typeName.startsWith("list<") && typeName.endsWith(">")) {
            itemType = typeName.substring(5, typeName.length() - 1);
            return PList.provider((PDescriptorProvider)this.getProvider(itemType, packageContext, null));
        }
        if (!ThriftDocumentParser.VALID_IDENTIFIER.matcher(typeName).matches()) {
            throw new IllegalArgumentException(typeName + " is not a valid declared type identifier.");
        }
        String name = typeName;
        return () -> this.getDescriptor(name, packageContext);
    }

    public void putService(PService service) {
        if (service == null) {
            throw new IllegalArgumentException("NOOOO!");
        }
        this.services.put(service.getQualifiedName(null), service);
    }

    public PServiceProvider getServiceProvider(String serviceName, String packageContext) {
        if (!serviceName.contains(".")) {
            serviceName = packageContext + "." + serviceName;
        }
        String finalServiceName = serviceName;
        return () -> this.services.get(finalServiceName);
    }
}

