/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.reflect.contained;

import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.PUnion;
import net.morimekta.providence.descriptor.PList;
import net.morimekta.providence.descriptor.PMap;
import net.morimekta.providence.descriptor.PSet;
import net.morimekta.providence.reflect.contained.CField;
import net.morimekta.providence.reflect.contained.CMessage;
import net.morimekta.providence.reflect.contained.CUnionDescriptor;

public class CUnion
extends CMessage<CUnion>
implements PUnion<CUnion> {
    private final CUnionDescriptor descriptor;
    private final CField unionField;

    private CUnion(Builder builder) {
        super(builder.getValueMap());
        this.unionField = builder.field;
        this.descriptor = builder.descriptor;
    }

    public PMessageBuilder<CUnion> mutate() {
        return new Builder(this.descriptor);
    }

    public CUnionDescriptor descriptor() {
        return this.descriptor;
    }

    public CField unionField() {
        return this.unionField;
    }

    public static class Builder
    extends PMessageBuilder<CUnion> {
        private final CUnionDescriptor descriptor;
        private CField field;
        private Object value;

        public Builder(CUnionDescriptor descriptor) {
            this.descriptor = descriptor;
        }

        private Map<Integer, Object> getValueMap() {
            if (this.field == null) {
                return ImmutableMap.of();
            }
            if (this.value == null) {
                return ImmutableMap.of((Object)this.field.getKey(), null);
            }
            switch (this.field.getType()) {
                case LIST: {
                    return ImmutableMap.of((Object)this.field.getKey(), (Object)((PList.Builder)this.value).build());
                }
                case SET: {
                    return ImmutableMap.of((Object)this.field.getKey(), (Object)((PSet.Builder)this.value).build());
                }
                case MAP: {
                    return ImmutableMap.of((Object)this.field.getKey(), (Object)((PMap.Builder)this.value).build());
                }
            }
            return ImmutableMap.of((Object)this.field.getKey(), (Object)this.value);
        }

        public Builder merge(CUnion from) {
            if (this.field == null || this.field != from.unionField()) {
                this.set(from.unionField.getKey(), from.get(from.unionField.getKey()));
            } else {
                int key = this.field.getKey();
                switch (this.field.getType()) {
                    case MESSAGE: {
                        PMessage src = (PMessage)this.value;
                        PMessage toMerge = (PMessage)from.get(key);
                        this.value = src.mutate().merge(toMerge).build();
                        break;
                    }
                    case SET: {
                        ((PSet.Builder)this.value).addAll((Collection)((Set)from.get(key)));
                        break;
                    }
                    case MAP: {
                        ((PMap.Builder)this.value).putAll((Map)from.get(key));
                        break;
                    }
                    default: {
                        this.set(key, from.get(key));
                    }
                }
            }
            return this;
        }

        public CUnion build() {
            return new CUnion(this);
        }

        public boolean isValid() {
            return this.field != null;
        }

        public Builder set(int key, Object value) {
            CField field = this.descriptor.getField(key);
            if (field == null) {
                return this;
            }
            this.field = field;
            switch (field.getType()) {
                case SET: {
                    this.value = ((PSet)field.getDescriptor()).builder();
                    break;
                }
                case LIST: {
                    this.value = ((PList)field.getDescriptor()).builder();
                    break;
                }
                case MAP: {
                    this.value = ((PMap)field.getDescriptor()).builder();
                    break;
                }
                default: {
                    this.value = value;
                }
            }
            return this;
        }

        public Builder addTo(int key, Object value) {
            CField field = this.descriptor.getField(key);
            if (field == null) {
                return this;
            }
            if (this.field != field || this.value == null) {
                this.field = field;
                switch (field.getType()) {
                    case LIST: {
                        PList lType = (PList)field.getDescriptor();
                        this.value = lType.builder();
                        break;
                    }
                    case SET: {
                        PSet lType = (PSet)field.getDescriptor();
                        this.value = lType.builder();
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unable to accept addTo on non-list field " + field.getName());
                    }
                }
            }
            switch (field.getType()) {
                case LIST: {
                    ((PList.Builder)this.value).add(value);
                    break;
                }
                case SET: {
                    ((PList.Builder)this.value).add(value);
                }
            }
            return this;
        }

        public Builder clear(int key) {
            this.field = null;
            this.value = null;
            return this;
        }
    }
}

