/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.reflect.contained;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.morimekta.providence.PType;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PDescriptorProvider;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PRequirement;
import net.morimekta.providence.descriptor.PValueProvider;
import net.morimekta.providence.reflect.contained.CAnnotatedDescriptor;

public class CField
implements PField,
CAnnotatedDescriptor {
    private final String comment;
    private final int key;
    private final PRequirement requirement;
    private final PDescriptorProvider typeProvider;
    private final String name;
    private final PValueProvider defaultValue;
    private final Map<String, String> annotations;

    public CField(String comment, int key, PRequirement requirement, String name, PDescriptorProvider typeProvider, PValueProvider defaultValue, Map<String, String> annotations) {
        this.comment = comment;
        this.key = key;
        this.requirement = requirement;
        this.typeProvider = typeProvider;
        this.name = name;
        this.defaultValue = defaultValue;
        this.annotations = annotations;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    public int getKey() {
        return this.key;
    }

    public PRequirement getRequirement() {
        return this.requirement;
    }

    public PType getType() {
        return this.typeProvider.descriptor().getType();
    }

    public PDescriptor getDescriptor() {
        return this.typeProvider.descriptor();
    }

    public String getName() {
        return this.name;
    }

    public boolean hasDefaultValue() {
        return this.defaultValue != null;
    }

    public Object getDefaultValue() {
        return this.hasDefaultValue() ? this.defaultValue.get() : null;
    }

    @Override
    public Set<String> getAnnotations() {
        if (this.annotations != null) {
            return this.annotations.keySet();
        }
        return Collections.EMPTY_SET;
    }

    @Override
    public boolean hasAnnotation(String name) {
        if (this.annotations != null) {
            return this.annotations.containsKey(name);
        }
        return false;
    }

    @Override
    public String getAnnotationValue(String name) {
        if (this.annotations != null) {
            return this.annotations.get(name);
        }
        return null;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(PField.class.getSimpleName()).append('{').append(this.key).append(": ");
        if (this.requirement != PRequirement.DEFAULT) {
            builder.append(this.requirement.label).append(" ");
        }
        builder.append(this.getDescriptor().getQualifiedName(null)).append(" ").append(this.name).append("}");
        return builder.toString();
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof CField)) {
            return false;
        }
        CField other = (CField)o;
        return this.key == other.key && this.requirement == other.requirement && CField.equalsQualifiedName(this.getDescriptor(), other.getDescriptor()) && this.name.equals(other.name) && Objects.equals(this.defaultValue, other.defaultValue);
    }

    public int hashCode() {
        return Objects.hash(CField.class, this.key, this.requirement, this.name, this.getDefaultValue());
    }

    private static boolean equalsQualifiedName(PDescriptor a, PDescriptor b) {
        if (a == null != (b == null)) {
            return false;
        }
        if (a == null) {
            return true;
        }
        return a.getQualifiedName(null).equals(b.getQualifiedName(null));
    }
}

