/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.reflect.contained;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.morimekta.providence.descriptor.PDeclaredDescriptor;
import net.morimekta.providence.reflect.contained.CField;
import net.morimekta.providence.reflect.contained.CService;

public class CDocument {
    private final String comment;
    private final String packageName;
    private final List<String> includes;
    private final Map<String, String> namespaces;
    private final Map<String, String> typedefs;
    private final List<PDeclaredDescriptor<?>> declaredTypes;
    private final List<CService> services;
    private final List<CField> constants;

    public CDocument(String comment, String packageName, Map<String, String> namespaces, Collection<String> includes, Map<String, String> typedefs, Collection<PDeclaredDescriptor<?>> declaredTypes, Collection<CService> services, Collection<CField> constants) {
        this.comment = comment;
        this.packageName = packageName;
        this.namespaces = ImmutableMap.copyOf(namespaces);
        this.includes = ImmutableList.copyOf(includes);
        this.typedefs = ImmutableMap.copyOf(typedefs);
        this.declaredTypes = ImmutableList.copyOf(declaredTypes);
        this.services = ImmutableList.copyOf(services);
        this.constants = ImmutableList.copyOf(constants);
    }

    public String getComment() {
        return this.comment;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public List<String> getIncludes() {
        return this.includes;
    }

    public Map<String, String> getNamespaces() {
        return this.namespaces;
    }

    public Map<String, String> getTypedefs() {
        return this.typedefs;
    }

    public List<PDeclaredDescriptor<?>> getDeclaredTypes() {
        return this.declaredTypes;
    }

    public List<CService> getServices() {
        return this.services;
    }

    public List<CField> getConstants() {
        return this.constants;
    }

    public String getNamespaceForLanguage(String language) {
        return this.namespaces.get(language);
    }
}

