/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.PMessageBuilderFactory;
import net.morimekta.providence.PType;
import net.morimekta.providence.descriptor.PDefaultValueProvider;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PDescriptorProvider;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PList;
import net.morimekta.providence.descriptor.PMap;
import net.morimekta.providence.descriptor.PPrimitive;
import net.morimekta.providence.descriptor.PRequirement;
import net.morimekta.providence.descriptor.PStructDescriptor;
import net.morimekta.providence.descriptor.PStructDescriptorProvider;
import net.morimekta.providence.descriptor.PValueProvider;
import net.morimekta.providence.model.ThriftField;
import net.morimekta.util.Strings;

public class ServiceMethod
implements PMessage<ServiceMethod>,
Serializable,
Comparable<ServiceMethod> {
    private static final long serialVersionUID = -8952857258512990537L;
    private static final boolean kDefaultOneWay = false;
    private final String mComment;
    private final boolean mOneWay;
    private final String mReturnType;
    private final String mName;
    private final List<ThriftField> mParams;
    private final List<ThriftField> mExceptions;
    private final Map<String, String> mAnnotations;
    private volatile int tHashCode;
    public static final PStructDescriptor<ServiceMethod, _Field> kDescriptor = new _Descriptor();

    private ServiceMethod(_Builder builder) {
        this.mComment = builder.mComment;
        this.mOneWay = builder.mOneWay;
        this.mReturnType = builder.mReturnType;
        this.mName = builder.mName;
        this.mParams = builder.isSetParams() ? builder.mParams.build() : null;
        this.mExceptions = builder.isSetExceptions() ? builder.mExceptions.build() : null;
        this.mAnnotations = builder.isSetAnnotations() ? builder.mAnnotations.build() : null;
    }

    public ServiceMethod(String pComment, boolean pOneWay, String pReturnType, String pName, List<ThriftField> pParams, List<ThriftField> pExceptions, Map<String, String> pAnnotations) {
        this.mComment = pComment;
        this.mOneWay = pOneWay;
        this.mReturnType = pReturnType;
        this.mName = pName;
        this.mParams = pParams != null ? ImmutableList.copyOf(pParams) : null;
        this.mExceptions = pExceptions != null ? ImmutableList.copyOf(pExceptions) : null;
        this.mAnnotations = pAnnotations != null ? ImmutableMap.copyOf(pAnnotations) : null;
    }

    public boolean hasComment() {
        return this.mComment != null;
    }

    public String getComment() {
        return this.mComment;
    }

    public boolean hasOneWay() {
        return true;
    }

    public boolean isOneWay() {
        return this.mOneWay;
    }

    public boolean hasReturnType() {
        return this.mReturnType != null;
    }

    public String getReturnType() {
        return this.mReturnType;
    }

    public boolean hasName() {
        return this.mName != null;
    }

    public String getName() {
        return this.mName;
    }

    public int numParams() {
        return this.mParams != null ? this.mParams.size() : 0;
    }

    public boolean hasParams() {
        return this.mParams != null;
    }

    public List<ThriftField> getParams() {
        return this.mParams;
    }

    public int numExceptions() {
        return this.mExceptions != null ? this.mExceptions.size() : 0;
    }

    public boolean hasExceptions() {
        return this.mExceptions != null;
    }

    public List<ThriftField> getExceptions() {
        return this.mExceptions;
    }

    public int numAnnotations() {
        return this.mAnnotations != null ? this.mAnnotations.size() : 0;
    }

    public boolean hasAnnotations() {
        return this.mAnnotations != null;
    }

    public Map<String, String> getAnnotations() {
        return this.mAnnotations;
    }

    public boolean has(int key) {
        switch (key) {
            case 1: {
                return this.hasComment();
            }
            case 2: {
                return true;
            }
            case 3: {
                return this.hasReturnType();
            }
            case 4: {
                return this.hasName();
            }
            case 5: {
                return this.numParams() > 0;
            }
            case 6: {
                return this.numExceptions() > 0;
            }
            case 7: {
                return this.numAnnotations() > 0;
            }
        }
        return false;
    }

    public int num(int key) {
        switch (key) {
            case 1: {
                return this.hasComment() ? 1 : 0;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return this.hasReturnType() ? 1 : 0;
            }
            case 4: {
                return this.hasName() ? 1 : 0;
            }
            case 5: {
                return this.numParams();
            }
            case 6: {
                return this.numExceptions();
            }
            case 7: {
                return this.numAnnotations();
            }
        }
        return 0;
    }

    public Object get(int key) {
        switch (key) {
            case 1: {
                return this.getComment();
            }
            case 2: {
                return this.isOneWay();
            }
            case 3: {
                return this.getReturnType();
            }
            case 4: {
                return this.getName();
            }
            case 5: {
                return this.getParams();
            }
            case 6: {
                return this.getExceptions();
            }
            case 7: {
                return this.getAnnotations();
            }
        }
        return null;
    }

    public boolean compact() {
        return false;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !(o instanceof ServiceMethod)) {
            return false;
        }
        ServiceMethod other = (ServiceMethod)o;
        return Objects.equals(this.mComment, other.mComment) && Objects.equals(this.mOneWay, other.mOneWay) && Objects.equals(this.mReturnType, other.mReturnType) && Objects.equals(this.mName, other.mName) && Objects.equals(this.mParams, other.mParams) && Objects.equals(this.mExceptions, other.mExceptions) && Objects.equals(this.mAnnotations, other.mAnnotations);
    }

    public int hashCode() {
        if (this.tHashCode == 0) {
            this.tHashCode = Objects.hash(new Object[]{ServiceMethod.class, _Field.COMMENT, this.mComment, _Field.ONE_WAY, this.mOneWay, _Field.RETURN_TYPE, this.mReturnType, _Field.NAME, this.mName, _Field.PARAMS, this.mParams, _Field.EXCEPTIONS, this.mExceptions, _Field.ANNOTATIONS, this.mAnnotations});
        }
        return this.tHashCode;
    }

    public String toString() {
        return "model.ServiceMethod" + this.asString();
    }

    public String asString() {
        StringBuilder out = new StringBuilder();
        out.append("{");
        boolean first = true;
        if (this.mComment != null) {
            first = false;
            out.append("comment:").append('\"').append(Strings.escape((CharSequence)this.mComment)).append('\"');
        }
        out.append("one_way:").append(this.mOneWay);
        if (this.mReturnType != null) {
            out.append(',');
            out.append("return_type:").append('\"').append(Strings.escape((CharSequence)this.mReturnType)).append('\"');
        }
        if (this.mName != null) {
            out.append(',');
            out.append("name:").append('\"').append(Strings.escape((CharSequence)this.mName)).append('\"');
        }
        if (this.mParams != null && this.mParams.size() > 0) {
            out.append(',');
            out.append("params:").append(Strings.asString(this.mParams));
        }
        if (this.mExceptions != null && this.mExceptions.size() > 0) {
            out.append(',');
            out.append("exceptions:").append(Strings.asString(this.mExceptions));
        }
        if (this.mAnnotations != null && this.mAnnotations.size() > 0) {
            out.append(',');
            out.append("annotations:").append(Strings.asString(this.mAnnotations));
        }
        out.append('}');
        return out.toString();
    }

    @Override
    public int compareTo(ServiceMethod other) {
        int c = Boolean.compare(this.mComment != null, other.mComment != null);
        if (c != 0) {
            return c;
        }
        if (this.mComment != null && (c = this.mComment.compareTo(other.mComment)) != 0) {
            return c;
        }
        c = Boolean.compare(this.mOneWay, other.mOneWay);
        if (c != 0) {
            return c;
        }
        c = Boolean.compare(this.mReturnType != null, other.mReturnType != null);
        if (c != 0) {
            return c;
        }
        if (this.mReturnType != null && (c = this.mReturnType.compareTo(other.mReturnType)) != 0) {
            return c;
        }
        c = Boolean.compare(this.mName != null, other.mName != null);
        if (c != 0) {
            return c;
        }
        if (this.mName != null && (c = this.mName.compareTo(other.mName)) != 0) {
            return c;
        }
        c = Boolean.compare(this.mParams != null, other.mParams != null);
        if (c != 0) {
            return c;
        }
        if (this.mParams != null && (c = Integer.compare(this.mParams.hashCode(), other.mParams.hashCode())) != 0) {
            return c;
        }
        c = Boolean.compare(this.mExceptions != null, other.mExceptions != null);
        if (c != 0) {
            return c;
        }
        if (this.mExceptions != null && (c = Integer.compare(this.mExceptions.hashCode(), other.mExceptions.hashCode())) != 0) {
            return c;
        }
        c = Boolean.compare(this.mAnnotations != null, other.mAnnotations != null);
        if (c != 0) {
            return c;
        }
        if (this.mAnnotations != null && (c = Integer.compare(this.mAnnotations.hashCode(), other.mAnnotations.hashCode())) != 0) {
            return c;
        }
        return 0;
    }

    public static PStructDescriptorProvider<ServiceMethod, _Field> provider() {
        return new _Provider();
    }

    public PStructDescriptor<ServiceMethod, _Field> descriptor() {
        return kDescriptor;
    }

    public _Builder mutate() {
        return new _Builder(this);
    }

    public static _Builder builder() {
        return new _Builder();
    }

    public static class _Builder
    extends PMessageBuilder<ServiceMethod> {
        private BitSet optionals = new BitSet(7);
        private String mComment;
        private boolean mOneWay = false;
        private String mReturnType;
        private String mName;
        private PList.Builder<ThriftField> mParams = new PList.ImmutableListBuilder();
        private PList.Builder<ThriftField> mExceptions = new PList.ImmutableListBuilder();
        private PMap.Builder<String, String> mAnnotations = new PMap.ImmutableMapBuilder();

        public _Builder() {
        }

        public _Builder(ServiceMethod base) {
            this();
            if (base.hasComment()) {
                this.optionals.set(0);
                this.mComment = base.mComment;
            }
            this.optionals.set(1);
            this.mOneWay = base.mOneWay;
            if (base.hasReturnType()) {
                this.optionals.set(2);
                this.mReturnType = base.mReturnType;
            }
            if (base.hasName()) {
                this.optionals.set(3);
                this.mName = base.mName;
            }
            if (base.numParams() > 0) {
                this.optionals.set(4);
                this.mParams.addAll((Collection)base.mParams);
            }
            if (base.numExceptions() > 0) {
                this.optionals.set(5);
                this.mExceptions.addAll((Collection)base.mExceptions);
            }
            if (base.numAnnotations() > 0) {
                this.optionals.set(6);
                this.mAnnotations.putAll(base.mAnnotations);
            }
        }

        public _Builder merge(ServiceMethod from) {
            if (from.hasComment()) {
                this.optionals.set(0);
                this.mComment = from.getComment();
            }
            this.optionals.set(1);
            this.mOneWay = from.isOneWay();
            if (from.hasReturnType()) {
                this.optionals.set(2);
                this.mReturnType = from.getReturnType();
            }
            if (from.hasName()) {
                this.optionals.set(3);
                this.mName = from.getName();
            }
            if (from.hasParams()) {
                this.optionals.set(4);
                this.mParams.clear();
                this.mParams.addAll(from.getParams());
            }
            if (from.hasExceptions()) {
                this.optionals.set(5);
                this.mExceptions.clear();
                this.mExceptions.addAll(from.getExceptions());
            }
            if (from.hasAnnotations()) {
                this.optionals.set(6);
                this.mAnnotations.putAll(from.getAnnotations());
            }
            return this;
        }

        public _Builder setComment(String value) {
            this.optionals.set(0);
            this.mComment = value;
            return this;
        }

        public boolean isSetComment() {
            return this.optionals.get(0);
        }

        public _Builder clearComment() {
            this.optionals.clear(0);
            this.mComment = null;
            return this;
        }

        public _Builder setOneWay(boolean value) {
            this.optionals.set(1);
            this.mOneWay = value;
            return this;
        }

        public boolean isSetOneWay() {
            return this.optionals.get(1);
        }

        public _Builder clearOneWay() {
            this.optionals.clear(1);
            this.mOneWay = false;
            return this;
        }

        public _Builder setReturnType(String value) {
            this.optionals.set(2);
            this.mReturnType = value;
            return this;
        }

        public boolean isSetReturnType() {
            return this.optionals.get(2);
        }

        public _Builder clearReturnType() {
            this.optionals.clear(2);
            this.mReturnType = null;
            return this;
        }

        public _Builder setName(String value) {
            this.optionals.set(3);
            this.mName = value;
            return this;
        }

        public boolean isSetName() {
            return this.optionals.get(3);
        }

        public _Builder clearName() {
            this.optionals.clear(3);
            this.mName = null;
            return this;
        }

        public _Builder setParams(Collection<ThriftField> value) {
            this.optionals.set(4);
            this.mParams.clear();
            this.mParams.addAll(value);
            return this;
        }

        public _Builder addToParams(ThriftField ... values) {
            this.optionals.set(4);
            for (ThriftField item : values) {
                this.mParams.add((Object)item);
            }
            return this;
        }

        public boolean isSetParams() {
            return this.optionals.get(4);
        }

        public _Builder clearParams() {
            this.optionals.clear(4);
            this.mParams.clear();
            return this;
        }

        public _Builder setExceptions(Collection<ThriftField> value) {
            this.optionals.set(5);
            this.mExceptions.clear();
            this.mExceptions.addAll(value);
            return this;
        }

        public _Builder addToExceptions(ThriftField ... values) {
            this.optionals.set(5);
            for (ThriftField item : values) {
                this.mExceptions.add((Object)item);
            }
            return this;
        }

        public boolean isSetExceptions() {
            return this.optionals.get(5);
        }

        public _Builder clearExceptions() {
            this.optionals.clear(5);
            this.mExceptions.clear();
            return this;
        }

        public _Builder setAnnotations(Map<String, String> value) {
            this.optionals.set(6);
            this.mAnnotations.clear();
            this.mAnnotations.putAll(value);
            return this;
        }

        public _Builder putInAnnotations(String key, String value) {
            this.optionals.set(6);
            this.mAnnotations.put((Object)key, (Object)value);
            return this;
        }

        public boolean isSetAnnotations() {
            return this.optionals.get(6);
        }

        public _Builder clearAnnotations() {
            this.optionals.clear(6);
            this.mAnnotations.clear();
            return this;
        }

        public _Builder set(int key, Object value) {
            if (value == null) {
                return this.clear(key);
            }
            switch (key) {
                case 1: {
                    this.setComment((String)value);
                    break;
                }
                case 2: {
                    this.setOneWay((Boolean)value);
                    break;
                }
                case 3: {
                    this.setReturnType((String)value);
                    break;
                }
                case 4: {
                    this.setName((String)value);
                    break;
                }
                case 5: {
                    this.setParams((List)value);
                    break;
                }
                case 6: {
                    this.setExceptions((List)value);
                    break;
                }
                case 7: {
                    this.setAnnotations((Map)value);
                }
            }
            return this;
        }

        public _Builder addTo(int key, Object value) {
            switch (key) {
                case 5: {
                    this.addToParams((ThriftField)value);
                    break;
                }
                case 6: {
                    this.addToExceptions((ThriftField)value);
                    break;
                }
            }
            return this;
        }

        public _Builder clear(int key) {
            switch (key) {
                case 1: {
                    this.clearComment();
                    break;
                }
                case 2: {
                    this.clearOneWay();
                    break;
                }
                case 3: {
                    this.clearReturnType();
                    break;
                }
                case 4: {
                    this.clearName();
                    break;
                }
                case 5: {
                    this.clearParams();
                    break;
                }
                case 6: {
                    this.clearExceptions();
                    break;
                }
                case 7: {
                    this.clearAnnotations();
                }
            }
            return this;
        }

        public boolean isValid() {
            return this.optionals.get(3);
        }

        public ServiceMethod build() {
            return new ServiceMethod(this);
        }
    }

    private static final class _Factory
    extends PMessageBuilderFactory<ServiceMethod> {
        private _Factory() {
        }

        public _Builder builder() {
            return new _Builder();
        }
    }

    private static final class _Provider
    extends PStructDescriptorProvider<ServiceMethod, _Field> {
        private _Provider() {
        }

        public PStructDescriptor<ServiceMethod, _Field> descriptor() {
            return kDescriptor;
        }
    }

    private static class _Descriptor
    extends PStructDescriptor<ServiceMethod, _Field> {
        public _Descriptor() {
            super("model", "ServiceMethod", (PMessageBuilderFactory)new _Factory(), false, false);
        }

        public _Field[] getFields() {
            return _Field.values();
        }

        public _Field getField(String name) {
            return _Field.forName(name);
        }

        public _Field getField(int key) {
            return _Field.forKey(key);
        }
    }

    public static enum _Field implements PField
    {
        COMMENT(1, PRequirement.DEFAULT, "comment", (PDescriptorProvider)PPrimitive.STRING.provider(), null),
        ONE_WAY(2, PRequirement.DEFAULT, "one_way", (PDescriptorProvider)PPrimitive.BOOL.provider(), (PValueProvider<?>)new PDefaultValueProvider((Object)false)),
        RETURN_TYPE(3, PRequirement.DEFAULT, "return_type", (PDescriptorProvider)PPrimitive.STRING.provider(), null),
        NAME(4, PRequirement.REQUIRED, "name", (PDescriptorProvider)PPrimitive.STRING.provider(), null),
        PARAMS(5, PRequirement.DEFAULT, "params", (PDescriptorProvider)PList.provider(ThriftField.provider()), null),
        EXCEPTIONS(6, PRequirement.DEFAULT, "exceptions", (PDescriptorProvider)PList.provider(ThriftField.provider()), null),
        ANNOTATIONS(7, PRequirement.DEFAULT, "annotations", (PDescriptorProvider)PMap.provider((PDescriptorProvider)PPrimitive.STRING.provider(), (PDescriptorProvider)PPrimitive.STRING.provider()), null);

        private final int mKey;
        private final PRequirement mRequired;
        private final String mName;
        private final PDescriptorProvider mTypeProvider;
        private final PValueProvider<?> mDefaultValue;

        private _Field(int key, PRequirement required, String name, PDescriptorProvider typeProvider, PValueProvider<?> defaultValue) {
            this.mKey = key;
            this.mRequired = required;
            this.mName = name;
            this.mTypeProvider = typeProvider;
            this.mDefaultValue = defaultValue;
        }

        public int getKey() {
            return this.mKey;
        }

        public PRequirement getRequirement() {
            return this.mRequired;
        }

        public PType getType() {
            return this.getDescriptor().getType();
        }

        public PDescriptor getDescriptor() {
            return this.mTypeProvider.descriptor();
        }

        public String getName() {
            return this.mName;
        }

        public boolean hasDefaultValue() {
            return this.mDefaultValue != null;
        }

        public Object getDefaultValue() {
            return this.hasDefaultValue() ? this.mDefaultValue.get() : null;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("ServiceMethod._Field(").append(this.mKey).append(": ");
            if (this.mRequired != PRequirement.DEFAULT) {
                builder.append(this.mRequired.label).append(" ");
            }
            builder.append(this.getDescriptor().getQualifiedName(null)).append(' ').append(this.mName).append(')');
            return builder.toString();
        }

        public static _Field forKey(int key) {
            switch (key) {
                case 1: {
                    return COMMENT;
                }
                case 2: {
                    return ONE_WAY;
                }
                case 3: {
                    return RETURN_TYPE;
                }
                case 4: {
                    return NAME;
                }
                case 5: {
                    return PARAMS;
                }
                case 6: {
                    return EXCEPTIONS;
                }
                case 7: {
                    return ANNOTATIONS;
                }
            }
            return null;
        }

        public static _Field forName(String name) {
            switch (name) {
                case "comment": {
                    return COMMENT;
                }
                case "one_way": {
                    return ONE_WAY;
                }
                case "return_type": {
                    return RETURN_TYPE;
                }
                case "name": {
                    return NAME;
                }
                case "params": {
                    return PARAMS;
                }
                case "exceptions": {
                    return EXCEPTIONS;
                }
                case "annotations": {
                    return ANNOTATIONS;
                }
            }
            return null;
        }
    }
}

