/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.model;

import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.util.BitSet;
import java.util.Map;
import java.util.Objects;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.PMessageBuilderFactory;
import net.morimekta.providence.PType;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PDescriptorProvider;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PMap;
import net.morimekta.providence.descriptor.PPrimitive;
import net.morimekta.providence.descriptor.PRequirement;
import net.morimekta.providence.descriptor.PStructDescriptor;
import net.morimekta.providence.descriptor.PStructDescriptorProvider;
import net.morimekta.providence.descriptor.PValueProvider;
import net.morimekta.util.Strings;

public class EnumValue
implements PMessage<EnumValue>,
Serializable,
Comparable<EnumValue> {
    private static final long serialVersionUID = -4079600082644582517L;
    private static final int kDefaultValue = 0;
    private final String mComment;
    private final String mName;
    private final int mValue;
    private final Map<String, String> mAnnotations;
    private volatile int tHashCode;
    public static final PStructDescriptor<EnumValue, _Field> kDescriptor = new _Descriptor();

    private EnumValue(_Builder builder) {
        this.mComment = builder.mComment;
        this.mName = builder.mName;
        this.mValue = builder.mValue;
        this.mAnnotations = builder.isSetAnnotations() ? builder.mAnnotations.build() : null;
    }

    public EnumValue(String pComment, String pName, int pValue, Map<String, String> pAnnotations) {
        this.mComment = pComment;
        this.mName = pName;
        this.mValue = pValue;
        this.mAnnotations = pAnnotations != null ? ImmutableMap.copyOf(pAnnotations) : null;
    }

    public boolean hasComment() {
        return this.mComment != null;
    }

    public String getComment() {
        return this.mComment;
    }

    public boolean hasName() {
        return this.mName != null;
    }

    public String getName() {
        return this.mName;
    }

    public boolean hasValue() {
        return true;
    }

    public int getValue() {
        return this.mValue;
    }

    public int numAnnotations() {
        return this.mAnnotations != null ? this.mAnnotations.size() : 0;
    }

    public boolean hasAnnotations() {
        return this.mAnnotations != null;
    }

    public Map<String, String> getAnnotations() {
        return this.mAnnotations;
    }

    public boolean has(int key) {
        switch (key) {
            case 1: {
                return this.hasComment();
            }
            case 2: {
                return this.hasName();
            }
            case 3: {
                return true;
            }
            case 4: {
                return this.numAnnotations() > 0;
            }
        }
        return false;
    }

    public int num(int key) {
        switch (key) {
            case 1: {
                return this.hasComment() ? 1 : 0;
            }
            case 2: {
                return this.hasName() ? 1 : 0;
            }
            case 3: {
                return 1;
            }
            case 4: {
                return this.numAnnotations();
            }
        }
        return 0;
    }

    public Object get(int key) {
        switch (key) {
            case 1: {
                return this.getComment();
            }
            case 2: {
                return this.getName();
            }
            case 3: {
                return this.getValue();
            }
            case 4: {
                return this.getAnnotations();
            }
        }
        return null;
    }

    public boolean compact() {
        return false;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !(o instanceof EnumValue)) {
            return false;
        }
        EnumValue other = (EnumValue)o;
        return Objects.equals(this.mComment, other.mComment) && Objects.equals(this.mName, other.mName) && Objects.equals(this.mValue, other.mValue) && Objects.equals(this.mAnnotations, other.mAnnotations);
    }

    public int hashCode() {
        if (this.tHashCode == 0) {
            this.tHashCode = Objects.hash(new Object[]{EnumValue.class, _Field.COMMENT, this.mComment, _Field.NAME, this.mName, _Field.VALUE, this.mValue, _Field.ANNOTATIONS, this.mAnnotations});
        }
        return this.tHashCode;
    }

    public String toString() {
        return "model.EnumValue" + this.asString();
    }

    public String asString() {
        StringBuilder out = new StringBuilder();
        out.append("{");
        boolean first = true;
        if (this.mComment != null) {
            first = false;
            out.append("comment:").append('\"').append(Strings.escape((CharSequence)this.mComment)).append('\"');
        }
        if (this.mName != null) {
            if (first) {
                first = false;
            } else {
                out.append(',');
            }
            out.append("name:").append('\"').append(Strings.escape((CharSequence)this.mName)).append('\"');
        }
        out.append("value:").append(this.mValue);
        if (this.mAnnotations != null && this.mAnnotations.size() > 0) {
            out.append(',');
            out.append("annotations:").append(Strings.asString(this.mAnnotations));
        }
        out.append('}');
        return out.toString();
    }

    @Override
    public int compareTo(EnumValue other) {
        int c = Boolean.compare(this.mComment != null, other.mComment != null);
        if (c != 0) {
            return c;
        }
        if (this.mComment != null && (c = this.mComment.compareTo(other.mComment)) != 0) {
            return c;
        }
        c = Boolean.compare(this.mName != null, other.mName != null);
        if (c != 0) {
            return c;
        }
        if (this.mName != null && (c = this.mName.compareTo(other.mName)) != 0) {
            return c;
        }
        c = Integer.compare(this.mValue, other.mValue);
        if (c != 0) {
            return c;
        }
        c = Boolean.compare(this.mAnnotations != null, other.mAnnotations != null);
        if (c != 0) {
            return c;
        }
        if (this.mAnnotations != null && (c = Integer.compare(this.mAnnotations.hashCode(), other.mAnnotations.hashCode())) != 0) {
            return c;
        }
        return 0;
    }

    public static PStructDescriptorProvider<EnumValue, _Field> provider() {
        return new _Provider();
    }

    public PStructDescriptor<EnumValue, _Field> descriptor() {
        return kDescriptor;
    }

    public _Builder mutate() {
        return new _Builder(this);
    }

    public static _Builder builder() {
        return new _Builder();
    }

    public static class _Builder
    extends PMessageBuilder<EnumValue> {
        private BitSet optionals = new BitSet(4);
        private String mComment;
        private String mName;
        private int mValue = 0;
        private PMap.Builder<String, String> mAnnotations = new PMap.ImmutableMapBuilder();

        public _Builder() {
        }

        public _Builder(EnumValue base) {
            this();
            if (base.hasComment()) {
                this.optionals.set(0);
                this.mComment = base.mComment;
            }
            if (base.hasName()) {
                this.optionals.set(1);
                this.mName = base.mName;
            }
            this.optionals.set(2);
            this.mValue = base.mValue;
            if (base.numAnnotations() > 0) {
                this.optionals.set(3);
                this.mAnnotations.putAll(base.mAnnotations);
            }
        }

        public _Builder merge(EnumValue from) {
            if (from.hasComment()) {
                this.optionals.set(0);
                this.mComment = from.getComment();
            }
            if (from.hasName()) {
                this.optionals.set(1);
                this.mName = from.getName();
            }
            this.optionals.set(2);
            this.mValue = from.getValue();
            if (from.hasAnnotations()) {
                this.optionals.set(3);
                this.mAnnotations.putAll(from.getAnnotations());
            }
            return this;
        }

        public _Builder setComment(String value) {
            this.optionals.set(0);
            this.mComment = value;
            return this;
        }

        public boolean isSetComment() {
            return this.optionals.get(0);
        }

        public _Builder clearComment() {
            this.optionals.clear(0);
            this.mComment = null;
            return this;
        }

        public _Builder setName(String value) {
            this.optionals.set(1);
            this.mName = value;
            return this;
        }

        public boolean isSetName() {
            return this.optionals.get(1);
        }

        public _Builder clearName() {
            this.optionals.clear(1);
            this.mName = null;
            return this;
        }

        public _Builder setValue(int value) {
            this.optionals.set(2);
            this.mValue = value;
            return this;
        }

        public boolean isSetValue() {
            return this.optionals.get(2);
        }

        public _Builder clearValue() {
            this.optionals.clear(2);
            this.mValue = 0;
            return this;
        }

        public _Builder setAnnotations(Map<String, String> value) {
            this.optionals.set(3);
            this.mAnnotations.clear();
            this.mAnnotations.putAll(value);
            return this;
        }

        public _Builder putInAnnotations(String key, String value) {
            this.optionals.set(3);
            this.mAnnotations.put((Object)key, (Object)value);
            return this;
        }

        public boolean isSetAnnotations() {
            return this.optionals.get(3);
        }

        public _Builder clearAnnotations() {
            this.optionals.clear(3);
            this.mAnnotations.clear();
            return this;
        }

        public _Builder set(int key, Object value) {
            if (value == null) {
                return this.clear(key);
            }
            switch (key) {
                case 1: {
                    this.setComment((String)value);
                    break;
                }
                case 2: {
                    this.setName((String)value);
                    break;
                }
                case 3: {
                    this.setValue((Integer)value);
                    break;
                }
                case 4: {
                    this.setAnnotations((Map)value);
                }
            }
            return this;
        }

        public _Builder addTo(int key, Object value) {
            switch (key) {
                default: 
            }
            return this;
        }

        public _Builder clear(int key) {
            switch (key) {
                case 1: {
                    this.clearComment();
                    break;
                }
                case 2: {
                    this.clearName();
                    break;
                }
                case 3: {
                    this.clearValue();
                    break;
                }
                case 4: {
                    this.clearAnnotations();
                }
            }
            return this;
        }

        public boolean isValid() {
            return this.optionals.get(1);
        }

        public EnumValue build() {
            return new EnumValue(this);
        }
    }

    private static final class _Factory
    extends PMessageBuilderFactory<EnumValue> {
        private _Factory() {
        }

        public _Builder builder() {
            return new _Builder();
        }
    }

    private static final class _Provider
    extends PStructDescriptorProvider<EnumValue, _Field> {
        private _Provider() {
        }

        public PStructDescriptor<EnumValue, _Field> descriptor() {
            return kDescriptor;
        }
    }

    private static class _Descriptor
    extends PStructDescriptor<EnumValue, _Field> {
        public _Descriptor() {
            super("model", "EnumValue", (PMessageBuilderFactory)new _Factory(), false, false);
        }

        public _Field[] getFields() {
            return _Field.values();
        }

        public _Field getField(String name) {
            return _Field.forName(name);
        }

        public _Field getField(int key) {
            return _Field.forKey(key);
        }
    }

    public static enum _Field implements PField
    {
        COMMENT(1, PRequirement.DEFAULT, "comment", (PDescriptorProvider)PPrimitive.STRING.provider(), null),
        NAME(2, PRequirement.REQUIRED, "name", (PDescriptorProvider)PPrimitive.STRING.provider(), null),
        VALUE(3, PRequirement.DEFAULT, "value", (PDescriptorProvider)PPrimitive.I32.provider(), null),
        ANNOTATIONS(4, PRequirement.DEFAULT, "annotations", (PDescriptorProvider)PMap.provider((PDescriptorProvider)PPrimitive.STRING.provider(), (PDescriptorProvider)PPrimitive.STRING.provider()), null);

        private final int mKey;
        private final PRequirement mRequired;
        private final String mName;
        private final PDescriptorProvider mTypeProvider;
        private final PValueProvider<?> mDefaultValue;

        private _Field(int key, PRequirement required, String name, PDescriptorProvider typeProvider, PValueProvider<?> defaultValue) {
            this.mKey = key;
            this.mRequired = required;
            this.mName = name;
            this.mTypeProvider = typeProvider;
            this.mDefaultValue = defaultValue;
        }

        public int getKey() {
            return this.mKey;
        }

        public PRequirement getRequirement() {
            return this.mRequired;
        }

        public PType getType() {
            return this.getDescriptor().getType();
        }

        public PDescriptor getDescriptor() {
            return this.mTypeProvider.descriptor();
        }

        public String getName() {
            return this.mName;
        }

        public boolean hasDefaultValue() {
            return this.mDefaultValue != null;
        }

        public Object getDefaultValue() {
            return this.hasDefaultValue() ? this.mDefaultValue.get() : null;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("EnumValue._Field(").append(this.mKey).append(": ");
            if (this.mRequired != PRequirement.DEFAULT) {
                builder.append(this.mRequired.label).append(" ");
            }
            builder.append(this.getDescriptor().getQualifiedName(null)).append(' ').append(this.mName).append(')');
            return builder.toString();
        }

        public static _Field forKey(int key) {
            switch (key) {
                case 1: {
                    return COMMENT;
                }
                case 2: {
                    return NAME;
                }
                case 3: {
                    return VALUE;
                }
                case 4: {
                    return ANNOTATIONS;
                }
            }
            return null;
        }

        public static _Field forName(String name) {
            switch (name) {
                case "comment": {
                    return COMMENT;
                }
                case "name": {
                    return NAME;
                }
                case "value": {
                    return VALUE;
                }
                case "annotations": {
                    return ANNOTATIONS;
                }
            }
            return null;
        }
    }
}

