/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.reflect.util;

import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PValueProvider;
import net.morimekta.providence.reflect.parser.ParseException;
import net.morimekta.providence.reflect.parser.internal.ConstParser;
import net.morimekta.providence.reflect.util.TypeRegistry;

public class ConstProvider
implements PValueProvider<Object> {
    private final TypeRegistry mRegistry;
    private final String mTypeName;
    private final String mPackageContext;
    private final String mDefaultValue;
    private Object mParsedValue;

    public ConstProvider(TypeRegistry registry, String typeName, String packageContext, String defaultValue) {
        this.mRegistry = registry;
        this.mTypeName = typeName;
        this.mPackageContext = packageContext;
        this.mDefaultValue = defaultValue;
        this.mParsedValue = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get() {
        if (this.mParsedValue == null) {
            ConstParser parser = new ConstParser();
            ByteArrayInputStream in = new ByteArrayInputStream(this.mDefaultValue.getBytes(StandardCharsets.UTF_8));
            PDescriptor type = this.mRegistry.getProvider(this.mTypeName, this.mPackageContext, Collections.EMPTY_MAP).descriptor();
            try {
                this.mParsedValue = parser.parse(in, type);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    in.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return this.mParsedValue;
    }
}

