/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.reflect.contained;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PPrimitive;
import net.morimekta.providence.descriptor.PStructDescriptor;
import net.morimekta.providence.util.PrettyPrinter;
import net.morimekta.providence.util.TypeUtils;

public abstract class CMessage<T extends PMessage<T>>
implements PMessage<T> {
    private final Map<Integer, Object> values;

    CMessage(Map<Integer, Object> fields) {
        this.values = fields;
    }

    public boolean has(int key) {
        PField field = this.descriptor().getField(key);
        if (field == null) {
            return false;
        }
        switch (field.getDescriptor().getType()) {
            case MAP: 
            case LIST: 
            case SET: {
                return this.num(key) > 0;
            }
        }
        return this.values.containsKey(key);
    }

    public int num(int key) {
        PField field = this.descriptor().getField(key);
        if (field == null) {
            return 0;
        }
        switch (field.getDescriptor().getType()) {
            case MAP: {
                Map value = (Map)this.values.get(key);
                return value == null ? 0 : value.size();
            }
            case LIST: 
            case SET: {
                Collection collection = (Collection)this.values.get(key);
                return collection == null ? 0 : collection.size();
            }
        }
        return this.values.containsKey(key) ? 1 : 0;
    }

    public Object get(int key) {
        PField field = this.descriptor().getField(key);
        if (field != null) {
            Object value = this.values.get(key);
            if (value != null) {
                return value;
            }
            if (field.hasDefaultValue()) {
                return field.getDefaultValue();
            }
            if (field.getDescriptor() instanceof PPrimitive) {
                return ((PPrimitive)field.getDescriptor()).getDefaultValue();
            }
        }
        return null;
    }

    public boolean compact() {
        if (!this.descriptor().isCompactible()) {
            return false;
        }
        boolean missing = false;
        for (PField field : this.descriptor().getFields()) {
            if (this.has(field.getKey())) {
                if (!missing) continue;
                return false;
            }
            missing = true;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof CMessage)) {
            return false;
        }
        CMessage other = (CMessage)o;
        PStructDescriptor type = other.descriptor();
        if (!this.descriptor().getQualifiedName(null).equals(type.getQualifiedName(null)) || !this.descriptor().getVariant().equals((Object)type.getVariant())) {
            return false;
        }
        for (PField field : this.descriptor().getFields()) {
            int id = field.getKey();
            if (this.has(id) != other.has(id)) {
                return false;
            }
            if (Objects.equals(this.get(id), other.get(id))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        for (Map.Entry<Integer, Object> entry : this.values.entrySet()) {
            PField field = this.descriptor().getField(entry.getKey().intValue());
            hash += Objects.hash(field, entry.getValue());
        }
        return hash;
    }

    public int compareTo(T other) {
        return TypeUtils.compare((Comparable)((Object)this), other);
    }

    public String toString() {
        return this.descriptor().getQualifiedName(null) + this.asString();
    }

    public String asString() {
        return new PrettyPrinter("", "", "").format((PMessage)this);
    }
}

