/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.reflect.contained;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.PMessageBuilderFactory;
import net.morimekta.providence.PMessageVariant;
import net.morimekta.providence.descriptor.PExceptionDescriptor;
import net.morimekta.providence.reflect.contained.CAnnotatedDescriptor;
import net.morimekta.providence.reflect.contained.CException;
import net.morimekta.providence.reflect.contained.CField;

public class CExceptionDescriptor
extends PExceptionDescriptor<CException, CField>
implements CAnnotatedDescriptor {
    private final CField[] fields;
    private final Map<Integer, CField> fieldIdMap;
    private final Map<String, CField> fieldNameMap;
    private final Map<String, String> annotations;
    private final String comment;

    public CExceptionDescriptor(String comment, String packageName, String name, List<CField> fields, Map<String, String> annotations) {
        super(packageName, name, (PMessageBuilderFactory)new _Factory(), false);
        ((_Factory)this.getFactoryInternal()).setType(this);
        this.comment = comment;
        this.fields = fields.toArray(new CField[fields.size()]);
        this.annotations = annotations;
        LinkedHashMap<Integer, CField> fieldIdMap = new LinkedHashMap<Integer, CField>();
        LinkedHashMap<String, CField> fieldNameMap = new LinkedHashMap<String, CField>();
        for (CField field : fields) {
            fieldIdMap.put(field.getKey(), field);
            fieldNameMap.put(field.getName(), field);
        }
        this.fieldIdMap = fieldIdMap;
        this.fieldNameMap = fieldNameMap;
    }

    @Override
    public final String getComment() {
        return this.comment;
    }

    public CField[] getFields() {
        return this.fields;
    }

    public CField getField(String name) {
        return this.fieldNameMap.get(name);
    }

    public CField getField(int key) {
        return this.fieldIdMap.get(key);
    }

    @Override
    public Set<String> getAnnotations() {
        if (this.annotations != null) {
            return this.annotations.keySet();
        }
        return Collections.EMPTY_SET;
    }

    @Override
    public boolean hasAnnotation(String name) {
        if (this.annotations != null) {
            return this.annotations.containsKey(name);
        }
        return false;
    }

    @Override
    public String getAnnotationValue(String name) {
        if (this.annotations != null) {
            return this.annotations.get(name);
        }
        return null;
    }

    public boolean isSimple() {
        for (CField field : this.getFields()) {
            switch (field.getType()) {
                case MAP: 
                case SET: 
                case LIST: 
                case MESSAGE: {
                    return false;
                }
            }
        }
        return true;
    }

    public PMessageVariant getVariant() {
        return PMessageVariant.EXCEPTION;
    }

    private static class _Factory
    extends PMessageBuilderFactory<CException> {
        private CExceptionDescriptor mType;

        private _Factory() {
        }

        public void setType(CExceptionDescriptor type) {
            this.mType = type;
        }

        public PMessageBuilder<CException> builder() {
            return new CException.Builder(this.mType);
        }
    }
}

