/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.reflect.contained;

import com.google.common.collect.ImmutableSortedMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.PType;
import net.morimekta.providence.descriptor.PRequirement;
import net.morimekta.providence.reflect.contained.CField;
import net.morimekta.providence.reflect.contained.CMessage;
import net.morimekta.providence.reflect.contained.CStructDescriptor;

public class CStruct
extends CMessage<CStruct> {
    CStructDescriptor descriptor;

    private CStruct(Builder builder) {
        super((Map<Integer, Object>)ImmutableSortedMap.copyOf((Map)builder.values));
        this.descriptor = builder.descriptor;
    }

    public PMessageBuilder<CStruct> mutate() {
        return new Builder(this.descriptor);
    }

    public CStructDescriptor descriptor() {
        return this.descriptor;
    }

    public static class Builder
    extends PMessageBuilder<CStruct> {
        private final CStructDescriptor descriptor;
        private final Map<Integer, Object> values;

        public Builder(CStructDescriptor descriptor) {
            this.descriptor = descriptor;
            this.values = new TreeMap<Integer, Object>();
        }

        public CStruct build() {
            return new CStruct(this);
        }

        public boolean isValid() {
            for (CField field : this.descriptor.getFields()) {
                if (field.getRequirement() != PRequirement.REQUIRED || this.values.containsKey(field.getKey())) continue;
                return false;
            }
            return true;
        }

        public Builder set(int key, Object value) {
            CField field = this.descriptor.getField(key);
            if (field == null) {
                return this;
            }
            if (value != null) {
                this.values.put(field.getKey(), value);
            }
            return this;
        }

        public Builder addTo(int key, Object value) {
            CField field = this.descriptor.getField(key);
            if (field == null) {
                return this;
            }
            if (value != null) {
                if (field.getType() == PType.LIST) {
                    LinkedList<Object> list = (LinkedList<Object>)this.values.get(field.getKey());
                    if (list == null) {
                        list = new LinkedList<Object>();
                        this.values.put(field.getKey(), list);
                    }
                    list.add(value);
                } else if (field.getType() == PType.SET) {
                    HashSet<Object> set = (HashSet<Object>)this.values.get(field.getKey());
                    if (set == null) {
                        set = new HashSet<Object>();
                        this.values.put(field.getKey(), set);
                    }
                    set.add(value);
                }
            }
            return this;
        }

        public Builder clear(int key) {
            this.values.remove(key);
            return this;
        }
    }
}

