/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.reflect.contained;

import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.PType;
import net.morimekta.providence.descriptor.PPrimitive;
import net.morimekta.providence.reflect.contained.CExceptionDescriptor;
import net.morimekta.providence.reflect.contained.CField;
import net.morimekta.providence.util.PrettyPrinter;
import net.morimekta.providence.util.TypeUtils;

public class CException
extends Throwable
implements PMessage<CException> {
    private final CExceptionDescriptor descriptor;
    private final Map<Integer, Object> values;

    private CException(Builder builder) {
        this.values = ImmutableMap.copyOf((Map)builder.values);
        this.descriptor = builder.descriptor;
    }

    public boolean has(int key) {
        CField field = this.descriptor().getField(key);
        if (field == null) {
            return false;
        }
        switch (field.getDescriptor().getType()) {
            case MAP: 
            case LIST: 
            case SET: {
                return this.num(key) > 0;
            }
        }
        return this.values.containsKey(key);
    }

    public int num(int key) {
        CField field = this.descriptor().getField(key);
        if (field == null) {
            return 0;
        }
        switch (field.getDescriptor().getType()) {
            case MAP: {
                Map value = (Map)this.values.get(key);
                return value == null ? 0 : value.size();
            }
            case LIST: 
            case SET: {
                Collection collection = (Collection)this.values.get(key);
                return collection == null ? 0 : collection.size();
            }
        }
        return this.values.containsKey(key) ? 1 : 0;
    }

    public Object get(int key) {
        CField field = this.descriptor().getField(key);
        if (field != null) {
            Object value = this.values.get(key);
            if (value != null) {
                return value;
            }
            if (field.hasDefaultValue()) {
                return field.getDefaultValue();
            }
            if (field.getDescriptor() instanceof PPrimitive) {
                return ((PPrimitive)field.getDescriptor()).getDefaultValue();
            }
        }
        return null;
    }

    public boolean compact() {
        if (!this.descriptor().isCompactible()) {
            return false;
        }
        boolean missing = false;
        for (CField field : this.descriptor().getFields()) {
            if (this.has(field.getKey())) {
                if (!missing) continue;
                return false;
            }
            missing = true;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof CException)) {
            return false;
        }
        CException other = (CException)o;
        CExceptionDescriptor type = other.descriptor();
        if (!this.descriptor().getQualifiedName(null).equals(type.getQualifiedName(null)) || !this.descriptor().getVariant().equals((Object)type.getVariant())) {
            return false;
        }
        for (CField field : this.descriptor().getFields()) {
            int id = field.getKey();
            if (this.has(id) != other.has(id)) {
                return false;
            }
            if (!Objects.equals(this.get(id), other.get(id))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        for (Map.Entry<Integer, Object> entry : this.values.entrySet()) {
            CField field = this.descriptor().getField(entry.getKey());
            hash ^= Objects.hash(field, entry.getValue());
        }
        return hash;
    }

    public int compareTo(CException other) {
        return TypeUtils.compare((Comparable)((Object)this), (Comparable)((Object)other));
    }

    @Override
    public String toString() {
        return this.descriptor().getQualifiedName(null) + this.asString();
    }

    public String asString() {
        return new PrettyPrinter("", "", "").format((PMessage)this);
    }

    public PMessageBuilder<CException> mutate() {
        return new Builder(this.descriptor);
    }

    public CExceptionDescriptor descriptor() {
        return this.descriptor;
    }

    public static class Builder
    extends PMessageBuilder<CException> {
        private final CExceptionDescriptor descriptor;
        private final Map<Integer, Object> values;

        public Builder(CExceptionDescriptor type) {
            this.descriptor = type;
            this.values = new TreeMap<Integer, Object>();
        }

        public CException build() {
            return new CException(this);
        }

        public boolean isValid() {
            return this.values.size() == 1;
        }

        public Builder set(int key, Object value) {
            CField field = this.descriptor.getField(key);
            if (field == null) {
                return this;
            }
            if (value != null) {
                this.values.put(field.getKey(), value);
            }
            return this;
        }

        public Builder addTo(int key, Object value) {
            CField field = this.descriptor.getField(key);
            if (field == null) {
                return this;
            }
            if (value != null) {
                if (field.getType() == PType.LIST) {
                    LinkedList<Object> list = (LinkedList<Object>)this.values.get(field.getKey());
                    if (list == null) {
                        list = new LinkedList<Object>();
                        this.values.put(field.getKey(), list);
                    }
                    list.add(value);
                } else if (field.getType() == PType.SET) {
                    HashSet<Object> set = (HashSet<Object>)this.values.get(field.getKey());
                    if (set == null) {
                        set = new HashSet<Object>();
                        this.values.put(field.getKey(), set);
                    }
                    set.add(value);
                }
            }
            return this;
        }

        public Builder clear(int key) {
            this.values.remove(key);
            return this;
        }
    }
}

