/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.model;

import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.util.BitSet;
import java.util.Map;
import java.util.Objects;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.PMessageBuilderFactory;
import net.morimekta.providence.PType;
import net.morimekta.providence.descriptor.PDefaultValueProvider;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PDescriptorProvider;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PMap;
import net.morimekta.providence.descriptor.PPrimitive;
import net.morimekta.providence.descriptor.PRequirement;
import net.morimekta.providence.descriptor.PStructDescriptor;
import net.morimekta.providence.descriptor.PStructDescriptorProvider;
import net.morimekta.providence.descriptor.PValueProvider;
import net.morimekta.providence.model.Requirement;
import net.morimekta.util.Strings;

public class ThriftField
implements PMessage<ThriftField>,
Serializable,
Comparable<ThriftField> {
    private static final long serialVersionUID = 5114028868232611868L;
    private static final int kDefaultKey = 0;
    private static final Requirement kDefaultRequirement = Requirement.DEFAULT;
    private final String mComment;
    private final int mKey;
    private final Requirement mRequirement;
    private final String mType;
    private final String mName;
    private final String mDefaultValue;
    private final Map<String, String> mAnnotations;
    private volatile int tHashCode;
    public static final PStructDescriptor<ThriftField, _Field> kDescriptor = new _Descriptor();

    private ThriftField(_Builder builder) {
        this.mComment = builder.mComment;
        this.mKey = builder.mKey;
        this.mRequirement = builder.mRequirement;
        this.mType = builder.mType;
        this.mName = builder.mName;
        this.mDefaultValue = builder.mDefaultValue;
        this.mAnnotations = builder.isSetAnnotations() ? builder.mAnnotations.build() : null;
    }

    public ThriftField(String pComment, int pKey, Requirement pRequirement, String pType, String pName, String pDefaultValue, Map<String, String> pAnnotations) {
        this.mComment = pComment;
        this.mKey = pKey;
        this.mRequirement = pRequirement;
        this.mType = pType;
        this.mName = pName;
        this.mDefaultValue = pDefaultValue;
        this.mAnnotations = pAnnotations != null ? ImmutableMap.copyOf(pAnnotations) : null;
    }

    public boolean hasComment() {
        return this.mComment != null;
    }

    public String getComment() {
        return this.mComment;
    }

    public boolean hasKey() {
        return true;
    }

    public int getKey() {
        return this.mKey;
    }

    public boolean hasRequirement() {
        return this.mRequirement != null;
    }

    public Requirement getRequirement() {
        return this.hasRequirement() ? this.mRequirement : kDefaultRequirement;
    }

    public boolean hasType() {
        return this.mType != null;
    }

    public String getType() {
        return this.mType;
    }

    public boolean hasName() {
        return this.mName != null;
    }

    public String getName() {
        return this.mName;
    }

    public boolean hasDefaultValue() {
        return this.mDefaultValue != null;
    }

    public String getDefaultValue() {
        return this.mDefaultValue;
    }

    public int numAnnotations() {
        return this.mAnnotations != null ? this.mAnnotations.size() : 0;
    }

    public boolean hasAnnotations() {
        return this.mAnnotations != null;
    }

    public Map<String, String> getAnnotations() {
        return this.mAnnotations;
    }

    public boolean has(int key) {
        switch (key) {
            case 1: {
                return this.hasComment();
            }
            case 2: {
                return true;
            }
            case 3: {
                return this.hasRequirement();
            }
            case 4: {
                return this.hasType();
            }
            case 5: {
                return this.hasName();
            }
            case 6: {
                return this.hasDefaultValue();
            }
            case 7: {
                return this.numAnnotations() > 0;
            }
        }
        return false;
    }

    public int num(int key) {
        switch (key) {
            case 1: {
                return this.hasComment() ? 1 : 0;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return this.hasRequirement() ? 1 : 0;
            }
            case 4: {
                return this.hasType() ? 1 : 0;
            }
            case 5: {
                return this.hasName() ? 1 : 0;
            }
            case 6: {
                return this.hasDefaultValue() ? 1 : 0;
            }
            case 7: {
                return this.numAnnotations();
            }
        }
        return 0;
    }

    public Object get(int key) {
        switch (key) {
            case 1: {
                return this.getComment();
            }
            case 2: {
                return this.getKey();
            }
            case 3: {
                return this.getRequirement();
            }
            case 4: {
                return this.getType();
            }
            case 5: {
                return this.getName();
            }
            case 6: {
                return this.getDefaultValue();
            }
            case 7: {
                return this.getAnnotations();
            }
        }
        return null;
    }

    public boolean compact() {
        return false;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof ThriftField)) {
            return false;
        }
        ThriftField other = (ThriftField)o;
        return Objects.equals(this.mComment, other.mComment) && Objects.equals(this.mKey, other.mKey) && Objects.equals((Object)this.mRequirement, (Object)other.mRequirement) && Objects.equals(this.mType, other.mType) && Objects.equals(this.mName, other.mName) && Objects.equals(this.mDefaultValue, other.mDefaultValue) && Objects.equals(this.mAnnotations, other.mAnnotations);
    }

    public int hashCode() {
        if (this.tHashCode == 0) {
            this.tHashCode = Objects.hash(new Object[]{ThriftField.class, _Field.COMMENT, this.mComment, _Field.KEY, this.mKey, _Field.REQUIREMENT, this.mRequirement, _Field.TYPE, this.mType, _Field.NAME, this.mName, _Field.DEFAULT_VALUE, this.mDefaultValue, _Field.ANNOTATIONS, this.mAnnotations});
        }
        return this.tHashCode;
    }

    public String toString() {
        return "model.ThriftField" + this.asString();
    }

    public String asString() {
        StringBuilder out = new StringBuilder();
        out.append("{");
        boolean first = true;
        if (this.mComment != null) {
            first = false;
            out.append("comment:").append('\"').append(Strings.escape((CharSequence)this.mComment)).append('\"');
        }
        out.append("key:").append(this.mKey);
        if (this.mRequirement != null) {
            out.append(',');
            out.append("requirement:").append(this.mRequirement.toString());
        }
        if (this.mType != null) {
            out.append(',');
            out.append("type:").append('\"').append(Strings.escape((CharSequence)this.mType)).append('\"');
        }
        if (this.mName != null) {
            out.append(',');
            out.append("name:").append('\"').append(Strings.escape((CharSequence)this.mName)).append('\"');
        }
        if (this.mDefaultValue != null) {
            out.append(',');
            out.append("default_value:").append('\"').append(Strings.escape((CharSequence)this.mDefaultValue)).append('\"');
        }
        if (this.mAnnotations != null && this.mAnnotations.size() > 0) {
            out.append(',');
            out.append("annotations:").append(Strings.asString(this.mAnnotations));
        }
        out.append('}');
        return out.toString();
    }

    @Override
    public int compareTo(ThriftField other) {
        int c = Boolean.compare(this.mComment != null, other.mComment != null);
        if (c != 0) {
            return c;
        }
        if (this.mComment != null && (c = this.mComment.compareTo(other.mComment)) != 0) {
            return c;
        }
        c = Integer.compare(this.mKey, other.mKey);
        if (c != 0) {
            return c;
        }
        c = Boolean.compare(this.mRequirement != null, other.mRequirement != null);
        if (c != 0) {
            return c;
        }
        if (this.mRequirement != null && (c = Integer.compare(this.mRequirement.getValue(), this.mRequirement.getValue())) != 0) {
            return c;
        }
        c = Boolean.compare(this.mType != null, other.mType != null);
        if (c != 0) {
            return c;
        }
        if (this.mType != null && (c = this.mType.compareTo(other.mType)) != 0) {
            return c;
        }
        c = Boolean.compare(this.mName != null, other.mName != null);
        if (c != 0) {
            return c;
        }
        if (this.mName != null && (c = this.mName.compareTo(other.mName)) != 0) {
            return c;
        }
        c = Boolean.compare(this.mDefaultValue != null, other.mDefaultValue != null);
        if (c != 0) {
            return c;
        }
        if (this.mDefaultValue != null && (c = this.mDefaultValue.compareTo(other.mDefaultValue)) != 0) {
            return c;
        }
        c = Boolean.compare(this.mAnnotations != null, other.mAnnotations != null);
        if (c != 0) {
            return c;
        }
        if (this.mAnnotations != null && (c = Integer.compare(this.mAnnotations.hashCode(), other.mAnnotations.hashCode())) != 0) {
            return c;
        }
        return 0;
    }

    public static PStructDescriptorProvider<ThriftField, _Field> provider() {
        return new _Provider();
    }

    public PStructDescriptor<ThriftField, _Field> descriptor() {
        return kDescriptor;
    }

    public _Builder mutate() {
        return new _Builder(this);
    }

    public static _Builder builder() {
        return new _Builder();
    }

    static /* synthetic */ Requirement access$700() {
        return kDefaultRequirement;
    }

    public static class _Builder
    extends PMessageBuilder<ThriftField> {
        private BitSet optionals = new BitSet(7);
        private String mComment;
        private int mKey = 0;
        private Requirement mRequirement;
        private String mType;
        private String mName;
        private String mDefaultValue;
        private PMap.Builder<String, String> mAnnotations = new PMap.ImmutableMapBuilder();

        public _Builder() {
        }

        public _Builder(ThriftField base) {
            this();
            if (base.hasComment()) {
                this.optionals.set(0);
                this.mComment = base.mComment;
            }
            this.optionals.set(1);
            this.mKey = base.mKey;
            if (base.hasRequirement()) {
                this.optionals.set(2);
                this.mRequirement = base.mRequirement;
            }
            if (base.hasType()) {
                this.optionals.set(3);
                this.mType = base.mType;
            }
            if (base.hasName()) {
                this.optionals.set(4);
                this.mName = base.mName;
            }
            if (base.hasDefaultValue()) {
                this.optionals.set(5);
                this.mDefaultValue = base.mDefaultValue;
            }
            if (base.numAnnotations() > 0) {
                this.optionals.set(6);
                this.mAnnotations.putAll(base.mAnnotations);
            }
        }

        public _Builder setComment(String value) {
            this.optionals.set(0);
            this.mComment = value;
            return this;
        }

        public boolean isSetComment() {
            return this.optionals.get(0);
        }

        public _Builder clearComment() {
            this.optionals.clear(0);
            this.mComment = null;
            return this;
        }

        public _Builder setKey(int value) {
            this.optionals.set(1);
            this.mKey = value;
            return this;
        }

        public boolean isSetKey() {
            return this.optionals.get(1);
        }

        public _Builder clearKey() {
            this.optionals.clear(1);
            this.mKey = 0;
            return this;
        }

        public _Builder setRequirement(Requirement value) {
            this.optionals.set(2);
            this.mRequirement = value;
            return this;
        }

        public boolean isSetRequirement() {
            return this.optionals.get(2);
        }

        public _Builder clearRequirement() {
            this.optionals.clear(2);
            this.mRequirement = null;
            return this;
        }

        public _Builder setType(String value) {
            this.optionals.set(3);
            this.mType = value;
            return this;
        }

        public boolean isSetType() {
            return this.optionals.get(3);
        }

        public _Builder clearType() {
            this.optionals.clear(3);
            this.mType = null;
            return this;
        }

        public _Builder setName(String value) {
            this.optionals.set(4);
            this.mName = value;
            return this;
        }

        public boolean isSetName() {
            return this.optionals.get(4);
        }

        public _Builder clearName() {
            this.optionals.clear(4);
            this.mName = null;
            return this;
        }

        public _Builder setDefaultValue(String value) {
            this.optionals.set(5);
            this.mDefaultValue = value;
            return this;
        }

        public boolean isSetDefaultValue() {
            return this.optionals.get(5);
        }

        public _Builder clearDefaultValue() {
            this.optionals.clear(5);
            this.mDefaultValue = null;
            return this;
        }

        public _Builder setAnnotations(Map<String, String> value) {
            this.optionals.set(6);
            this.mAnnotations.clear();
            this.mAnnotations.putAll(value);
            return this;
        }

        public _Builder putInAnnotations(String key, String value) {
            this.optionals.set(6);
            this.mAnnotations.put((Object)key, (Object)value);
            return this;
        }

        public boolean isSetAnnotations() {
            return this.optionals.get(6);
        }

        public _Builder clearAnnotations() {
            this.optionals.clear(6);
            this.mAnnotations.clear();
            return this;
        }

        public _Builder set(int key, Object value) {
            if (value == null) {
                return this.clear(key);
            }
            switch (key) {
                case 1: {
                    this.setComment((String)value);
                    break;
                }
                case 2: {
                    this.setKey((Integer)value);
                    break;
                }
                case 3: {
                    this.setRequirement((Requirement)((Object)value));
                    break;
                }
                case 4: {
                    this.setType((String)value);
                    break;
                }
                case 5: {
                    this.setName((String)value);
                    break;
                }
                case 6: {
                    this.setDefaultValue((String)value);
                    break;
                }
                case 7: {
                    this.setAnnotations((Map)value);
                }
            }
            return this;
        }

        public _Builder addTo(int key, Object value) {
            switch (key) {
                default: 
            }
            return this;
        }

        public _Builder clear(int key) {
            switch (key) {
                case 1: {
                    this.clearComment();
                    break;
                }
                case 2: {
                    this.clearKey();
                    break;
                }
                case 3: {
                    this.clearRequirement();
                    break;
                }
                case 4: {
                    this.clearType();
                    break;
                }
                case 5: {
                    this.clearName();
                    break;
                }
                case 6: {
                    this.clearDefaultValue();
                    break;
                }
                case 7: {
                    this.clearAnnotations();
                }
            }
            return this;
        }

        public boolean isValid() {
            return this.optionals.get(1) && this.optionals.get(3) && this.optionals.get(4);
        }

        public ThriftField build() {
            return new ThriftField(this);
        }
    }

    private static final class _Factory
    extends PMessageBuilderFactory<ThriftField> {
        private _Factory() {
        }

        public _Builder builder() {
            return new _Builder();
        }
    }

    private static final class _Provider
    extends PStructDescriptorProvider<ThriftField, _Field> {
        private _Provider() {
        }

        public PStructDescriptor<ThriftField, _Field> descriptor() {
            return kDescriptor;
        }
    }

    private static class _Descriptor
    extends PStructDescriptor<ThriftField, _Field> {
        public _Descriptor() {
            super("model", "ThriftField", (PMessageBuilderFactory)new _Factory(), false, false);
        }

        public _Field[] getFields() {
            return _Field.values();
        }

        public _Field getField(String name) {
            return _Field.forName(name);
        }

        public _Field getField(int key) {
            return _Field.forKey(key);
        }
    }

    public static enum _Field implements PField
    {
        COMMENT(1, PRequirement.DEFAULT, "comment", (PDescriptorProvider)PPrimitive.STRING.provider(), null),
        KEY(2, PRequirement.REQUIRED, "key", (PDescriptorProvider)PPrimitive.I32.provider(), null),
        REQUIREMENT(3, PRequirement.DEFAULT, "requirement", (PDescriptorProvider)Requirement.provider(), (PValueProvider<?>)new PDefaultValueProvider((Object)((Object)ThriftField.access$700()))),
        TYPE(4, PRequirement.REQUIRED, "type", (PDescriptorProvider)PPrimitive.STRING.provider(), null),
        NAME(5, PRequirement.REQUIRED, "name", (PDescriptorProvider)PPrimitive.STRING.provider(), null),
        DEFAULT_VALUE(6, PRequirement.DEFAULT, "default_value", (PDescriptorProvider)PPrimitive.STRING.provider(), null),
        ANNOTATIONS(7, PRequirement.DEFAULT, "annotations", (PDescriptorProvider)PMap.provider((PDescriptorProvider)PPrimitive.STRING.provider(), (PDescriptorProvider)PPrimitive.STRING.provider()), null);

        private final int mKey;
        private final PRequirement mRequired;
        private final String mName;
        private final PDescriptorProvider mTypeProvider;
        private final PValueProvider<?> mDefaultValue;

        private _Field(int key, PRequirement required, String name, PDescriptorProvider typeProvider, PValueProvider<?> defaultValue) {
            this.mKey = key;
            this.mRequired = required;
            this.mName = name;
            this.mTypeProvider = typeProvider;
            this.mDefaultValue = defaultValue;
        }

        public int getKey() {
            return this.mKey;
        }

        public PRequirement getRequirement() {
            return this.mRequired;
        }

        public PType getType() {
            return this.getDescriptor().getType();
        }

        public PDescriptor getDescriptor() {
            return this.mTypeProvider.descriptor();
        }

        public String getName() {
            return this.mName;
        }

        public boolean hasDefaultValue() {
            return this.mDefaultValue != null;
        }

        public Object getDefaultValue() {
            return this.hasDefaultValue() ? this.mDefaultValue.get() : null;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("ThriftField._Field(").append(this.mKey).append(": ");
            if (this.mRequired != PRequirement.DEFAULT) {
                builder.append(this.mRequired.label).append(" ");
            }
            builder.append(this.getDescriptor().getQualifiedName(null)).append(' ').append(this.mName).append(')');
            return builder.toString();
        }

        public static _Field forKey(int key) {
            switch (key) {
                case 1: {
                    return COMMENT;
                }
                case 2: {
                    return KEY;
                }
                case 3: {
                    return REQUIREMENT;
                }
                case 4: {
                    return TYPE;
                }
                case 5: {
                    return NAME;
                }
                case 6: {
                    return DEFAULT_VALUE;
                }
                case 7: {
                    return ANNOTATIONS;
                }
            }
            return null;
        }

        public static _Field forName(String name) {
            switch (name) {
                case "comment": {
                    return COMMENT;
                }
                case "key": {
                    return KEY;
                }
                case "requirement": {
                    return REQUIREMENT;
                }
                case "type": {
                    return TYPE;
                }
                case "name": {
                    return NAME;
                }
                case "default_value": {
                    return DEFAULT_VALUE;
                }
                case "annotations": {
                    return ANNOTATIONS;
                }
            }
            return null;
        }
    }
}

