/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.model;

import net.morimekta.providence.PEnumBuilder;
import net.morimekta.providence.PEnumBuilderFactory;
import net.morimekta.providence.PEnumValue;
import net.morimekta.providence.descriptor.PEnumDescriptor;
import net.morimekta.providence.descriptor.PEnumDescriptorProvider;

public enum StructVariant implements PEnumValue<StructVariant>
{
    STRUCT(1, "STRUCT"),
    UNION(2, "UNION"),
    EXCEPTION(3, "EXCEPTION");

    private final int mValue;
    private final String mName;
    public static final PEnumDescriptor<StructVariant> kDescriptor;

    private StructVariant(int value, String name) {
        this.mValue = value;
        this.mName = name;
    }

    public int getValue() {
        return this.mValue;
    }

    public String getName() {
        return this.mName;
    }

    public String asString() {
        return this.mName;
    }

    public static StructVariant forValue(int value) {
        switch (value) {
            case 1: {
                return STRUCT;
            }
            case 2: {
                return UNION;
            }
            case 3: {
                return EXCEPTION;
            }
        }
        return null;
    }

    public static StructVariant forName(String name) {
        switch (name) {
            case "STRUCT": {
                return STRUCT;
            }
            case "UNION": {
                return UNION;
            }
            case "EXCEPTION": {
                return EXCEPTION;
            }
        }
        return null;
    }

    public PEnumDescriptor<StructVariant> descriptor() {
        return kDescriptor;
    }

    public static PEnumDescriptorProvider<StructVariant> provider() {
        return new PEnumDescriptorProvider(kDescriptor);
    }

    static {
        kDescriptor = new _Descriptor();
    }

    private static class _Descriptor
    extends PEnumDescriptor<StructVariant> {
        public _Descriptor() {
            super("model", "StructVariant", (PEnumBuilderFactory)new _Factory());
        }

        public StructVariant[] getValues() {
            return StructVariant.values();
        }

        public StructVariant getValueById(int id) {
            return StructVariant.forValue(id);
        }

        public StructVariant getValueByName(String name) {
            return StructVariant.forName(name);
        }
    }

    private static class _Factory
    extends PEnumBuilderFactory<StructVariant> {
        private _Factory() {
        }

        public _Builder builder() {
            return new _Builder();
        }
    }

    public static class _Builder
    extends PEnumBuilder<StructVariant> {
        StructVariant mValue;

        public _Builder setByValue(int value) {
            this.mValue = StructVariant.forValue(value);
            return this;
        }

        public _Builder setByName(String name) {
            this.mValue = StructVariant.forName(name);
            return this;
        }

        public boolean isValid() {
            return this.mValue != null;
        }

        public StructVariant build() {
            return this.mValue;
        }
    }
}

