/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.reflect.util;

import java.util.LinkedHashMap;
import java.util.Map;
import net.morimekta.providence.descriptor.PDeclaredDescriptor;
import net.morimekta.providence.descriptor.PDescriptorProvider;
import net.morimekta.providence.descriptor.PList;
import net.morimekta.providence.descriptor.PMap;
import net.morimekta.providence.descriptor.PPrimitive;
import net.morimekta.providence.descriptor.PService;
import net.morimekta.providence.descriptor.PServiceProvider;
import net.morimekta.providence.descriptor.PSet;
import net.morimekta.providence.reflect.contained.CDocument;

public class TypeRegistry {
    private final Map<String, PDeclaredDescriptor<?>> declaredTypes = new LinkedHashMap();
    private final Map<String, String> typedefs = new LinkedHashMap<String, String>();
    private final Map<String, CDocument> documents;
    private final Map<String, PService> services = new LinkedHashMap<String, PService>();

    public TypeRegistry() {
        this.documents = new LinkedHashMap<String, CDocument>();
    }

    public boolean putDocument(String path, CDocument doc) {
        if (!this.documents.containsKey(path)) {
            this.documents.put(path, doc);
            return true;
        }
        return false;
    }

    public CDocument getDocument(String path) {
        return this.documents.get(path);
    }

    public CDocument getDocumentForPackage(String packageContext) {
        for (CDocument document : this.documents.values()) {
            if (!document.getPackageName().equals(packageContext)) continue;
            return document;
        }
        return null;
    }

    public <T extends PDeclaredDescriptor<T>> T getDescriptor(String name, String packageContext) {
        String declaredTypeName = name;
        if (!name.contains(".") && packageContext != null) {
            declaredTypeName = packageContext + "." + name;
        }
        if (this.declaredTypes.containsKey(declaredTypeName)) {
            return (T)this.declaredTypes.get(declaredTypeName);
        }
        throw new IllegalArgumentException("No such type \"" + name + "\" for package \"" + packageContext + "\"");
    }

    public <T> void putDeclaredType(PDeclaredDescriptor<T> declaredType) {
        String declaredTypeName = declaredType.getQualifiedName(null);
        if (this.declaredTypes.containsKey(declaredTypeName)) {
            throw new IllegalStateException("Type " + declaredTypeName + " already exists");
        }
        this.declaredTypes.put(declaredTypeName, declaredType);
    }

    public void putTypedef(String typeName, String identifier) {
        if (identifier == null || typeName == null) {
            throw new IllegalArgumentException("NOOO!");
        }
        this.typedefs.put(identifier, typeName);
    }

    public PDescriptorProvider getProvider(String typeName, String packageContext) {
        while (this.typedefs.containsKey(typeName)) {
            typeName = this.typedefs.get(typeName);
        }
        PPrimitive primitive = PPrimitive.findByName((String)typeName);
        if (primitive != null) {
            return primitive.provider();
        }
        if (typeName.startsWith("map<") && typeName.endsWith(">")) {
            String[] parts = typeName.substring(4, typeName.length() - 1).split(",", 2);
            if (parts.length != 2) {
                throw new IllegalArgumentException(typeName + " is not a valid map descriptor, wrong number of types.");
            }
            String keyType = parts[0];
            String valueType = parts[1];
            return PMap.provider((PDescriptorProvider)this.getProvider(keyType, packageContext), (PDescriptorProvider)this.getProvider(valueType, packageContext));
        }
        if (typeName.startsWith("set<") && typeName.endsWith(">")) {
            String itemType = typeName.substring(4, typeName.length() - 1);
            return PSet.provider((PDescriptorProvider)this.getProvider(itemType, packageContext));
        }
        if (typeName.startsWith("list<") && typeName.endsWith(">")) {
            String itemType = typeName.substring(5, typeName.length() - 1);
            return PList.provider((PDescriptorProvider)this.getProvider(itemType, packageContext));
        }
        String name = typeName;
        return () -> this.getDescriptor(name, packageContext);
    }

    public void putService(PService service) {
        if (service == null) {
            throw new IllegalArgumentException("NOOOO!");
        }
        this.services.put(service.getQualifiedName(null), service);
    }

    public PServiceProvider getServiceProvider(String serviceName, String packageContext) {
        if (!serviceName.contains(".")) {
            serviceName = packageContext + "." + serviceName;
        }
        String finalServiceName = serviceName;
        return () -> this.services.get(finalServiceName);
    }
}

