/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.reflect.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.morimekta.providence.descriptor.PDeclaredDescriptor;
import net.morimekta.providence.descriptor.PDescriptorProvider;
import net.morimekta.providence.descriptor.PEnumDescriptor;
import net.morimekta.providence.descriptor.PRequirement;
import net.morimekta.providence.descriptor.PServiceProvider;
import net.morimekta.providence.model.Declaration;
import net.morimekta.providence.model.EnumType;
import net.morimekta.providence.model.EnumValue;
import net.morimekta.providence.model.ServiceMethod;
import net.morimekta.providence.model.ServiceType;
import net.morimekta.providence.model.StructType;
import net.morimekta.providence.model.ThriftDocument;
import net.morimekta.providence.model.ThriftField;
import net.morimekta.providence.reflect.contained.CDocument;
import net.morimekta.providence.reflect.contained.CEnum;
import net.morimekta.providence.reflect.contained.CEnumDescriptor;
import net.morimekta.providence.reflect.contained.CExceptionDescriptor;
import net.morimekta.providence.reflect.contained.CField;
import net.morimekta.providence.reflect.contained.CService;
import net.morimekta.providence.reflect.contained.CServiceMethod;
import net.morimekta.providence.reflect.contained.CStructDescriptor;
import net.morimekta.providence.reflect.contained.CUnionDescriptor;
import net.morimekta.providence.reflect.util.ConstProvider;
import net.morimekta.providence.reflect.util.TypeRegistry;

public class DocumentConverter {
    private final TypeRegistry registry;

    public DocumentConverter(TypeRegistry registry) {
        this.registry = registry;
    }

    public CDocument convert(ThriftDocument document) {
        ImmutableList.Builder declaredTypes = ImmutableList.builder();
        ImmutableList.Builder constants = ImmutableList.builder();
        ImmutableMap.Builder typedefs = ImmutableMap.builder();
        ImmutableList.Builder services = ImmutableList.builder();
        for (Declaration decl : document.getDecl()) {
            switch (decl.unionField()) {
                case DECL_ENUM: {
                    EnumType enumType = decl.getDeclEnum();
                    int nextValue = 0;
                    Object type = new CEnumDescriptor(enumType.getComment(), document.getPackage(), enumType.getName(), enumType.getAnnotations());
                    LinkedList<CEnum> values = new LinkedList<CEnum>();
                    for (EnumValue enumValue : enumType.getValues()) {
                        int v = enumValue.hasValue() ? enumValue.getValue() : nextValue;
                        nextValue = v + 1;
                        values.add(new CEnum(enumValue.getComment(), enumValue.getValue(), enumValue.getName(), (PEnumDescriptor<CEnum>)type, enumValue.getAnnotations()));
                    }
                    ((CEnumDescriptor)type).setValues(values);
                    declaredTypes.add(type);
                    this.registry.putDeclaredType(type);
                    break;
                }
                case DECL_STRUCT: {
                    Object type;
                    StructType structType = decl.getDeclStruct();
                    LinkedList<CField> fields = new LinkedList<CField>();
                    for (ThriftField field : structType.getFields()) {
                        fields.add(this.makeField(document.getPackage(), field));
                    }
                    switch (structType.getVariant()) {
                        case STRUCT: {
                            type = new CStructDescriptor(structType.getComment(), document.getPackage(), structType.getName(), fields, structType.getAnnotations());
                            break;
                        }
                        case UNION: {
                            type = new CUnionDescriptor(structType.getComment(), document.getPackage(), structType.getName(), fields, structType.getAnnotations());
                            break;
                        }
                        case EXCEPTION: {
                            type = new CExceptionDescriptor(structType.getComment(), document.getPackage(), structType.getName(), fields, structType.getAnnotations());
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Unhandled struct type " + (Object)((Object)structType.getVariant()));
                        }
                    }
                    declaredTypes.add(type);
                    this.registry.putDeclaredType(type);
                    break;
                }
                case DECL_CONST: {
                    ThriftField constant = decl.getDeclConst();
                    constants.add((Object)this.makeField(document.getPackage(), constant));
                    break;
                }
                case DECL_TYPEDEF: {
                    typedefs.put((Object)decl.getDeclTypedef().getName(), (Object)decl.getDeclTypedef().getType());
                    this.registry.putTypedef(decl.getDeclTypedef().getType(), decl.getDeclTypedef().getName());
                    break;
                }
                case DECL_SERVICE: {
                    ServiceType serviceType = decl.getDeclService();
                    ImmutableList.Builder methodBuilder = ImmutableList.builder();
                    for (ServiceMethod sm : serviceType.getMethods()) {
                        LinkedList<CField> rqFields = new LinkedList<CField>();
                        if (sm.numParams() > 0) {
                            for (ThriftField field : sm.getParams()) {
                                rqFields.add(this.makeField(document.getPackage(), field));
                            }
                        }
                        CStructDescriptor cStructDescriptor = new CStructDescriptor(null, document.getPackage(), sm.getName() + "___request", rqFields, null);
                        CUnionDescriptor response = null;
                        if (!sm.isOneWay()) {
                            LinkedList<CField> rsFields = new LinkedList<CField>();
                            if (sm.getReturnType() != null) {
                                PDescriptorProvider type = this.registry.getProvider(sm.getReturnType(), document.getPackage());
                                CField success = new CField(null, 0, PRequirement.OPTIONAL, "success", type, null, null);
                                rsFields.add(success);
                            }
                            if (sm.numExceptions() > 0) {
                                for (ThriftField field : sm.getExceptions()) {
                                    rsFields.add(this.makeField(document.getPackage(), field));
                                }
                            }
                            response = new CUnionDescriptor(null, document.getPackage(), sm.getName() + "___response", rsFields, null);
                        }
                        CServiceMethod method = new CServiceMethod(sm.getComment(), sm.getName(), sm.isOneWay(), cStructDescriptor, response, sm.getAnnotations());
                        methodBuilder.add((Object)method);
                    }
                    PServiceProvider extendsProvider = null;
                    if (serviceType.hasExtend()) {
                        extendsProvider = this.registry.getServiceProvider(serviceType.getExtend(), document.getPackage());
                    }
                    CService service = new CService(serviceType.getComment(), document.getPackage(), serviceType.getName(), extendsProvider, (Collection<CServiceMethod>)methodBuilder.build(), serviceType.getAnnotations());
                    services.add((Object)service);
                    this.registry.putService(service);
                }
            }
        }
        return new CDocument(document.getComment(), document.getPackage(), document.getNamespaces(), (Collection<String>)this.getIncludes(document), (Map<String, String>)typedefs.build(), (Collection<PDeclaredDescriptor<?>>)declaredTypes.build(), (Collection<CService>)services.build(), (Collection<CField>)constants.build());
    }

    private List<String> getIncludes(ThriftDocument document) {
        LinkedList<String> out = new LinkedList<String>();
        for (String include : document.getIncludes()) {
            int i = include.lastIndexOf(46);
            if (i > 0) {
                include = include.substring(0, i);
            }
            out.add(include);
        }
        return out;
    }

    private CField makeField(String pkg, ThriftField field) {
        PDescriptorProvider type = this.registry.getProvider(field.getType(), pkg);
        ConstProvider defaultValue = null;
        if (field.hasDefaultValue()) {
            defaultValue = new ConstProvider(this.registry, field.getType(), pkg, field.getDefaultValue());
        }
        CField made = new CField(field.getComment(), field.getKey(), PRequirement.valueOf((String)field.getRequirement().getName()), field.getName(), type, defaultValue, field.getAnnotations());
        return made;
    }
}

