/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.reflect.parser;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.TreeSet;
import java.util.regex.Pattern;
import net.morimekta.providence.model.Declaration;
import net.morimekta.providence.model.EnumType;
import net.morimekta.providence.model.EnumValue;
import net.morimekta.providence.model.Model_Constants;
import net.morimekta.providence.model.Requirement;
import net.morimekta.providence.model.ServiceMethod;
import net.morimekta.providence.model.ServiceType;
import net.morimekta.providence.model.StructType;
import net.morimekta.providence.model.StructVariant;
import net.morimekta.providence.model.ThriftDocument;
import net.morimekta.providence.model.ThriftField;
import net.morimekta.providence.model.TypedefType;
import net.morimekta.providence.reflect.parser.ParseException;
import net.morimekta.providence.reflect.parser.Parser;
import net.morimekta.providence.reflect.parser.internal.Token;
import net.morimekta.providence.reflect.parser.internal.Tokenizer;
import net.morimekta.providence.reflect.util.ReflectionUtils;
import net.morimekta.util.Strings;

public class ThriftParser
implements Parser {
    private static final Pattern RE_BLOCK_LINE = Pattern.compile("^([\\s]*[*])?[\\s]?");
    private static final Pattern VALID_PACKAGE = Pattern.compile("[-._a-zA-Z0-9]+");
    private static final Pattern VALID_NAMESPACE = Pattern.compile("([_a-zA-Z][_a-zA-Z0-9]*[.])*[_a-zA-Z][_a-zA-Z0-9]*");
    private static final Pattern VALID_SDI_NAMESPACE = Pattern.compile("([_a-zA-Z][-_a-zA-Z0-9]*[.])*[_a-zA-Z][-_a-zA-Z0-9]*");

    @Override
    public ThriftDocument parse(InputStream in, String name) throws IOException, ParseException {
        Token token;
        ThriftDocument._Builder doc = ThriftDocument.builder();
        String packageName = ReflectionUtils.packageFromName(name);
        if (!VALID_PACKAGE.matcher(packageName).matches()) {
            throw new ParseException("Package name %s derived from filename %s is not valid.", packageName, name);
        }
        doc.setPackage(name.replaceAll(".*/", "").replace(".thrift", ""));
        LinkedList<String> includes = new LinkedList<String>();
        LinkedHashMap<String, String> namespaces = new LinkedHashMap<String, String>();
        LinkedList<Declaration> declarations = new LinkedList<Declaration>();
        Tokenizer tokenizer = new Tokenizer(in);
        boolean hasHeader = false;
        boolean hasDeclaration = false;
        String comment = null;
        block20: while ((token = tokenizer.next()) != null) {
            if (token.startsLineComment()) {
                comment = this.parseLineComment(tokenizer, comment);
                continue;
            }
            if (token.startsBlockComment()) {
                comment = this.parseBlockComment(tokenizer);
                continue;
            }
            String id = token.asString();
            if (!Model_Constants.kThriftKeywords.contains(id)) {
                throw new ParseException(tokenizer, token, "Unexpected token '%s'", token.asString());
            }
            switch (id) {
                case "namespace": {
                    if (hasDeclaration) {
                        throw new ParseException(tokenizer, token, "Unexpected token 'namespace', expected type declaration", new Object[0]);
                    }
                    if (comment != null && !hasHeader) {
                        doc.setComment(comment);
                    }
                    comment = null;
                    hasHeader = true;
                    this.parseNamespace(tokenizer, namespaces);
                    continue block20;
                }
                case "include": {
                    if (hasDeclaration) {
                        throw new ParseException(tokenizer, token, "Unexpected token 'include', expected type declaration", new Object[0]);
                    }
                    if (comment != null && !hasHeader) {
                        doc.setComment(comment);
                    }
                    comment = null;
                    hasHeader = true;
                    this.parseIncludes(tokenizer, includes);
                    continue block20;
                }
                case "typedef": {
                    hasHeader = true;
                    hasDeclaration = true;
                    this.parseTypedef(tokenizer, comment, declarations);
                    comment = null;
                    continue block20;
                }
                case "enum": {
                    hasHeader = true;
                    hasDeclaration = true;
                    EnumType et = this.parseEnum(tokenizer, comment);
                    declarations.add(Declaration.builder().setDeclEnum(et).build());
                    comment = null;
                    continue block20;
                }
                case "struct": 
                case "union": 
                case "exception": {
                    hasHeader = true;
                    hasDeclaration = true;
                    StructType st = this.parseStruct(tokenizer, token.asString(), comment);
                    declarations.add(Declaration.builder().setDeclStruct(st).build());
                    comment = null;
                    continue block20;
                }
                case "service": {
                    hasHeader = true;
                    hasDeclaration = true;
                    ServiceType srv = this.parseService(tokenizer, comment);
                    declarations.add(Declaration.builder().setDeclService(srv).build());
                    comment = null;
                    continue block20;
                }
                case "const": {
                    hasHeader = true;
                    hasDeclaration = true;
                    ThriftField cnst = this.parseConst(tokenizer, comment);
                    declarations.add(Declaration.builder().setDeclConst(cnst).build());
                    comment = null;
                    continue block20;
                }
            }
            throw new ParseException(tokenizer, token, "Unexpected token '%s', expected type declaration", token.asString());
        }
        doc.setNamespaces(namespaces);
        doc.setIncludes(includes);
        doc.setDecl(declarations);
        return doc.build();
    }

    private ThriftField parseConst(Tokenizer tokenizer, String comment) throws IOException, ParseException {
        Token token = tokenizer.expectQualifiedIdentifier("parsing const type");
        String type = this.parseType(tokenizer, token);
        Token id = tokenizer.expectIdentifier("parsing const identifier");
        tokenizer.expectSymbol("parsing const identifier", '=');
        String value = this.parseValue(tokenizer);
        Token sep = tokenizer.peek();
        if (sep != null && (sep.isSymbol(',') || sep.isSymbol(';'))) {
            tokenizer.next();
        }
        return ThriftField.builder().setComment(comment).setKey(-1).setName(id.asString()).setType(type).setDefaultValue(value).build();
    }

    private String parseValue(Tokenizer tokenizer) throws IOException, ParseException {
        Stack<Character> enclosures = new Stack<Character>();
        StringBuilder builder = new StringBuilder();
        while (true) {
            Token token;
            if ((token = tokenizer.expect("Parsing const value.")).startsBlockComment()) {
                this.parseBlockComment(tokenizer);
                continue;
            }
            if (token.startsLineComment()) {
                this.parseLineComment(tokenizer, null);
                continue;
            }
            if (token.isSymbol('{')) {
                enclosures.push(Character.valueOf('}'));
            } else if (token.isSymbol('[')) {
                enclosures.push(Character.valueOf(']'));
            } else if ((token.isSymbol('}') || token.isSymbol(']')) && ((Character)enclosures.peek()).equals(Character.valueOf(token.charAt(0)))) {
                enclosures.pop();
            }
            builder.append(token.asString());
            if (enclosures.isEmpty()) break;
        }
        return builder.toString();
    }

    private String parseLineComment(Tokenizer tokenizer, String comment) throws IOException {
        String line = Strings.readString((InputStream)tokenizer, (String)"\n").trim();
        if (comment != null) {
            return comment + "\n" + line;
        }
        return line;
    }

    private String parseBlockComment(Tokenizer tokenizer) throws IOException {
        String block = Strings.readString((InputStream)tokenizer, (String)new String(Token.kBlockCommentEnd)).trim();
        String[] lines = block.split("\n");
        StringBuilder builder = new StringBuilder();
        Pattern re = RE_BLOCK_LINE;
        for (String line : lines) {
            builder.append(re.matcher(line).replaceFirst(""));
            builder.append('\n');
        }
        return builder.toString().trim();
    }

    private ServiceType parseService(Tokenizer tokenizer, String comment) throws IOException, ParseException {
        String name;
        Token token;
        ServiceType._Builder service = ServiceType.builder();
        if (comment != null) {
            service.setComment(comment);
            comment = null;
        }
        Token identifier = tokenizer.expectIdentifier("parsing service identifier");
        service.setName(identifier.asString());
        if (tokenizer.peek().strEquals(Token.kExtends)) {
            tokenizer.next();
            service.setExtend(tokenizer.expectQualifiedIdentifier("service extending identifier").asString());
        }
        tokenizer.expectSymbol("reading service start", '{');
        TreeSet<String> methodNames = new TreeSet<String>();
        while (!(token = tokenizer.expect("reading service method")).isSymbol('}')) {
            Token value;
            int sep;
            ThriftField._Builder field;
            if (token.startsLineComment()) {
                comment = this.parseLineComment(tokenizer, comment);
                continue;
            }
            if (token.startsBlockComment()) {
                comment = this.parseBlockComment(tokenizer);
                continue;
            }
            ServiceMethod._Builder method = ServiceMethod.builder();
            if (comment != null) {
                method.setComment(comment);
                comment = null;
            }
            if (token.strEquals(Token.kOneway)) {
                method.setOneWay(true);
                token = tokenizer.expect("reading service method");
            }
            if (!token.strEquals(Token.kVoid)) {
                method.setReturnType(this.parseType(tokenizer, token));
            }
            if (methodNames.contains(name = tokenizer.expectIdentifier("reading method name").asString()) || methodNames.contains(Strings.camelCase((String)"", (String)name))) {
                throw new ParseException("", new Object[0]);
            }
            methodNames.add(name);
            methodNames.add(Strings.camelCase((String)"", (String)name));
            method.setName(name);
            tokenizer.expectSymbol("reading method params begin", '(');
            while (!(token = tokenizer.expect("reading method params")).isSymbol(')')) {
                if (token.startsLineComment()) {
                    comment = this.parseLineComment(tokenizer, comment);
                    continue;
                }
                if (token.startsBlockComment()) {
                    comment = this.parseBlockComment(tokenizer);
                    continue;
                }
                field = ThriftField.builder();
                if (comment != null) {
                    field.setComment(comment);
                    comment = null;
                }
                if (token.isInteger()) {
                    field.setKey((int)token.parseInteger());
                    tokenizer.expectSymbol("reading method params (:)", ':');
                    token = tokenizer.expect("reading method param type");
                }
                field.setType(this.parseType(tokenizer, token));
                field.setName(tokenizer.expectIdentifier("reading method param name").asString());
                if (tokenizer.peek("reading method param annotation").isSymbol('(')) {
                    tokenizer.next();
                    sep = 40;
                    while (sep != 41) {
                        token = tokenizer.expectQualifiedIdentifier("annotation name");
                        name = token.asString();
                        tokenizer.expectSymbol("", '=');
                        value = tokenizer.expectStringLiteral("annotation value");
                        field.putInAnnotations(name, value.decodeLiteral());
                        sep = tokenizer.expectSymbol("annotation sep", ')', ',', ';');
                    }
                }
                if ((token = tokenizer.peek("reading method params")).isSymbol(',') || token.isSymbol(';')) {
                    tokenizer.next();
                }
                method.addToParams(field.build());
            }
            comment = null;
            if (tokenizer.peek("parsing method exceptions").strEquals(Token.kThrows)) {
                tokenizer.next();
                tokenizer.expectSymbol("parsing method exceptions", '(');
                while (!(token = tokenizer.expect("parsing method exception")).isSymbol(')')) {
                    if (token.startsLineComment()) {
                        comment = this.parseLineComment(tokenizer, comment);
                        continue;
                    }
                    if (token.startsBlockComment()) {
                        comment = this.parseBlockComment(tokenizer);
                        continue;
                    }
                    field = ThriftField.builder();
                    if (comment != null) {
                        field.setComment(comment);
                        comment = null;
                    }
                    if (token.isInteger()) {
                        field.setKey((int)token.parseInteger());
                        tokenizer.expectSymbol("reading method exception (:)", ':');
                        token = tokenizer.expect("reading method exception type");
                    }
                    field.setType(this.parseType(tokenizer, token));
                    field.setName(tokenizer.expectIdentifier("reading method exception name").asString());
                    if (tokenizer.peek("reading method exception annotation").isSymbol('(')) {
                        tokenizer.next();
                        sep = 40;
                        while (sep != 41) {
                            token = tokenizer.expectQualifiedIdentifier("exception annotation name");
                            name = token.asString();
                            tokenizer.expectSymbol("", '=');
                            value = tokenizer.expectStringLiteral("exception annotation value");
                            field.putInAnnotations(name, value.decodeLiteral());
                            sep = tokenizer.expectSymbol("exception annotation sep", ')', ',', ';');
                        }
                    }
                    method.addToExceptions(field.build());
                    token = tokenizer.peek("reading method exceptions");
                    if (!token.isSymbol(',') && !token.isSymbol(';')) continue;
                    tokenizer.next();
                }
            }
            if ((token = tokenizer.peek("")).isSymbol('(')) {
                tokenizer.next();
                int sep2 = 40;
                while (sep2 != 41) {
                    token = tokenizer.expectQualifiedIdentifier("annotation name");
                    name = token.asString();
                    tokenizer.expectSymbol("", '=');
                    Token value2 = tokenizer.expectStringLiteral("annotation value");
                    method.putInAnnotations(name, value2.decodeLiteral());
                    sep2 = tokenizer.expectSymbol("annotation sep", ')', ',', ';');
                }
                token = tokenizer.peek("reading method params");
            }
            service.addToMethods(method.build());
            if (!token.isSymbol(',') && !token.isSymbol(';')) continue;
            tokenizer.next();
        }
        token = tokenizer.peek();
        if (token != null && token.isSymbol('(')) {
            tokenizer.next();
            int sep = 40;
            while (sep != 41) {
                token = tokenizer.expectQualifiedIdentifier("annotation name");
                name = token.asString();
                tokenizer.expectSymbol("", '=');
                Token value = tokenizer.expectStringLiteral("annotation value");
                service.putInAnnotations(name, value.decodeLiteral());
                sep = tokenizer.expectSymbol("annotation sep", ')', ',', ';');
            }
        }
        return service.build();
    }

    public void parseNamespace(Tokenizer tokenizer, Map<String, String> namespaces) throws IOException, ParseException {
        Token language = tokenizer.expectQualifiedIdentifier("parsing namespace language");
        if (!language.isQualifiedIdentifier()) {
            throw new ParseException(tokenizer, language, "Namespace language not valid identifier: '%s'", language.asString());
        }
        if (namespaces.containsKey(language.asString())) {
            throw new ParseException(tokenizer, language, "Namespace for %s already defined.", language.asString());
        }
        Token namespace = tokenizer.expectQualifiedIdentifier("parsing namespace");
        if (!namespace.isQualifiedIdentifier()) {
            throw new ParseException(tokenizer, namespace, "Namespace not valid: '%s'", namespace.asString());
        }
        namespaces.put(language.asString(), namespace.asString());
    }

    public void parseIncludes(Tokenizer tokenizer, List<String> includes) throws IOException, ParseException {
        Token include = tokenizer.expectStringLiteral("include file");
        String name = include.substring(1, -1).asString();
        if (!ReflectionUtils.isThriftFile(name)) {
            throw new ParseException(tokenizer, include, "Include not valid for thrift files " + name, new Object[0]);
        }
        includes.add(include.substring(1, -1).asString());
    }

    private void parseTypedef(Tokenizer tokenizer, String comment, List<Declaration> declarations) throws IOException, ParseException {
        String type = this.parseType(tokenizer, tokenizer.expect("parsing typedef type."));
        Token id = tokenizer.expectIdentifier("parsing typedef identifier.");
        TypedefType typedef = TypedefType.builder().setComment(comment).setType(type).setName(id.asString()).build();
        declarations.add(Declaration.withDeclTypedef(typedef));
    }

    public EnumType parseEnum(Tokenizer tokenizer, String comment) throws IOException, ParseException {
        Token token;
        String id = tokenizer.expectIdentifier("parsing enum identifier").asString();
        EnumType._Builder etb = EnumType.builder();
        if (comment != null) {
            etb.setComment(comment);
            comment = null;
        }
        etb.setName(id);
        int nextValue = 0;
        tokenizer.expectSymbol("parsing enum " + id, '{');
        if (!tokenizer.peek("").isSymbol('}')) {
            while (!(token = tokenizer.expect("parsing enum " + id)).isSymbol('}')) {
                if (token.startsLineComment()) {
                    comment = this.parseLineComment(tokenizer, comment);
                    continue;
                }
                if (token.startsBlockComment()) {
                    comment = this.parseBlockComment(tokenizer);
                    continue;
                }
                if (token.isIdentifier()) {
                    EnumValue._Builder evb = EnumValue.builder();
                    evb.setName(token.asString());
                    int value = nextValue++;
                    if (tokenizer.peek("parsing enum " + id).isSymbol('=')) {
                        tokenizer.next();
                        Token v = tokenizer.expectInteger("");
                        value = (int)v.parseInteger();
                        nextValue = value + 1;
                    }
                    evb.setValue(value);
                    if (tokenizer.peek("parsing enum " + id).isSymbol('(')) {
                        tokenizer.next();
                        int sep2 = 40;
                        while (sep2 != 41) {
                            token = tokenizer.expectQualifiedIdentifier("annotation name");
                            String name = token.asString();
                            tokenizer.expectSymbol("", '=');
                            Token val = tokenizer.expectStringLiteral("annotation value");
                            evb.putInAnnotations(name, val.decodeLiteral());
                            sep2 = tokenizer.expectSymbol("annotation sep", ')', ',', ';');
                        }
                    }
                    etb.addToValues(evb.build());
                    token = tokenizer.peek("parsing enum " + id);
                    if (!token.isSymbol(',') && !token.isSymbol(';')) continue;
                    tokenizer.next();
                    continue;
                }
                throw new ParseException(tokenizer, token, "Unexpected token while parsing enum %d: %s", id, token.asString());
            }
        }
        if ((token = tokenizer.peek()) != null && token.isSymbol('(')) {
            tokenizer.next();
            char sep = token.charAt(0);
            while (sep != ')') {
                token = tokenizer.expectQualifiedIdentifier("annotation name");
                String name = token.asString();
                tokenizer.expectSymbol("", '=');
                Token val = tokenizer.expectStringLiteral("annotation value");
                etb.putInAnnotations(name, val.decodeLiteral());
                sep = tokenizer.expectSymbol("annotation sep", ')', ',', ';');
            }
        }
        return etb.build();
    }

    private StructType parseStruct(Tokenizer tokenizer, String type, String comment) throws IOException, ParseException {
        Object name;
        Token token;
        Token id;
        StructType._Builder struct = StructType.builder();
        if (comment != null) {
            struct.setComment(comment);
            comment = null;
        }
        boolean union = type.equals("union");
        if (!type.equals("struct")) {
            struct.setVariant(StructVariant.forName(type.toUpperCase()));
        }
        if (!(id = tokenizer.expectIdentifier("parsing " + type + " identifier")).isIdentifier()) {
            throw new ParseException("Struct name " + id.asString() + " is not valid identifier", new Object[]{tokenizer, id});
        }
        struct.setName(id.asString());
        int nextDefaultKey = 65535;
        tokenizer.expectSymbol("parsing struct " + id.asString(), '{');
        HashSet<String> fieldNames = new HashSet<String>();
        HashSet<String> fieldNameVariants = new HashSet<String>();
        HashSet<Integer> fieldIds = new HashSet<Integer>();
        while (!(token = tokenizer.expect("parsing struct " + id.asString())).isSymbol('}')) {
            if (token.startsLineComment()) {
                comment = this.parseLineComment(tokenizer, comment);
                continue;
            }
            if (token.startsBlockComment()) {
                comment = this.parseBlockComment(tokenizer);
                continue;
            }
            ThriftField._Builder field = ThriftField.builder();
            field.setComment(comment);
            comment = null;
            if (token.isInteger()) {
                int fId = (int)token.parseInteger();
                if (fId < 1) {
                    throw new ParseException("Negative field id " + fId + " not allowed.", new Object[]{token, tokenizer});
                }
                if (fieldIds.contains(fId)) {
                    throw new ParseException("Field id " + fId + " already exists in struct " + struct.build().getName(), new Object[]{token, tokenizer});
                }
                fieldIds.add(fId);
                field.setKey(fId);
                tokenizer.expectSymbol("parsing struct " + id.asString(), ':');
                token = tokenizer.expect("parsing struct " + id.asString());
            } else {
                field.setKey(nextDefaultKey--);
            }
            if (token.strEquals(Token.kRequired)) {
                if (union) {
                    throw new ParseException("Found required field in union. Not allowed. " + token.asString(), new Object[]{tokenizer, token});
                }
                field.setRequirement(Requirement.REQUIRED);
                token = tokenizer.expect("parsing struct " + id.asString());
            } else if (token.strEquals(Token.kOptional)) {
                if (!union) {
                    field.setRequirement(Requirement.OPTIONAL);
                }
                token = tokenizer.expect("parsing struct " + id.asString());
            }
            field.setType(this.parseType(tokenizer, token));
            name = tokenizer.expectIdentifier("parsing struct " + id.asString());
            String fName = name.asString();
            if (fieldNames.contains(name)) {
                throw new ParseException("Field name " + fName + " already exists in struct " + struct.build().getName(), new Object[]{token, tokenizer});
            }
            if (fieldNameVariants.contains(Strings.camelCase((String)"get", (String)fName))) {
                throw new ParseException("Field name " + fName + " conflicts with existing field in struct " + struct.build().getName(), new Object[]{token, tokenizer});
            }
            fieldNames.add(fName);
            fieldNameVariants.add(Strings.camelCase((String)"get", (String)fName));
            field.setName(fName);
            token = tokenizer.peek("");
            if (token.isSymbol('=')) {
                tokenizer.next();
                field.setDefaultValue(this.parseValue(tokenizer));
                token = tokenizer.peek("");
            }
            if (token.isSymbol('(')) {
                tokenizer.next();
                char sep = token.charAt(0);
                while (sep != ')') {
                    token = tokenizer.expectQualifiedIdentifier("annotation name");
                    String aName = token.asString();
                    tokenizer.expectSymbol("", '=');
                    Token val = tokenizer.expectStringLiteral("annotation value");
                    field.putInAnnotations(aName, val.decodeLiteral());
                    sep = tokenizer.expectSymbol("annotation sep", ')', ',', ';');
                }
                token = tokenizer.peek("");
            }
            struct.addToFields(field.build());
            if (!token.isSymbol(',') && !token.isSymbol(';')) continue;
            tokenizer.next();
        }
        token = tokenizer.peek();
        if (token != null && token.isSymbol('(')) {
            tokenizer.next();
            char sep = token.charAt(0);
            while (sep != ')') {
                token = tokenizer.expectQualifiedIdentifier("annotation name");
                name = token.asString();
                tokenizer.expectSymbol("", '=');
                Token val = tokenizer.expectStringLiteral("annotation value");
                struct.putInAnnotations((String)name, val.decodeLiteral());
                sep = tokenizer.expectSymbol("annotation sep", ')', ',', ';');
            }
        }
        return struct.build();
    }

    private String parseType(Tokenizer tokenizer, Token token) throws IOException, ParseException {
        String type;
        if (!token.isQualifiedIdentifier()) {
            throw new ParseException(tokenizer, token, "Expected type identifier but found " + (Object)((Object)token), new Object[0]);
        }
        switch (type = token.asString()) {
            case "list": 
            case "set": {
                tokenizer.expectSymbol("parsing " + type + " item type", '<');
                String item = this.parseType(tokenizer, tokenizer.expectQualifiedIdentifier("parsing " + type + " item type"));
                tokenizer.expectSymbol("parsing " + type + " item type", '>');
                return String.format("%s<%s>", type, item);
            }
            case "map": {
                tokenizer.expectSymbol("parsing " + type + " item type", '<');
                String key = this.parseType(tokenizer, tokenizer.expectQualifiedIdentifier("parsing " + type + " key type"));
                tokenizer.expectSymbol("parsing " + type + " item type", ',');
                String item = this.parseType(tokenizer, tokenizer.expectQualifiedIdentifier("parsing " + type + " item type"));
                tokenizer.expectSymbol("parsing " + type + " item type", '>');
                return String.format("%s<%s,%s>", type, key, item);
            }
        }
        return type;
    }
}

