/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.reflect.contained;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.PUnion;
import net.morimekta.providence.descriptor.PList;
import net.morimekta.providence.descriptor.PSet;
import net.morimekta.providence.reflect.contained.CField;
import net.morimekta.providence.reflect.contained.CMessage;
import net.morimekta.providence.reflect.contained.CUnionDescriptor;

public class CUnion
extends CMessage<CUnion>
implements PUnion<CUnion> {
    private final CUnionDescriptor descriptor;
    private final CField unionField;

    private CUnion(Builder builder) {
        super(builder.getValueMap());
        this.unionField = builder.field;
        this.descriptor = builder.descriptor;
    }

    public PMessageBuilder<CUnion> mutate() {
        return new Builder(this.descriptor);
    }

    public CUnionDescriptor descriptor() {
        return this.descriptor;
    }

    public CField unionField() {
        return this.unionField;
    }

    public static class Builder
    extends PMessageBuilder<CUnion> {
        private final CUnionDescriptor descriptor;
        private CField field;
        private Object value;

        public Builder(CUnionDescriptor descriptor) {
            this.descriptor = descriptor;
        }

        private Map<Integer, Object> getValueMap() {
            if (this.field == null) {
                return ImmutableMap.of();
            }
            if (this.value == null) {
                return ImmutableMap.of((Object)this.field.getKey(), null);
            }
            switch (this.field.getType()) {
                case LIST: {
                    return ImmutableMap.of((Object)this.field.getKey(), (Object)((PList.Builder)this.value).build());
                }
                case SET: {
                    return ImmutableMap.of((Object)this.field.getKey(), (Object)((PSet.Builder)this.value).build());
                }
            }
            return ImmutableMap.of((Object)this.field.getKey(), (Object)this.value);
        }

        public CUnion build() {
            return new CUnion(this);
        }

        public boolean isValid() {
            return this.field != null;
        }

        public Builder set(int key, Object value) {
            CField field = this.descriptor.getField(key);
            if (field == null) {
                return this;
            }
            this.field = field;
            this.value = value;
            return this;
        }

        public Builder addTo(int key, Object value) {
            CField field = this.descriptor.getField(key);
            if (field == null) {
                return this;
            }
            if (this.field != field || this.value == null) {
                this.field = field;
                switch (field.getType()) {
                    case LIST: {
                        PList lType = (PList)field.getDescriptor();
                        this.value = lType.builder();
                        break;
                    }
                    case SET: {
                        PSet lType = (PSet)field.getDescriptor();
                        this.value = lType.builder();
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unable to accept addTo on non-list field " + field.getName());
                    }
                }
            }
            switch (field.getType()) {
                case LIST: {
                    ((PList.Builder)this.value).add(value);
                    break;
                }
                case SET: {
                    ((PList.Builder)this.value).add(value);
                }
            }
            return this;
        }

        public Builder clear(int key) {
            this.field = null;
            this.value = null;
            return this;
        }
    }
}

