/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.reflect.contained;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import net.morimekta.providence.PEnumBuilder;
import net.morimekta.providence.PEnumValue;
import net.morimekta.providence.descriptor.PEnumDescriptor;
import net.morimekta.providence.reflect.contained.CAnnotatedDescriptor;
import net.morimekta.providence.reflect.contained.CEnumDescriptor;

public class CEnum
implements PEnumValue<CEnum>,
CAnnotatedDescriptor {
    private final int value;
    private final String name;
    private final PEnumDescriptor<CEnum> type;
    private final String comment;
    private final Map<String, String> annotations;

    public CEnum(String comment, int value, String name, PEnumDescriptor<CEnum> type, Map<String, String> annotations) {
        this.comment = comment;
        this.value = value;
        this.name = name;
        this.type = type;
        this.annotations = annotations;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public Set<String> getAnnotations() {
        if (this.annotations != null) {
            return this.annotations.keySet();
        }
        return Collections.EMPTY_SET;
    }

    @Override
    public boolean hasAnnotation(String name) {
        if (this.annotations != null) {
            return this.annotations.containsKey(name);
        }
        return false;
    }

    @Override
    public String getAnnotationValue(String name) {
        if (this.annotations != null) {
            return this.annotations.get(name);
        }
        return null;
    }

    public PEnumDescriptor<CEnum> descriptor() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof CEnum)) {
            return false;
        }
        CEnum other = (CEnum)o;
        return other.descriptor().getQualifiedName(null).equals(this.type.getQualifiedName(null)) && other.getName().equals(this.name) && other.getValue() == this.value;
    }

    public int compareTo(CEnum other) {
        return Integer.compare(this.value, other.value);
    }

    public String toString() {
        return this.name.toUpperCase();
    }

    public static class Builder
    extends PEnumBuilder<CEnum> {
        private final CEnumDescriptor mType;
        private CEnum mValue = null;

        public Builder(CEnumDescriptor type) {
            this.mType = type;
        }

        public CEnum build() {
            return this.mValue;
        }

        public boolean isValid() {
            return this.mValue != null;
        }

        public Builder setByValue(int id) {
            this.mValue = this.mType.getValueById(id);
            return this;
        }

        public Builder setByName(String name) {
            this.mValue = this.mType.getValueByName(name);
            return this;
        }
    }
}

