/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.reflect.util;

import java.util.LinkedHashMap;
import java.util.Map;
import net.morimekta.providence.descriptor.PDeclaredDescriptor;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PDescriptorProvider;
import net.morimekta.providence.descriptor.PList;
import net.morimekta.providence.descriptor.PMap;
import net.morimekta.providence.descriptor.PPrimitive;
import net.morimekta.providence.descriptor.PSet;
import net.morimekta.providence.reflect.contained.CDocument;

public class TypeRegistry {
    private final Map<String, PDeclaredDescriptor<?>> mDeclaredTypes = new LinkedHashMap();
    private final Map<String, String> mTypedefs = new LinkedHashMap<String, String>();
    private final Map<String, CDocument> mDocuments = new LinkedHashMap<String, CDocument>();

    public boolean putDocument(String path, CDocument doc) {
        if (!this.mDocuments.containsKey(path)) {
            this.mDocuments.put(path, doc);
            return true;
        }
        return false;
    }

    public CDocument getDocument(String path) {
        return this.mDocuments.get(path);
    }

    public CDocument getDocumentForPackage(String packageContext) {
        for (CDocument document : this.mDocuments.values()) {
            if (!document.getPackageName().equals(packageContext)) continue;
            return document;
        }
        return null;
    }

    public <T extends PDeclaredDescriptor<T>> T getDescriptor(String name, String packageContext) {
        String declaredTypeName = name;
        if (!name.contains(".") && packageContext != null) {
            declaredTypeName = packageContext + "." + name;
        }
        if (this.mDeclaredTypes.containsKey(declaredTypeName)) {
            return (T)this.mDeclaredTypes.get(declaredTypeName);
        }
        throw new IllegalArgumentException("No such type \"" + name + "\" for package \"" + packageContext + "\"");
    }

    public <T> void putDeclaredType(PDeclaredDescriptor<T> declaredType) {
        String declaredTypeName = declaredType.getQualifiedName(null);
        if (this.mDeclaredTypes.containsKey(declaredTypeName)) {
            throw new IllegalStateException("Type " + declaredTypeName + " already exists");
        }
        this.mDeclaredTypes.put(declaredTypeName, declaredType);
    }

    public void putTypedef(String typeName, String identifier) {
        if (identifier == null || typeName == null) {
            throw new IllegalArgumentException("NOOO!");
        }
        this.mTypedefs.put(identifier, typeName);
    }

    public <T> PDescriptorProvider<T> getProvider(String typeName, final String packageContext) {
        while (this.mTypedefs.containsKey(typeName)) {
            typeName = this.mTypedefs.get(typeName);
        }
        PPrimitive primitive = PPrimitive.findByName((String)typeName);
        if (primitive != null) {
            return primitive.provider();
        }
        if (typeName.startsWith("map<") && typeName.endsWith(">")) {
            String[] parts = typeName.substring(4, typeName.length() - 1).split(",", 2);
            if (parts.length != 2) {
                throw new IllegalArgumentException(typeName + " is not a valid map descriptor, wrong number of types.");
            }
            String keyType = parts[0];
            String valueType = parts[1];
            return PMap.provider(this.getProvider(keyType, packageContext), this.getProvider(valueType, packageContext));
        }
        if (typeName.startsWith("set<") && typeName.endsWith(">")) {
            String itemType = typeName.substring(4, typeName.length() - 1);
            return PSet.provider(this.getProvider(itemType, packageContext));
        }
        if (typeName.startsWith("list<") && typeName.endsWith(">")) {
            String itemType = typeName.substring(5, typeName.length() - 1);
            return PList.provider(this.getProvider(itemType, packageContext));
        }
        final String name = typeName;
        return new PDescriptorProvider<T>(){

            public PDescriptor<T> descriptor() {
                return TypeRegistry.this.getDescriptor(name, packageContext);
            }
        };
    }
}

