/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.reflect.util;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import net.morimekta.providence.descriptor.PDeclaredDescriptor;
import net.morimekta.providence.descriptor.PDescriptorProvider;
import net.morimekta.providence.descriptor.PEnumDescriptor;
import net.morimekta.providence.descriptor.PRequirement;
import net.morimekta.providence.model.Declaration;
import net.morimekta.providence.model.EnumType;
import net.morimekta.providence.model.EnumValue;
import net.morimekta.providence.model.StructType;
import net.morimekta.providence.model.ThriftDocument;
import net.morimekta.providence.model.ThriftField;
import net.morimekta.providence.reflect.contained.CDocument;
import net.morimekta.providence.reflect.contained.CEnum;
import net.morimekta.providence.reflect.contained.CEnumDescriptor;
import net.morimekta.providence.reflect.contained.CExceptionDescriptor;
import net.morimekta.providence.reflect.contained.CField;
import net.morimekta.providence.reflect.contained.CStructDescriptor;
import net.morimekta.providence.reflect.contained.CUnionDescriptor;
import net.morimekta.providence.reflect.util.ConstProvider;
import net.morimekta.providence.reflect.util.TypeRegistry;

public class DocumentConverter {
    private final TypeRegistry mRegistry;

    public DocumentConverter(TypeRegistry registry) {
        this.mRegistry = registry;
    }

    public CDocument convert(ThriftDocument document) {
        LinkedList declaredTypes = new LinkedList();
        LinkedList constants = new LinkedList();
        LinkedHashMap<String, String> typedefs = new LinkedHashMap<String, String>();
        for (Declaration decl : document.getDecl()) {
            Object type;
            if (decl.hasDeclEnum()) {
                EnumType enumType = decl.getDeclEnum();
                int nextValue = 0;
                type = new CEnumDescriptor(enumType.getComment(), document.getPackage(), enumType.getName());
                LinkedList<CEnum> values = new LinkedList<CEnum>();
                for (EnumValue value : enumType.getValues()) {
                    int v = value.hasValue() ? value.getValue() : nextValue;
                    nextValue = v + 1;
                    values.add(new CEnum(value.getComment(), value.getValue(), value.getName(), (PEnumDescriptor<CEnum>)type));
                }
                ((CEnumDescriptor)((Object)type)).setValues(values);
                declaredTypes.add((PDeclaredDescriptor<?>)type);
                this.mRegistry.putDeclaredType(type);
            }
            if (decl.hasDeclStruct()) {
                StructType structType = decl.getDeclStruct();
                LinkedList<CField> fields = new LinkedList<CField>();
                for (ThriftField field : structType.getFields()) {
                    fields.add(this.makeField(document.getPackage(), field));
                }
                switch (structType.getVariant()) {
                    case STRUCT: {
                        type = new CStructDescriptor(structType.getComment(), document.getPackage(), structType.getName(), fields);
                        break;
                    }
                    case UNION: {
                        type = new CUnionDescriptor(structType.getComment(), document.getPackage(), structType.getName(), fields);
                        break;
                    }
                    case EXCEPTION: {
                        type = new CExceptionDescriptor(structType.getComment(), document.getPackage(), structType.getName(), fields);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unhandled struct type " + (Object)((Object)structType.getVariant()));
                    }
                }
                declaredTypes.add((PDeclaredDescriptor<?>)type);
                this.mRegistry.putDeclaredType(type);
            }
            if (decl.hasDeclConst()) {
                ThriftField constant = decl.getDeclConst();
                constants.add(this.makeField(document.getPackage(), constant));
            }
            if (!decl.hasDeclTypedef()) continue;
            typedefs.put(decl.getDeclTypedef().getName(), decl.getDeclTypedef().getType());
            this.mRegistry.putTypedef(decl.getDeclTypedef().getType(), decl.getDeclTypedef().getName());
        }
        return new CDocument(document.getComment(), document.getPackage(), document.getNamespaces(), this.getIncludes(document), typedefs, declaredTypes, constants);
    }

    private List<String> getIncludes(ThriftDocument document) {
        LinkedList<String> out = new LinkedList<String>();
        for (String include : document.getIncludes()) {
            int i = include.lastIndexOf(46);
            if (i > 0) {
                include = include.substring(0, i);
            }
            out.add(include);
        }
        return out;
    }

    private CField makeField(String pkg, ThriftField field) {
        PDescriptorProvider type = this.mRegistry.getProvider(field.getType(), pkg);
        ConstProvider defaultValue = null;
        if (field.hasDefaultValue()) {
            defaultValue = new ConstProvider(this.mRegistry, field.getType(), pkg, field.getDefaultValue());
        }
        CField<Object> made = new CField<Object>(field.getComment(), field.getKey(), PRequirement.valueOf((String)field.getRequirement().getName()), field.getName(), type, defaultValue);
        return made;
    }
}

