/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.reflect.parser.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import net.morimekta.providence.reflect.parser.ParseException;
import net.morimekta.providence.reflect.parser.internal.Symbol;
import net.morimekta.providence.reflect.parser.internal.Token;
import net.morimekta.util.Strings;
import net.morimekta.util.io.Utf8StreamReader;

public class Tokenizer {
    private final Utf8StreamReader mIn;
    private int mLine;
    private int mPos;
    private int mLastByte;
    private boolean mLiteral;
    private boolean mLiteralExcaped;
    private boolean mSlash;
    private final ArrayList<String> mLines;
    private StringBuilder mLineBuilder;
    private Token mNextToken;

    public Tokenizer(InputStream in) throws IOException {
        this.mIn = new Utf8StreamReader(in);
        this.mLine = 1;
        this.mPos = 0;
        this.mLastByte = 0;
        this.mLiteral = false;
        this.mLiteralExcaped = false;
        this.mLineBuilder = new StringBuilder();
        this.mLines = new ArrayList();
    }

    public Token expect(String message) throws IOException, ParseException {
        if (!this.hasNext()) {
            throw this.newParseException("Unexpected end of file while " + message);
        }
        return this.next();
    }

    public void expectSymbol(Symbol symbol, String message) throws IOException, ParseException {
        if (!this.hasNext()) {
            throw this.newParseException("Unexpected end of file, expected " + (Object)((Object)symbol) + " while " + message);
        }
        if (!this.mNextToken.isSymbol() || !this.mNextToken.getSymbol().equals((Object)symbol)) {
            throw this.newParseException("Expected " + (Object)((Object)symbol) + " but found " + this.mNextToken + " while " + message);
        }
        this.mNextToken = null;
    }

    public Token expectIdentifier(String message) throws IOException, ParseException {
        if (!this.hasNext()) {
            throw this.newParseException("Unexpected end of file, expected identifier while " + message);
        }
        if (this.mNextToken.isIdentifier()) {
            return this.next();
        }
        throw this.newParseException("Expected identifier but found " + this.mNextToken + " while " + message);
    }

    public Token expectQualifiedIdentifier(String message) throws IOException, ParseException {
        if (!this.hasNext()) {
            throw this.newParseException("Unexpected end of file, expected identifier while " + message);
        }
        if (this.mNextToken.isQualifiedIdentifier()) {
            return this.next();
        }
        throw this.newParseException("Expected qualified identifier but found " + this.mNextToken + " while " + message);
    }

    public boolean hasNext() throws IOException, ParseException {
        if (this.mNextToken == null) {
            this.mNextToken = this.next();
        }
        return this.mNextToken != null;
    }

    public Token next() throws IOException, ParseException {
        if (this.mNextToken != null) {
            Token tmp = this.mNextToken;
            this.mNextToken = null;
            return tmp;
        }
        int startPos = this.mPos;
        StringBuilder builder = new StringBuilder();
        while (this.mLastByte >= 0) {
            int b = this.mLastByte;
            this.mLastByte = 0;
            if (b == 0) {
                b = this.mLastByte = this.mIn.read();
                ++this.mPos;
            }
            if (b > 0) {
                Token token;
                if (b != 10) {
                    this.mLineBuilder.append((char)b);
                }
                if (this.mLiteral) {
                    this.mLastByte = 0;
                    builder.append((char)b);
                    if (b == 10) {
                        throw this.newParseException("Literal newline in string literal");
                    }
                    if (this.mLiteralExcaped) {
                        this.mLiteralExcaped = false;
                        continue;
                    }
                    if (b == Symbol.LITERAL_ESCAPE.c) {
                        this.mLiteralExcaped = true;
                        continue;
                    }
                    if (b != Symbol.LITERAL_QUOTE.c) continue;
                    this.mLiteral = false;
                    return this.mkToken(builder, startPos);
                }
                if (this.mSlash) {
                    this.mSlash = false;
                    this.mLastByte = 0;
                    if (b == 47 || b == 42) {
                        builder.append((char)b);
                        return this.mkToken(builder, startPos);
                    }
                    if (b < 32 || b >= 127) {
                        throw this.newParseException(String.format("Invalid start of comment '\\x%x'. Must be '/*' or '//'", b));
                    }
                    throw this.newParseException(String.format("Invalid start of comment '/%c'. Must be '/*' or '//'", Character.valueOf((char)b)));
                }
                Symbol ct = Symbol.valueOf((byte)b);
                if (ct != null) {
                    token = this.mkToken(builder, startPos);
                    if (token != null) {
                        return token;
                    }
                    this.mLastByte = 0;
                    if (b == Symbol.LITERAL_QUOTE.c) {
                        this.mLiteral = true;
                        this.mLiteralExcaped = false;
                        builder.append((char)b);
                        continue;
                    }
                    if (b == Symbol.JAVA_COMMENT.c) {
                        this.mSlash = true;
                        builder.append((char)b);
                        continue;
                    }
                    return this.mkToken(ct, this.mPos);
                }
                if (b == 32 || b == 9 || b == 13) {
                    this.mLastByte = 0;
                    if (builder.length() > 0) {
                        return this.mkToken(builder, startPos);
                    }
                } else if (b == 10) {
                    this.mLastByte = 0;
                    this.mLines.add(this.mLineBuilder.toString());
                    this.mLineBuilder = new StringBuilder();
                    token = this.mkToken(builder, startPos);
                    ++this.mLine;
                    this.mPos = 0;
                    if (token != null) {
                        return token;
                    }
                } else {
                    builder.append((char)b);
                }
            } else {
                return this.mkToken(builder, startPos);
            }
            this.mLastByte = 0;
        }
        return null;
    }

    public void unshift(Token token) {
        this.mNextToken = token;
    }

    public String getLine(int line) throws IOException {
        if (line < 1) {
            throw new IllegalArgumentException("Oops!!!");
        }
        if (this.mLines.size() >= line) {
            return this.mLines.get(line - 1);
        }
        this.mLineBuilder.append(Strings.readString((Reader)this.mIn, (char)'\n'));
        return this.mLineBuilder.toString();
    }

    public String readUntil(char terminator) throws IOException {
        return Strings.readString((Reader)this.mIn, (char)terminator);
    }

    public String readUntil(String terminator) throws IOException {
        return Strings.readString((Reader)this.mIn, (String)terminator);
    }

    private ParseException newParseException(String s) throws IOException {
        return new ParseException(s, this.getLine(this.mLine), this.mLine, this.mPos, 0);
    }

    private Token mkToken(Symbol ct, int pos) {
        return new Token(ct.toString(), this.mLine, pos, 1);
    }

    private Token mkToken(StringBuilder builder, int startPos) {
        if (builder.length() > 0) {
            return new Token(builder.toString(), this.mLine, startPos, this.mPos - startPos - 1);
        }
        return null;
    }
}

