/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.reflect.parser.internal;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.regex.Pattern;
import net.morimekta.providence.reflect.parser.ParseException;
import net.morimekta.providence.reflect.parser.internal.Keyword;
import net.morimekta.providence.reflect.parser.internal.Symbol;
import net.morimekta.util.json.JsonException;
import net.morimekta.util.json.JsonToken;
import net.morimekta.util.json.JsonTokenizer;

public class Token {
    public static final Pattern RE_IDENTIFIER = Pattern.compile("[_a-zA-Z][_a-zA-Z0-9]*");
    public static final Pattern RE_QUALIFIED_IDENTIFIER = Pattern.compile("([_a-zA-Z][_a-zA-Z0-9]*[.])*[_a-zA-Z][_a-zA-Z0-9]*");
    public static final Pattern RE_INTEGER = Pattern.compile("-?(0|[1-9][0-9]*|0[0-7]+|0x[0-9a-fA-F]+)");
    private final String mToken;
    private final int mLine;
    private final int mPos;
    private final int mLen;

    public boolean startsLineComment() {
        return this.mToken.equals(Character.toString((char)Symbol.SHELL_COMMENT.c)) || this.mToken.equals(Keyword.JAVA_LINE_COMMENT_START.keyword);
    }

    public boolean startsBlockComment() {
        return this.mToken.equals(Keyword.BLOCK_COMMENT_START.keyword);
    }

    public Token(String token, int line, int pos, int len) {
        this.mToken = token;
        this.mLine = line;
        this.mPos = pos;
        this.mLen = len;
    }

    public String getToken() {
        return this.mToken;
    }

    public int getLine() {
        return this.mLine;
    }

    public int getPos() {
        return this.mPos;
    }

    public int getLen() {
        return this.mLen;
    }

    public boolean isSymbol() {
        return this.mLen == 1 && Symbol.valueOf(this.mToken.charAt(0)) != null;
    }

    public boolean isLiteral() {
        return this.mToken.length() > 1 && this.mToken.charAt(0) == '\"' && this.mToken.charAt(this.mToken.length() - 1) == '\"';
    }

    public boolean isIdentifier() {
        return RE_IDENTIFIER.matcher(this.mToken).matches();
    }

    public boolean isQualifiedIdentifier() {
        return RE_QUALIFIED_IDENTIFIER.matcher(this.mToken).matches();
    }

    public boolean isInteger() {
        return RE_INTEGER.matcher(this.mToken).matches();
    }

    public Symbol getSymbol() {
        return Symbol.valueOf(this.mToken.charAt(0));
    }

    public String literalValue() throws ParseException {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(this.mToken.getBytes(StandardCharsets.UTF_8));
            JsonTokenizer tokenizer = new JsonTokenizer((InputStream)bais);
            JsonToken token = tokenizer.expect("parsing string literal.");
            return token.decodeJsonLiteral();
        }
        catch (JsonException e) {
            throw new ParseException("Unable to parse string literal: " + this.mToken, e);
        }
        catch (IOException e) {
            throw new ParseException("Unable to read string literal: " + this.mToken, e);
        }
    }

    public int intValue() {
        if (this.mToken.startsWith("0x")) {
            return Integer.parseInt(this.mToken.substring(2), 16);
        }
        if (this.mToken.startsWith("0") && this.mToken.length() > 1) {
            return Integer.parseInt(this.mToken.substring(1), 8);
        }
        return Integer.parseInt(this.mToken);
    }

    public String toString() {
        return String.format("Token('%s',%d:%d-%d)", this.mToken, this.mLine, this.mPos, this.mLen);
    }
}

