/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.reflect.parser;

import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Pattern;
import net.morimekta.providence.model.Declaration;
import net.morimekta.providence.model.EnumType;
import net.morimekta.providence.model.EnumValue;
import net.morimekta.providence.model.Requirement;
import net.morimekta.providence.model.ServiceMethod;
import net.morimekta.providence.model.ServiceType;
import net.morimekta.providence.model.StructType;
import net.morimekta.providence.model.StructVariant;
import net.morimekta.providence.model.ThriftDocument;
import net.morimekta.providence.model.ThriftField;
import net.morimekta.providence.model.TypedefType;
import net.morimekta.providence.reflect.parser.ParseException;
import net.morimekta.providence.reflect.parser.Parser;
import net.morimekta.providence.reflect.parser.internal.Keyword;
import net.morimekta.providence.reflect.parser.internal.Symbol;
import net.morimekta.providence.reflect.parser.internal.Token;
import net.morimekta.providence.reflect.parser.internal.Tokenizer;

public class ThriftParser
implements Parser {
    private static final Pattern RE_BLOCK_LINE = Pattern.compile("^([\\s]*[*])?[\\s]?");

    @Override
    public ThriftDocument parse(InputStream in, String name) throws IOException, ParseException {
        Token token;
        ThriftDocument._Builder doc = ThriftDocument.builder();
        doc.setPackage(name.replaceAll(".*/", "").replace(".thrift", ""));
        LinkedList<String> includes = new LinkedList<String>();
        LinkedHashMap<String, String> namespaces = new LinkedHashMap<String, String>();
        LinkedList<Declaration> declarations = new LinkedList<Declaration>();
        Tokenizer tokenizer = new Tokenizer(in);
        boolean hasHeader = false;
        boolean hasDeclaration = false;
        String comment = null;
        block9: while ((token = tokenizer.next()) != null) {
            if (token.startsLineComment()) {
                comment = this.parseLineComment(tokenizer, comment);
                continue;
            }
            if (token.startsBlockComment()) {
                comment = this.parseBlockComment(tokenizer);
                continue;
            }
            Keyword keyword = Keyword.getByToken(token.getToken());
            if (keyword == null) {
                throw new ParseException("Unexpected token \"" + token.getToken() + "\"", tokenizer, token);
            }
            switch (keyword) {
                case NAMESPACE: {
                    if (hasDeclaration) {
                        throw new ParseException("Unexpected token 'namespace', expected type declaration", tokenizer, token);
                    }
                    if (comment != null && !hasHeader) {
                        doc.setComment(comment);
                    }
                    comment = null;
                    hasHeader = true;
                    this.parseNamespace(tokenizer, namespaces);
                    continue block9;
                }
                case INCLUDE: {
                    if (hasDeclaration) {
                        throw new ParseException("Unexpected token 'include', expected type declaration", tokenizer, token);
                    }
                    if (comment != null && !hasHeader) {
                        doc.setComment(comment);
                    }
                    comment = null;
                    hasHeader = true;
                    this.parseIncludes(tokenizer, includes);
                    continue block9;
                }
                case TYPEDEF: {
                    hasHeader = true;
                    hasDeclaration = true;
                    this.parseTypedef(tokenizer, comment, declarations);
                    comment = null;
                    continue block9;
                }
                case ENUM: {
                    hasHeader = true;
                    hasDeclaration = true;
                    EnumType et = this.parseEnum(tokenizer, comment);
                    declarations.add(Declaration.builder().setDeclEnum(et).build());
                    comment = null;
                    continue block9;
                }
                case STRUCT: 
                case UNION: 
                case EXCEPTION: {
                    hasHeader = true;
                    hasDeclaration = true;
                    StructType st = this.parseStruct(tokenizer, token.getToken(), comment);
                    declarations.add(Declaration.builder().setDeclStruct(st).build());
                    comment = null;
                    continue block9;
                }
                case SERVICE: {
                    hasHeader = true;
                    hasDeclaration = true;
                    ServiceType srv = this.parseService(tokenizer, comment);
                    declarations.add(Declaration.builder().setDeclService(srv).build());
                    comment = null;
                    continue block9;
                }
                case CONST: {
                    hasHeader = true;
                    hasDeclaration = true;
                    ThriftField cnst = this.parseConst(tokenizer, comment);
                    declarations.add(Declaration.builder().setDeclConst(cnst).build());
                    comment = null;
                    continue block9;
                }
            }
            throw new ParseException("Unexpected token '" + token.getToken() + "', expected type declaration", tokenizer, token);
        }
        doc.setNamespaces(namespaces);
        doc.setIncludes(includes);
        doc.setDecl(declarations);
        return doc.build();
    }

    private ThriftField parseConst(Tokenizer tokenizer, String comment) throws IOException, ParseException {
        Token token = tokenizer.expectQualifiedIdentifier("parsing const type");
        String type = this.parseType(tokenizer, token);
        Token id = tokenizer.expectIdentifier("parsing const identifier");
        tokenizer.expectSymbol(Symbol.MAP_ENTRY_VALUE_SEP, "parsing const identifier");
        String value = this.parseValue(tokenizer);
        Token sep = tokenizer.next();
        if (sep != null && sep.isSymbol()) {
            if (!sep.getSymbol().equals((Object)Symbol.LIST_SEPARATOR) && !sep.getSymbol().equals((Object)Symbol.ENTRY_SEPARATOR)) {
                tokenizer.unshift(sep);
            }
        } else {
            tokenizer.unshift(sep);
        }
        return ThriftField.builder().setComment(comment).setKey(-1).setName(id.getToken()).setType(type).setDefaultValue(value).build();
    }

    private String parseValue(Tokenizer tokenizer) throws IOException, ParseException {
        Stack<Symbol> enclosures = new Stack<Symbol>();
        StringBuilder builder = new StringBuilder();
        while (true) {
            Token token;
            if ((token = tokenizer.expect("Parsing const value.")).startsBlockComment()) {
                this.parseBlockComment(tokenizer);
                continue;
            }
            if (token.startsLineComment()) {
                this.parseLineComment(tokenizer, null);
                continue;
            }
            if (token.isSymbol()) {
                Symbol ct = token.getSymbol();
                if (ct.equals((Object)Symbol.SHELL_COMMENT)) {
                    this.parseLineComment(tokenizer, null);
                    continue;
                }
                if (ct.equals((Object)Symbol.MAP_START)) {
                    enclosures.push(Symbol.MAP_END);
                } else if (ct.equals((Object)Symbol.LIST_START)) {
                    enclosures.push(Symbol.LIST_END);
                } else if (enclosures.size() > 0 && ct.equals(enclosures.peek())) {
                    enclosures.pop();
                }
            }
            builder.append(token.getToken());
            if (enclosures.isEmpty()) break;
        }
        return builder.toString();
    }

    private String parseLineComment(Tokenizer tokenizer, String comment) throws IOException {
        String line = tokenizer.readUntil('\n').trim();
        if (comment != null) {
            return comment + "\n" + line;
        }
        return line;
    }

    private String parseBlockComment(Tokenizer tokenizer) throws IOException {
        String block = tokenizer.readUntil(Keyword.BLOCK_COMMENT_END.keyword).trim();
        String[] lines = block.split("\n");
        StringBuilder builder = new StringBuilder();
        Pattern re = RE_BLOCK_LINE;
        for (String line : lines) {
            builder.append(re.matcher(line).replaceFirst(""));
            builder.append('\n');
        }
        return builder.toString().trim();
    }

    private ServiceType parseService(Tokenizer tokenizer, String comment) throws IOException, ParseException {
        ServiceType._Builder service = ServiceType.builder();
        if (comment != null) {
            service.setComment(comment);
            comment = null;
        }
        Token identifier = tokenizer.expectIdentifier("parsing service identifier");
        service.setName(identifier.getToken());
        tokenizer.expectSymbol(Symbol.MAP_START, "reading service start");
        Token token = tokenizer.expect("reading service method");
        while (!token.isSymbol() || !token.getSymbol().equals((Object)Symbol.MAP_END)) {
            ThriftField._Builder field;
            if (token.startsLineComment()) {
                comment = this.parseLineComment(tokenizer, comment);
                continue;
            }
            if (token.startsBlockComment()) {
                comment = this.parseBlockComment(tokenizer);
                continue;
            }
            ServiceMethod._Builder method = ServiceMethod.builder();
            if (comment != null) {
                method.setComment(comment);
                comment = null;
            }
            if (token.getToken().equals(Keyword.ONEWAY.keyword)) {
                method.setOneWay(true);
                token = tokenizer.expect("reading service method");
            }
            if (!token.isQualifiedIdentifier()) {
                throw new ParseException(token.getToken() + " is not a valid type identifier.", tokenizer, token);
            }
            if (!token.getToken().equals(Keyword.VOID.keyword)) {
                method.setReturnType(token.getToken());
            }
            token = tokenizer.expectIdentifier("reading method name");
            method.setName(token.getToken());
            tokenizer.expectSymbol(Symbol.PARAMS_BEGIN, "reading method params begin");
            token = tokenizer.expect("reading method params");
            while (!token.isSymbol() || !token.getSymbol().equals((Object)Symbol.PARAMS_END)) {
                if (token.startsLineComment()) {
                    comment = this.parseLineComment(tokenizer, comment);
                    continue;
                }
                if (token.startsBlockComment()) {
                    comment = this.parseBlockComment(tokenizer);
                    continue;
                }
                field = ThriftField.builder();
                if (comment != null) {
                    field.setComment(comment);
                    comment = null;
                }
                if (token.isInteger()) {
                    field.setKey(token.intValue());
                    tokenizer.expectSymbol(Symbol.MAP_KEY_ENTRY_SEP, "reading method params (:)");
                    token = tokenizer.expect("reading method param type");
                }
                field.setType(this.parseType(tokenizer, token));
                token = tokenizer.expectIdentifier("reading method params");
                field.setName(token.getToken());
                method.addToParams(field.build());
                token = tokenizer.expect("reading method params");
                if (!token.isSymbol() || !token.getSymbol().equals((Object)Symbol.LIST_SEPARATOR) && !token.getSymbol().equals((Object)Symbol.ENTRY_SEPARATOR)) continue;
                token = tokenizer.expect("reading method params");
            }
            token = tokenizer.expect("reading method params");
            if (token.isSymbol() && (token.getSymbol().equals((Object)Symbol.LIST_SEPARATOR) || token.getSymbol().equals((Object)Symbol.ENTRY_SEPARATOR))) {
                service.addToMethods(method.build());
                token = tokenizer.expect("reading method params");
                continue;
            }
            if (token.getToken().equals(Keyword.THROWS.keyword)) {
                tokenizer.expectSymbol(Symbol.PARAMS_BEGIN, "reading method exception begin");
                token = tokenizer.expect("reading method exception begin");
                while (!token.isSymbol() || !token.getSymbol().equals((Object)Symbol.PARAMS_END)) {
                    if (token.startsLineComment()) {
                        comment = this.parseLineComment(tokenizer, comment);
                        continue;
                    }
                    if (token.startsBlockComment()) {
                        comment = this.parseBlockComment(tokenizer);
                        continue;
                    }
                    field = ThriftField.builder();
                    if (comment != null) {
                        field.setComment(comment);
                        comment = null;
                    }
                    if (token.isInteger()) {
                        field.setKey(token.intValue());
                        tokenizer.expectSymbol(Symbol.MAP_KEY_ENTRY_SEP, "reading method exception (:)");
                        token = tokenizer.expect("reading method exception type");
                    }
                    if (!token.isIdentifier()) {
                        throw new ParseException("Expected exception type identifier.", tokenizer, token);
                    }
                    field.setType(token.getToken());
                    token = tokenizer.expectIdentifier("reading method exception");
                    field.setName(token.getToken());
                    method.addToExceptions(field.build());
                    token = tokenizer.expect("reading method exception");
                    if (!token.isSymbol() || !token.getSymbol().equals((Object)Symbol.LIST_SEPARATOR) && !token.getSymbol().equals((Object)Symbol.ENTRY_SEPARATOR)) continue;
                    token = tokenizer.expect("reading method exception");
                }
            }
            service.addToMethods(method.build());
            token = tokenizer.expect("reading service method");
            if (!token.isSymbol() || !token.getSymbol().equals((Object)Symbol.LIST_SEPARATOR) && !token.getSymbol().equals((Object)Symbol.ENTRY_SEPARATOR)) continue;
            token = tokenizer.expect("reading service method");
        }
        return service.build();
    }

    public void parseNamespace(Tokenizer tokenizer, Map<String, String> namespaces) throws IOException, ParseException {
        Token language = tokenizer.expectQualifiedIdentifier("parsing namespace language");
        Token namespace = tokenizer.expectQualifiedIdentifier("parsing namespace");
        if (!language.isIdentifier()) {
            throw new ParseException("Namespace language not valid identifier: '" + language.getToken() + "'");
        }
        if (!namespace.isQualifiedIdentifier()) {
            throw new ParseException("Namespace not valid: '" + namespace.getToken() + "'");
        }
        namespaces.put(language.getToken(), namespace.getToken());
    }

    public void parseIncludes(Tokenizer tokenizer, List<String> includes) throws IOException, ParseException {
        Token include = tokenizer.next();
        if (include == null) {
            throw new ParseException("Unecpected end of file.");
        }
        if (!include.isLiteral()) {
            throw new ParseException("Expected string literal for include", tokenizer, include);
        }
        includes.add(include.literalValue());
    }

    private void parseTypedef(Tokenizer tokenizer, String comment, List<Declaration> declarations) throws IOException, ParseException {
        Token token = tokenizer.expect("parsing typedef type.");
        String type = this.parseType(tokenizer, token);
        Token id = tokenizer.expectIdentifier("parsing typedef identifier.");
        TypedefType typedef = TypedefType.builder().setComment(comment).setType(type).setName(id.getToken()).build();
        declarations.add(Declaration.builder().setDeclTypedef(typedef).build());
    }

    public EnumType parseEnum(Tokenizer tokenizer, String comment) throws IOException, ParseException {
        EnumType._Builder et;
        block11: {
            Token token;
            Token id = tokenizer.expectIdentifier("parsing enum identifier");
            et = EnumType.builder();
            if (comment != null) {
                et.setComment(comment);
                comment = null;
            }
            et.setName(id.getToken());
            int nextValue = 0;
            String nextName = null;
            while (true) {
                if ((token = tokenizer.expect("parsing enum " + id.getToken())).startsLineComment()) {
                    comment = this.parseLineComment(tokenizer, comment);
                    continue;
                }
                if (token.startsBlockComment()) {
                    comment = this.parseBlockComment(tokenizer);
                    continue;
                }
                if (token.isSymbol()) {
                    if (token.getSymbol().equals((Object)Symbol.MAP_END)) {
                        if (nextName != null) {
                            et.addToValues(EnumValue.builder().setComment(comment).setName(nextName).setValue(nextValue).build());
                        }
                        break block11;
                    }
                    if (token.getSymbol().equals((Object)Symbol.ENTRY_SEPARATOR) || token.getSymbol().equals((Object)Symbol.LIST_SEPARATOR)) {
                        if (nextName == null) {
                            throw new ParseException("Unexpected entry separator: '" + token.getToken() + "'", tokenizer, token);
                        }
                        et.addToValues(EnumValue.builder().setComment(comment).setName(nextName).setValue(nextValue).build());
                        comment = null;
                        nextName = null;
                        ++nextValue;
                        continue;
                    }
                    if (!token.getSymbol().equals((Object)Symbol.MAP_ENTRY_VALUE_SEP)) continue;
                    Token value = tokenizer.next();
                    if (!value.isInteger()) {
                        throw new ParseException("Expected numeric enum value, got " + value.getToken(), tokenizer, value);
                    }
                    nextValue = value.intValue();
                    continue;
                }
                if (!token.isIdentifier()) break;
                if (nextName != null) {
                    et.addToValues(EnumValue.builder().setComment(comment).setName(nextName).setValue(nextValue).build());
                    comment = null;
                    ++nextValue;
                }
                nextName = token.getToken();
            }
            throw new ParseException("Unexpected token in enum: " + token.getToken(), tokenizer, token);
        }
        return et.build();
    }

    private StructType parseStruct(Tokenizer tokenizer, String type, String comment) throws IOException, ParseException {
        Token id;
        StructType._Builder struct = StructType.builder();
        if (comment != null) {
            struct.setComment(comment);
            comment = null;
        }
        boolean union = type.equals("union");
        if (!type.equals("struct")) {
            struct.setVariant(StructVariant.valueOf(type.toUpperCase()));
        }
        if (!(id = tokenizer.expectIdentifier("parsing " + type + " identifier")).isIdentifier()) {
            throw new ParseException("Struct name " + id.getToken() + " is not valid identifier", tokenizer, id);
        }
        struct.setName(id.getToken());
        int nextDefaultKey = 65535;
        tokenizer.expectSymbol(Symbol.MAP_START, "parsing struct " + id.getToken());
        ThriftField._Builder field = ThriftField.builder();
        while (true) {
            Token token;
            if ((token = tokenizer.expect("parsing struct " + id.getToken())).startsLineComment()) {
                comment = this.parseLineComment(tokenizer, comment);
                continue;
            }
            if (token.startsBlockComment()) {
                comment = this.parseBlockComment(tokenizer);
                continue;
            }
            if (token.isSymbol() && token.getSymbol().equals((Object)Symbol.MAP_END)) break;
            field.setComment(comment);
            comment = null;
            if (token.isInteger()) {
                field.setKey(token.intValue());
                tokenizer.expectSymbol(Symbol.MAP_KEY_ENTRY_SEP, "parsing struct " + id.getToken());
                token = tokenizer.expect("parsing struct " + id.getToken());
            } else {
                field.setKey(nextDefaultKey--);
            }
            if (token.getToken().equals(Keyword.REQUIRED.keyword)) {
                if (union) {
                    throw new ParseException("Found required field in union. Not allowed. " + token.getToken(), tokenizer, token);
                }
                field.setRequirement(Requirement.REQUIRED);
                token = tokenizer.expect("parsing struct " + id.getToken());
            } else if (token.getToken().equals(Keyword.OPTIONAL.keyword)) {
                if (!union) {
                    field.setRequirement(Requirement.OPTIONAL);
                }
                token = tokenizer.expect("parsing struct " + id.getToken());
            }
            field.setType(this.parseType(tokenizer, token));
            token = tokenizer.expect("parsing struct " + id.getToken());
            if (!token.isIdentifier()) {
                throw new ParseException("Expected name identifier, but found " + token.getToken(), tokenizer, token);
            }
            field.setName(token.getToken());
            token = tokenizer.expect("parsing struct " + id.getToken());
            if (token.isSymbol() && token.getSymbol().equals((Object)Symbol.MAP_ENTRY_VALUE_SEP)) {
                field.setDefaultValue(this.parseValue(tokenizer));
                token = tokenizer.expect("parsing struct " + id.getToken());
            }
            if (token.isSymbol() && (token.getSymbol().equals((Object)Symbol.LIST_SEPARATOR) || token.getSymbol().equals((Object)Symbol.ENTRY_SEPARATOR))) {
                token = tokenizer.expect("parsing struct " + id.getToken());
            }
            struct.addToFields(field.build());
            field = ThriftField.builder();
            if (token.isSymbol() && token.getSymbol().equals((Object)Symbol.MAP_END)) break;
            tokenizer.unshift(token);
        }
        return struct.build();
    }

    public String parseType(Tokenizer tokenizer, Token token) throws IOException, ParseException {
        if (!token.isQualifiedIdentifier()) {
            throw new ParseException("Expected type identifier but found " + token, tokenizer, token);
        }
        String type = token.getToken();
        Keyword kw = Keyword.getByToken(type);
        if (kw == null) {
            return type;
        }
        if (kw.equals((Object)Keyword.LIST) || kw.equals((Object)Keyword.SET)) {
            tokenizer.expectSymbol(Symbol.GENERIC_START, "parsing " + (Object)((Object)kw) + " type");
            token = tokenizer.expect("parsing " + (Object)((Object)kw) + " type");
            String itemType = this.parseType(tokenizer, token);
            tokenizer.expectSymbol(Symbol.GENERIC_END, "parsing " + (Object)((Object)kw) + " type");
            return String.format("%s<%s>", type, itemType);
        }
        if (kw.equals((Object)Keyword.MAP)) {
            tokenizer.expectSymbol(Symbol.GENERIC_START, "parsing " + (Object)((Object)kw) + " type");
            token = tokenizer.expect("parsing " + (Object)((Object)kw) + " type");
            String keyType = this.parseType(tokenizer, token);
            tokenizer.expectSymbol(Symbol.LIST_SEPARATOR, "parsing " + (Object)((Object)kw) + " type");
            token = tokenizer.expect("parsing " + (Object)((Object)kw) + " type");
            String itemType = this.parseType(tokenizer, token);
            tokenizer.expectSymbol(Symbol.GENERIC_END, "parsing " + (Object)((Object)kw) + " type");
            return String.format("%s<%s,%s>", type, keyType, itemType);
        }
        return type;
    }
}

