/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.reflect.parser;

import java.io.IOException;
import net.morimekta.providence.reflect.parser.internal.Token;
import net.morimekta.providence.reflect.parser.internal.Tokenizer;

public class ParseException
extends Exception {
    private final String mLine;
    private final int mLineNo;
    private final int mPos;
    private final int mLen;

    public ParseException(String message, Throwable cause) {
        this(message, null, 0, 0, 0);
        this.initCause(cause);
    }

    public ParseException(String message) {
        this(message, null, 0, 0, 0);
    }

    public ParseException(String message, String line, int lineNo, int pos, int len) {
        super(message);
        this.mLine = line;
        this.mLineNo = lineNo;
        this.mPos = pos;
        this.mLen = len;
    }

    public ParseException(String message, Tokenizer tokenizer, Token token) throws IOException {
        super(message);
        this.mLine = tokenizer.getLine(token.getLine());
        this.mLineNo = token.getLine();
        this.mPos = token.getPos();
        this.mLen = token.getLen();
    }

    public String getLine() {
        return this.mLine;
    }

    public int getLineNo() {
        return this.mLineNo;
    }

    public int getPos() {
        return this.mPos;
    }

    public int getLen() {
        return this.mLen;
    }

    @Override
    public String toString() {
        if (this.mLine != null) {
            return String.format("ParseException(%s,%d:%d,\"%s\")", this.getLocalizedMessage(), this.getLineNo(), this.getPos(), this.getLine());
        }
        return String.format("ParseException(%s)", this.getLocalizedMessage());
    }
}

