/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.reflect.contained;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.PMessageBuilderFactory;
import net.morimekta.providence.descriptor.PUnionDescriptor;
import net.morimekta.providence.reflect.contained.CField;
import net.morimekta.providence.reflect.contained.CUnion;

public class CUnionDescriptor
extends PUnionDescriptor<CUnion, CField> {
    private final CField[] mFields;
    private final Map<Integer, CField> mFieldIdMap;
    private final Map<String, CField> mFieldNameMap;

    public CUnionDescriptor(String comment, String packageName, String name, List<CField> fields) {
        super(comment, packageName, name, (PMessageBuilderFactory)new _Factory(), false);
        ((_Factory)this.factory()).setType(this);
        this.mFields = fields.toArray(new CField[fields.size()]);
        LinkedHashMap<Integer, CField> fieldIdMap = new LinkedHashMap<Integer, CField>();
        LinkedHashMap<String, CField> fieldNameMap = new LinkedHashMap<String, CField>();
        for (CField field : fields) {
            fieldIdMap.put(field.getKey(), field);
            fieldNameMap.put(field.getName(), field);
        }
        this.mFieldIdMap = fieldIdMap;
        this.mFieldNameMap = fieldNameMap;
    }

    public CField[] getFields() {
        return this.mFields;
    }

    public CField getField(String name) {
        return this.mFieldNameMap.get(name);
    }

    public CField getField(int key) {
        return this.mFieldIdMap.get(key);
    }

    public boolean isSimple() {
        for (CField field : this.getFields()) {
            switch (field.getType()) {
                case MAP: 
                case SET: 
                case LIST: 
                case MESSAGE: {
                    return false;
                }
            }
        }
        return true;
    }

    private static class _Factory
    extends PMessageBuilderFactory<CUnion> {
        private CUnionDescriptor mType;

        private _Factory() {
        }

        public void setType(CUnionDescriptor type) {
            this.mType = type;
        }

        public PMessageBuilder<CUnion> builder() {
            return new CUnion.Builder(this.mType);
        }
    }
}

