/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.reflect.contained;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.PType;
import net.morimekta.providence.reflect.contained.CField;
import net.morimekta.providence.reflect.contained.CMessage;
import net.morimekta.providence.reflect.contained.CUnionDescriptor;

public class CUnion
extends CMessage<CUnion> {
    private final CUnionDescriptor mType;

    protected CUnion(Builder builder) {
        super(Collections.unmodifiableMap(new LinkedHashMap(builder.mFields)));
        this.mType = builder.mType;
    }

    public PMessageBuilder<CUnion> mutate() {
        return new Builder(this.mType);
    }

    public CUnionDescriptor descriptor() {
        return this.mType;
    }

    public static class Builder
    extends PMessageBuilder<CUnion> {
        private final CUnionDescriptor mType;
        private final Map<Integer, Object> mFields;

        public Builder(CUnionDescriptor type) {
            this.mType = type;
            this.mFields = new TreeMap<Integer, Object>();
        }

        public CUnion build() {
            return new CUnion(this);
        }

        public boolean isValid() {
            return this.mFields.size() == 1;
        }

        public Builder set(int key, Object value) {
            CField field = this.mType.getField(key);
            if (field == null) {
                return this;
            }
            this.mFields.clear();
            if (value != null) {
                this.mFields.put(field.getKey(), value);
            }
            return this;
        }

        public Builder addTo(int key, Object value) {
            CField field = this.mType.getField(key);
            if (field == null) {
                return this;
            }
            if (value != null) {
                if (field.getType() == PType.LIST) {
                    LinkedList<Object> list = (LinkedList<Object>)this.mFields.get(field.getKey());
                    if (list == null) {
                        list = new LinkedList<Object>();
                        this.mFields.put(field.getKey(), list);
                    }
                    list.add(value);
                } else if (field.getType() == PType.SET) {
                    HashSet<Object> set = (HashSet<Object>)this.mFields.get(field.getKey());
                    if (set == null) {
                        set = new HashSet<Object>();
                        this.mFields.put(field.getKey(), set);
                    }
                    set.add(value);
                }
            }
            return this;
        }

        public Builder clear(int key) {
            this.mFields.remove(key);
            return this;
        }
    }
}

