/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.reflect.contained;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.PMessageBuilderFactory;
import net.morimekta.providence.descriptor.PRequirement;
import net.morimekta.providence.descriptor.PStructDescriptor;
import net.morimekta.providence.reflect.contained.CField;
import net.morimekta.providence.reflect.contained.CStruct;

public class CStructDescriptor
extends PStructDescriptor<CStruct, CField> {
    public static final Pattern COMPACT_RE = Pattern.compile("^[@][Cc]ompact$", 8);
    public static final int MAX_COMPACT_FIELDS = 5;
    private final CField[] mFields;
    private final Map<Integer, CField> mFieldIdMap;
    private final Map<String, CField> mFieldNameMap;

    public CStructDescriptor(String comment, String packageName, String name, List<CField> fields) {
        super(comment, packageName, name, (PMessageBuilderFactory)new _Factory(), false, CStructDescriptor.isCompactCompatible(comment, fields));
        ((_Factory)this.factory()).setType(this);
        this.mFields = fields.toArray(new CField[fields.size()]);
        LinkedHashMap<Integer, CField> fieldIdMap = new LinkedHashMap<Integer, CField>();
        LinkedHashMap<String, CField> fieldNameMap = new LinkedHashMap<String, CField>();
        for (CField field : fields) {
            fieldIdMap.put(field.getKey(), field);
            fieldNameMap.put(field.getName(), field);
        }
        this.mFieldIdMap = fieldIdMap;
        this.mFieldNameMap = fieldNameMap;
    }

    public CField[] getFields() {
        return this.mFields;
    }

    public CField getField(String name) {
        return this.mFieldNameMap.get(name);
    }

    public CField getField(int key) {
        return this.mFieldIdMap.get(key);
    }

    public boolean isSimple() {
        for (CField field : this.getFields()) {
            switch (field.getType()) {
                case MAP: 
                case SET: 
                case LIST: 
                case MESSAGE: {
                    return false;
                }
            }
        }
        return true;
    }

    private static boolean isCompactCompatible(String comment, List<CField> fields) {
        if (comment == null) {
            return false;
        }
        if (!COMPACT_RE.matcher(comment).find()) {
            return false;
        }
        if (fields.size() > 5) {
            return false;
        }
        int next = 1;
        boolean hasOptional = false;
        for (CField field : fields) {
            if (field.getKey() != next) {
                return false;
            }
            if (hasOptional && field.getRequirement() == PRequirement.REQUIRED) {
                return false;
            }
            if (field.getRequirement() == PRequirement.OPTIONAL) {
                hasOptional = true;
            }
            ++next;
        }
        return true;
    }

    private static class _Factory
    extends PMessageBuilderFactory<CStruct> {
        private CStructDescriptor mType;

        private _Factory() {
        }

        public void setType(CStructDescriptor type) {
            this.mType = type;
        }

        public PMessageBuilder<CStruct> builder() {
            return new CStruct.Builder(this.mType);
        }
    }
}

