/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.reflect.contained;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.PType;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PRequirement;
import net.morimekta.providence.descriptor.PStructDescriptor;
import net.morimekta.providence.reflect.contained.CField;
import net.morimekta.providence.reflect.contained.CMessage;

public class CStruct
extends CMessage<CStruct> {
    PStructDescriptor<CStruct, CField> mType;

    protected CStruct(Builder builder) {
        super(Collections.unmodifiableMap(new LinkedHashMap(builder.mFields)));
        this.mType = builder.mType;
    }

    public PMessageBuilder<CStruct> mutate() {
        return new Builder(this.mType);
    }

    public PStructDescriptor<CStruct, CField> descriptor() {
        return this.mType;
    }

    public static class Builder
    extends PMessageBuilder<CStruct> {
        private final PStructDescriptor<CStruct, CField> mType;
        private final Map<Integer, Object> mFields;

        public Builder(PStructDescriptor<CStruct, CField> type) {
            this.mType = type;
            this.mFields = new TreeMap<Integer, Object>();
        }

        public CStruct build() {
            return new CStruct(this);
        }

        public boolean isValid() {
            for (CField field : (CField[])this.mType.getFields()) {
                if (field.getRequirement() != PRequirement.REQUIRED || this.mFields.containsKey(field.getKey())) continue;
                return false;
            }
            return true;
        }

        public Builder set(int key, Object value) {
            PField field = this.mType.getField(key);
            if (field == null) {
                return this;
            }
            if (value != null) {
                this.mFields.put(field.getKey(), value);
            }
            return this;
        }

        public Builder addTo(int key, Object value) {
            PField field = this.mType.getField(key);
            if (field == null) {
                return this;
            }
            if (value != null) {
                if (field.getType() == PType.LIST) {
                    LinkedList<Object> list = (LinkedList<Object>)this.mFields.get(field.getKey());
                    if (list == null) {
                        list = new LinkedList<Object>();
                        this.mFields.put(field.getKey(), list);
                    }
                    list.add(value);
                } else if (field.getType() == PType.SET) {
                    HashSet<Object> set = (HashSet<Object>)this.mFields.get(field.getKey());
                    if (set == null) {
                        set = new HashSet<Object>();
                        this.mFields.put(field.getKey(), set);
                    }
                    set.add(value);
                }
            }
            return this;
        }

        public Builder clear(int key) {
            this.mFields.remove(key);
            return this;
        }
    }
}

