/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.reflect.contained;

import java.util.Objects;
import net.morimekta.providence.PType;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PDescriptorProvider;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PRequirement;
import net.morimekta.providence.descriptor.PValueProvider;
import net.morimekta.providence.util.PTypeUtils;

public class CField<T>
implements PField<T> {
    private final String mComment;
    private final int mKey;
    private final PRequirement mRequirement;
    private final PDescriptorProvider<T> mTypeProvider;
    private final String mName;
    private final PValueProvider<T> mDefaultValue;

    public CField(String comment, int key, PRequirement requirement, String name, PDescriptorProvider<T> typeProvider, PValueProvider<T> defaultValue) {
        this.mComment = comment;
        this.mKey = key;
        this.mRequirement = requirement;
        this.mTypeProvider = typeProvider;
        this.mName = name;
        this.mDefaultValue = defaultValue;
    }

    public String getComment() {
        return this.mComment;
    }

    public int getKey() {
        return this.mKey;
    }

    public PRequirement getRequirement() {
        return this.mRequirement;
    }

    public PType getType() {
        return this.mTypeProvider.descriptor().getType();
    }

    public PDescriptor<T> getDescriptor() {
        return this.mTypeProvider.descriptor();
    }

    public String getName() {
        return this.mName;
    }

    public boolean hasDefaultValue() {
        return this.mDefaultValue != null;
    }

    public T getDefaultValue() {
        return (T)(this.hasDefaultValue() ? this.mDefaultValue.get() : null);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(PField.class.getSimpleName()).append('{').append(this.mKey).append(": ");
        if (this.mRequirement != PRequirement.DEFAULT) {
            builder.append(this.mRequirement.label).append(" ");
        }
        builder.append(this.getDescriptor().getQualifiedName(null)).append(" ").append(this.mName).append("}");
        return builder.toString();
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof CField)) {
            return false;
        }
        CField other = (CField)o;
        return this.mKey == other.mKey && this.mRequirement == other.mRequirement && PTypeUtils.equalsQualifiedName(this.getDescriptor(), other.getDescriptor()) && this.mName.equals(other.mName) && PTypeUtils.equals(this.mDefaultValue, other.mDefaultValue);
    }

    public int hashCode() {
        return Objects.hash(CField.class, this.mKey, this.mRequirement, this.mName, this.getDefaultValue());
    }
}

