/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.reflect.contained;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.PType;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PPrimitive;
import net.morimekta.providence.reflect.contained.CExceptionDescriptor;
import net.morimekta.providence.reflect.contained.CField;
import net.morimekta.providence.util.PPrettyPrinter;
import net.morimekta.providence.util.PTypeUtils;

public class CException
extends Throwable
implements PMessage<CException> {
    private final CExceptionDescriptor mType;
    private final Map<Integer, Object> mFields;

    protected CException(Builder builder) {
        this.mFields = Collections.unmodifiableMap(new LinkedHashMap(builder.mFields));
        this.mType = builder.mType;
    }

    public boolean has(int key) {
        CField field = this.descriptor().getField(key);
        if (field == null) {
            return false;
        }
        switch (field.getDescriptor().getType()) {
            case MAP: 
            case LIST: 
            case SET: {
                return this.num(key) > 0;
            }
        }
        return this.mFields.containsKey(key);
    }

    public int num(int key) {
        CField field = this.descriptor().getField(key);
        if (field == null) {
            return 0;
        }
        switch (field.getDescriptor().getType()) {
            case MAP: {
                Map value = (Map)this.mFields.get(key);
                return value == null ? 0 : value.size();
            }
            case LIST: 
            case SET: {
                Collection collection = (Collection)this.mFields.get(key);
                return collection == null ? 0 : collection.size();
            }
        }
        return this.mFields.containsKey(key) ? 1 : 0;
    }

    public Object get(int key) {
        CField field = this.descriptor().getField(key);
        if (field != null) {
            Object value = this.mFields.get(key);
            if (value != null) {
                return value;
            }
            if (field.hasDefaultValue()) {
                return field.getDefaultValue();
            }
            if (field.getDescriptor() instanceof PPrimitive) {
                return ((PPrimitive)field.getDescriptor()).getDefaultValue();
            }
        }
        return null;
    }

    public boolean isCompact() {
        if (!this.descriptor().isCompactible()) {
            return false;
        }
        boolean missing = false;
        for (CField field : this.descriptor().getFields()) {
            if (this.has(field.getKey())) {
                if (!missing) continue;
                return false;
            }
            missing = true;
        }
        return true;
    }

    public boolean isSimple() {
        return this.descriptor().isSimple();
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof CException)) {
            return false;
        }
        CException other = (CException)o;
        CExceptionDescriptor type = other.descriptor();
        if (!this.descriptor().getQualifiedName(null).equals(type.getQualifiedName(null)) || !this.descriptor().getVariant().equals((Object)type.getVariant())) {
            return false;
        }
        for (CField field : this.descriptor().getFields()) {
            int id = field.getKey();
            if (this.has(id) != other.has(id)) {
                return false;
            }
            if (!PTypeUtils.equals((Object)this.get(id), (Object)other.get(id))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        for (Map.Entry<Integer, Object> entry : this.mFields.entrySet()) {
            CField field = this.descriptor().getField(entry.getKey());
            hash += PTypeUtils.hashCode((PField)field, (Object)entry.getValue());
        }
        return hash;
    }

    public int compareTo(CException other) {
        return PTypeUtils.compare((Comparable)((Object)this), (Comparable)((Object)other));
    }

    @Override
    public String toString() {
        return this.descriptor().getQualifiedName(null) + this.asString();
    }

    public String asString() {
        return new PPrettyPrinter("", "", "").format((PMessage)this);
    }

    public PMessageBuilder<CException> mutate() {
        return new Builder(this.mType);
    }

    public CExceptionDescriptor descriptor() {
        return this.mType;
    }

    public static class Builder
    extends PMessageBuilder<CException> {
        private final CExceptionDescriptor mType;
        private final Map<Integer, Object> mFields;

        public Builder(CExceptionDescriptor type) {
            this.mType = type;
            this.mFields = new TreeMap<Integer, Object>();
        }

        public CException build() {
            return new CException(this);
        }

        public boolean isValid() {
            return this.mFields.size() == 1;
        }

        public Builder set(int key, Object value) {
            CField field = this.mType.getField(key);
            if (field == null) {
                return this;
            }
            if (value != null) {
                this.mFields.put(field.getKey(), value);
            }
            return this;
        }

        public Builder addTo(int key, Object value) {
            CField field = this.mType.getField(key);
            if (field == null) {
                return this;
            }
            if (value != null) {
                if (field.getType() == PType.LIST) {
                    LinkedList<Object> list = (LinkedList<Object>)this.mFields.get(field.getKey());
                    if (list == null) {
                        list = new LinkedList<Object>();
                        this.mFields.put(field.getKey(), list);
                    }
                    list.add(value);
                } else if (field.getType() == PType.SET) {
                    HashSet<Object> set = (HashSet<Object>)this.mFields.get(field.getKey());
                    if (set == null) {
                        set = new HashSet<Object>();
                        this.mFields.put(field.getKey(), set);
                    }
                    set.add(value);
                }
            }
            return this;
        }

        public Builder clear(int key) {
            this.mFields.remove(key);
            return this;
        }
    }
}

