/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.reflect.contained;

import net.morimekta.providence.PEnumBuilder;
import net.morimekta.providence.PEnumValue;
import net.morimekta.providence.descriptor.PEnumDescriptor;
import net.morimekta.providence.reflect.contained.CEnumDescriptor;

public class CEnum
implements PEnumValue<CEnum> {
    private final int mValue;
    private final String mName;
    private final PEnumDescriptor<CEnum> mType;
    private final String mComment;

    public CEnum(String comment, int value, String name, PEnumDescriptor<CEnum> type) {
        this.mComment = comment;
        this.mValue = value;
        this.mName = name;
        this.mType = type;
    }

    public String getComment() {
        return this.mComment;
    }

    public int getValue() {
        return this.mValue;
    }

    public String getName() {
        return this.mName;
    }

    public PEnumDescriptor<CEnum> descriptor() {
        return this.mType;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof CEnum)) {
            return false;
        }
        CEnum other = (CEnum)o;
        return other.descriptor().getQualifiedName(null).equals(this.mType.getQualifiedName(null)) && other.getName().equals(this.mName) && other.getValue() == this.mValue;
    }

    public int compareTo(CEnum other) {
        return Integer.compare(this.mValue, other.mValue);
    }

    public String toString() {
        return this.mName.toUpperCase();
    }

    public static class Builder
    extends PEnumBuilder<CEnum> {
        private final CEnumDescriptor mType;
        private CEnum mValue = null;

        public Builder(CEnumDescriptor type) {
            this.mType = type;
        }

        public CEnum build() {
            return this.mValue;
        }

        public boolean isValid() {
            return this.mValue != null;
        }

        public Builder setByValue(int id) {
            this.mValue = this.mType.getValueById(id);
            return this;
        }

        public Builder setByName(String name) {
            this.mValue = this.mType.getValueByName(name);
            return this;
        }
    }
}

