/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.model;

import java.io.Serializable;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.PMessageBuilderFactory;
import net.morimekta.providence.PType;
import net.morimekta.providence.descriptor.PDefaultValueProvider;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PDescriptorProvider;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PList;
import net.morimekta.providence.descriptor.PPrimitive;
import net.morimekta.providence.descriptor.PRequirement;
import net.morimekta.providence.descriptor.PStructDescriptor;
import net.morimekta.providence.descriptor.PStructDescriptorProvider;
import net.morimekta.providence.descriptor.PValueProvider;
import net.morimekta.providence.model.StructVariant;
import net.morimekta.providence.model.ThriftField;
import net.morimekta.providence.util.PTypeUtils;

public class StructType
implements PMessage<StructType>,
Serializable,
Comparable<StructType> {
    private static final long serialVersionUID = -7531050363059752370L;
    private static final StructVariant kDefaultVariant = StructVariant.STRUCT;
    private final String mComment;
    private final StructVariant mVariant;
    private final String mName;
    private final List<ThriftField> mFields;
    private volatile int tHashCode;
    public static final PStructDescriptor<StructType, _Field> kDescriptor = new _Descriptor();

    private StructType(_Builder builder) {
        this.mComment = builder.mComment;
        this.mVariant = builder.mVariant;
        this.mName = builder.mName;
        this.mFields = Collections.unmodifiableList(new LinkedList(builder.mFields));
    }

    public StructType(String pComment, StructVariant pVariant, String pName, List<ThriftField> pFields) {
        this.mComment = pComment;
        this.mVariant = pVariant;
        this.mName = pName;
        this.mFields = Collections.unmodifiableList(new LinkedList<ThriftField>(pFields));
    }

    public boolean hasComment() {
        return this.mComment != null;
    }

    public String getComment() {
        return this.mComment;
    }

    public boolean hasVariant() {
        return this.mVariant != null;
    }

    public StructVariant getVariant() {
        return this.hasVariant() ? this.mVariant : kDefaultVariant;
    }

    public boolean hasName() {
        return this.mName != null;
    }

    public String getName() {
        return this.mName;
    }

    public int numFields() {
        return this.mFields != null ? this.mFields.size() : 0;
    }

    public List<ThriftField> getFields() {
        return this.mFields;
    }

    public boolean has(int key) {
        switch (key) {
            case 1: {
                return this.hasComment();
            }
            case 2: {
                return this.hasVariant();
            }
            case 3: {
                return this.hasName();
            }
            case 4: {
                return this.numFields() > 0;
            }
        }
        return false;
    }

    public int num(int key) {
        switch (key) {
            case 1: {
                return this.hasComment() ? 1 : 0;
            }
            case 2: {
                return this.hasVariant() ? 1 : 0;
            }
            case 3: {
                return this.hasName() ? 1 : 0;
            }
            case 4: {
                return this.numFields();
            }
        }
        return 0;
    }

    public Object get(int key) {
        switch (key) {
            case 1: {
                return this.getComment();
            }
            case 2: {
                return this.getVariant();
            }
            case 3: {
                return this.getName();
            }
            case 4: {
                return this.getFields();
            }
        }
        return null;
    }

    public boolean isCompact() {
        return false;
    }

    public boolean isSimple() {
        return this.descriptor().isSimple();
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof StructType)) {
            return false;
        }
        StructType other = (StructType)o;
        return Objects.equals(this.mComment, other.mComment) && Objects.equals((Object)this.mVariant, (Object)other.mVariant) && Objects.equals(this.mName, other.mName) && PTypeUtils.equals(this.mFields, other.mFields);
    }

    public int hashCode() {
        if (this.tHashCode == 0) {
            this.tHashCode = Objects.hash(new Object[]{StructType.class, _Field.COMMENT, this.mComment, _Field.VARIANT, this.mVariant, _Field.NAME, this.mName, _Field.FIELDS, PTypeUtils.hashCode(this.mFields)});
        }
        return this.tHashCode;
    }

    public String toString() {
        return "model.StructType" + this.asString();
    }

    public String asString() {
        StringBuilder out = new StringBuilder();
        out.append("{");
        boolean first = true;
        if (this.hasComment()) {
            first = false;
            out.append("comment:");
            out.append('\"').append(this.mComment).append('\"');
        }
        if (this.hasVariant()) {
            if (!first) {
                out.append(',');
            }
            first = false;
            out.append("variant:");
            out.append(this.mVariant.getName());
        }
        if (this.hasName()) {
            if (!first) {
                out.append(',');
            }
            first = false;
            out.append("name:");
            out.append('\"').append(this.mName).append('\"');
        }
        if (this.numFields() > 0) {
            if (!first) {
                out.append(',');
            }
            first = false;
            out.append("fields:");
            out.append(PTypeUtils.toString(this.mFields));
        }
        out.append('}');
        return out.toString();
    }

    @Override
    public int compareTo(StructType other) {
        int c = Boolean.compare(this.mComment != null, other.mComment != null);
        if (c != 0) {
            return c;
        }
        if (this.mComment != null && (c = this.mComment.compareTo(other.mComment)) != 0) {
            return c;
        }
        c = Boolean.compare(this.mVariant != null, other.mVariant != null);
        if (c != 0) {
            return c;
        }
        if (this.mVariant != null && (c = Integer.compare(this.mVariant.getValue(), this.mVariant.getValue())) != 0) {
            return c;
        }
        c = Boolean.compare(this.mName != null, other.mName != null);
        if (c != 0) {
            return c;
        }
        if (this.mName != null && (c = this.mName.compareTo(other.mName)) != 0) {
            return c;
        }
        c = Boolean.compare(this.mFields != null, other.mFields != null);
        if (c != 0) {
            return c;
        }
        if (this.mFields != null && (c = Integer.compare(this.mFields.hashCode(), other.mFields.hashCode())) != 0) {
            return c;
        }
        return 0;
    }

    public static PStructDescriptorProvider<StructType, _Field> provider() {
        return new _Provider();
    }

    public PStructDescriptor<StructType, _Field> descriptor() {
        return kDescriptor;
    }

    public _Builder mutate() {
        return new _Builder(this);
    }

    public static _Builder builder() {
        return new _Builder();
    }

    static /* synthetic */ StructVariant access$400() {
        return kDefaultVariant;
    }

    public static class _Builder
    extends PMessageBuilder<StructType> {
        private BitSet optionals = new BitSet(4);
        private String mComment;
        private StructVariant mVariant;
        private String mName;
        private List<ThriftField> mFields = new LinkedList<ThriftField>();

        public _Builder() {
        }

        public _Builder(StructType base) {
            this();
            if (base.hasComment()) {
                this.optionals.set(0);
                this.mComment = base.mComment;
            }
            if (base.hasVariant()) {
                this.optionals.set(1);
                this.mVariant = base.mVariant;
            }
            if (base.hasName()) {
                this.optionals.set(2);
                this.mName = base.mName;
            }
            if (base.numFields() > 0) {
                this.optionals.set(3);
                this.mFields.addAll(base.mFields);
            }
        }

        public _Builder setComment(String value) {
            this.optionals.set(0);
            this.mComment = value;
            return this;
        }

        public _Builder clearComment() {
            this.optionals.set(0, false);
            this.mComment = null;
            return this;
        }

        public _Builder setVariant(StructVariant value) {
            this.optionals.set(1);
            this.mVariant = value;
            return this;
        }

        public _Builder clearVariant() {
            this.optionals.set(1, false);
            this.mVariant = null;
            return this;
        }

        public _Builder setName(String value) {
            this.optionals.set(2);
            this.mName = value;
            return this;
        }

        public _Builder clearName() {
            this.optionals.set(2, false);
            this.mName = null;
            return this;
        }

        public _Builder setFields(Collection<ThriftField> value) {
            this.optionals.set(3);
            this.mFields.clear();
            this.mFields.addAll(value);
            return this;
        }

        public _Builder addToFields(ThriftField ... values) {
            this.optionals.set(3);
            for (ThriftField item : values) {
                this.mFields.add(item);
            }
            return this;
        }

        public _Builder clearFields() {
            this.optionals.set(3, false);
            this.mFields.clear();
            return this;
        }

        public _Builder set(int key, Object value) {
            if (value == null) {
                return this.clear(key);
            }
            switch (key) {
                case 1: {
                    this.setComment((String)value);
                    break;
                }
                case 2: {
                    this.setVariant((StructVariant)((Object)value));
                    break;
                }
                case 3: {
                    this.setName((String)value);
                    break;
                }
                case 4: {
                    this.setFields((List)value);
                }
            }
            return this;
        }

        public _Builder addTo(int key, Object value) {
            switch (key) {
                case 4: {
                    this.addToFields((ThriftField)value);
                    break;
                }
            }
            return this;
        }

        public _Builder clear(int key) {
            switch (key) {
                case 1: {
                    this.clearComment();
                    break;
                }
                case 2: {
                    this.clearVariant();
                    break;
                }
                case 3: {
                    this.clearName();
                    break;
                }
                case 4: {
                    this.clearFields();
                }
            }
            return this;
        }

        public boolean isValid() {
            return this.optionals.get(2);
        }

        public StructType build() {
            return new StructType(this);
        }
    }

    private static final class _Factory
    extends PMessageBuilderFactory<StructType> {
        private _Factory() {
        }

        public _Builder builder() {
            return new _Builder();
        }
    }

    private static final class _Provider
    extends PStructDescriptorProvider<StructType, _Field> {
        private _Provider() {
        }

        public PStructDescriptor<StructType, _Field> descriptor() {
            return kDescriptor;
        }
    }

    private static class _Descriptor
    extends PStructDescriptor<StructType, _Field> {
        public _Descriptor() {
            super(null, "model", "StructType", (PMessageBuilderFactory)new _Factory(), false, false);
        }

        public _Field[] getFields() {
            return _Field.values();
        }

        public _Field getField(String name) {
            return _Field.forName(name);
        }

        public _Field getField(int key) {
            return _Field.forKey(key);
        }
    }

    public static enum _Field implements PField
    {
        COMMENT(1, PRequirement.DEFAULT, "comment", (PDescriptorProvider<?>)PPrimitive.STRING.provider(), null),
        VARIANT(2, PRequirement.DEFAULT, "variant", (PDescriptorProvider<?>)StructVariant.provider(), (PValueProvider<?>)new PDefaultValueProvider((Object)((Object)StructType.access$400()))),
        NAME(3, PRequirement.REQUIRED, "name", (PDescriptorProvider<?>)PPrimitive.STRING.provider(), null),
        FIELDS(4, PRequirement.DEFAULT, "fields", (PDescriptorProvider<?>)PList.provider(ThriftField.provider()), null);

        private final int mKey;
        private final PRequirement mRequired;
        private final String mName;
        private final PDescriptorProvider<?> mTypeProvider;
        private final PValueProvider<?> mDefaultValue;

        private _Field(int key, PRequirement required, String name, PDescriptorProvider<?> typeProvider, PValueProvider<?> defaultValue) {
            this.mKey = key;
            this.mRequired = required;
            this.mName = name;
            this.mTypeProvider = typeProvider;
            this.mDefaultValue = defaultValue;
        }

        public String getComment() {
            return null;
        }

        public int getKey() {
            return this.mKey;
        }

        public PRequirement getRequirement() {
            return this.mRequired;
        }

        public PType getType() {
            return this.getDescriptor().getType();
        }

        public PDescriptor<?> getDescriptor() {
            return this.mTypeProvider.descriptor();
        }

        public String getName() {
            return this.mName;
        }

        public boolean hasDefaultValue() {
            return this.mDefaultValue != null;
        }

        public Object getDefaultValue() {
            return this.hasDefaultValue() ? this.mDefaultValue.get() : null;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("StructType._Field(").append(this.mKey).append(": ");
            if (this.mRequired != PRequirement.DEFAULT) {
                builder.append(this.mRequired.label).append(" ");
            }
            builder.append(this.getDescriptor().getQualifiedName(null)).append(' ').append(this.mName).append(')');
            return builder.toString();
        }

        public static _Field forKey(int key) {
            switch (key) {
                case 1: {
                    return COMMENT;
                }
                case 2: {
                    return VARIANT;
                }
                case 3: {
                    return NAME;
                }
                case 4: {
                    return FIELDS;
                }
            }
            return null;
        }

        public static _Field forName(String name) {
            switch (name) {
                case "comment": {
                    return COMMENT;
                }
                case "variant": {
                    return VARIANT;
                }
                case "name": {
                    return NAME;
                }
                case "fields": {
                    return FIELDS;
                }
            }
            return null;
        }
    }
}

