/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.logging.rolling;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.morimekta.providence.logging.RollingFileMessageWriter;

public class KeepLastNCleanupPolicy
implements RollingFileMessageWriter.CleanupPolicy {
    private final int keepLastN;
    private final Pattern filePattern;

    public KeepLastNCleanupPolicy(int keepLastN, String filePattern) {
        this(keepLastN, Pattern.compile(filePattern));
    }

    public KeepLastNCleanupPolicy(int keepLastN, Pattern filePattern) {
        this.keepLastN = keepLastN;
        this.filePattern = filePattern;
    }

    @Override
    @Nonnull
    public List<String> getFilesToDelete(@Nonnull List<String> candidateFiles, @Nonnull String currentFileName) {
        int remove;
        ArrayList<String> out = new ArrayList<String>();
        List candidatesBeforeFiles = candidateFiles.stream().filter(f -> this.filePattern.matcher((CharSequence)f).matches()).filter(f -> f.compareTo(currentFileName) < 0).sorted().collect(Collectors.toList());
        List candidatesAfterFiles = candidateFiles.stream().filter(f -> this.filePattern.matcher((CharSequence)f).matches()).filter(f -> f.compareTo(currentFileName) > 0).sorted().collect(Collectors.toList());
        if (candidatesAfterFiles.size() > 0 && candidatesAfterFiles.size() + candidatesBeforeFiles.size() >= this.keepLastN) {
            remove = candidatesBeforeFiles.size() + candidatesAfterFiles.size() - this.keepLastN + 1;
            out.addAll(candidatesAfterFiles.stream().limit(remove).collect(Collectors.toList()));
        }
        if (candidatesBeforeFiles.size() >= this.keepLastN) {
            remove = candidatesBeforeFiles.size() - this.keepLastN + 1;
            out.addAll(candidatesBeforeFiles.subList(0, remove));
        }
        return out;
    }
}

