/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.logging;

import java.io.IOException;
import java.io.OutputStream;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageOrBuilder;
import net.morimekta.providence.PServiceCall;
import net.morimekta.providence.logging.MessageWriter;
import net.morimekta.providence.serializer.Serializer;

public class IOMessageWriter
implements MessageWriter {
    private final OutputStream out;
    private final Serializer serializer;

    public IOMessageWriter(OutputStream out, Serializer serializer) {
        this.out = out;
        this.serializer = serializer;
    }

    @Override
    public <Message extends PMessage<Message>> int write(PMessageOrBuilder<Message> message) throws IOException {
        return this.serializer.serialize(this.out, message);
    }

    @Override
    public <Message extends PMessage<Message>> int write(PServiceCall<Message> call) throws IOException {
        return this.serializer.serialize(this.out, call);
    }

    @Override
    public int separator() throws IOException {
        if (!this.serializer.binaryProtocol()) {
            this.out.write(10);
            this.out.flush();
            return 1;
        }
        this.out.flush();
        return 0;
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }
}

