/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.logging;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PServiceCall;
import net.morimekta.providence.descriptor.PMessageDescriptor;
import net.morimekta.providence.descriptor.PService;
import net.morimekta.providence.logging.MessageReader;
import net.morimekta.providence.serializer.Serializer;

public class FileMessageReader
implements MessageReader {
    private final File file;
    private final Serializer serializer;
    private InputStream in;

    public FileMessageReader(File file, Serializer serializer) {
        this.file = file;
        this.serializer = serializer;
    }

    @Override
    public <Message extends PMessage<Message>> Message read(PMessageDescriptor<Message> descriptor) throws IOException {
        return (Message)this.serializer.deserialize(this.getInputStream(), descriptor);
    }

    @Override
    public <Message extends PMessage<Message>> PServiceCall<Message> read(PService service) throws IOException {
        return this.serializer.deserialize(this.getInputStream(), service);
    }

    @Override
    public void verifyEndOfContent() throws IOException {
        if (this.in != null) {
            try {
                this.serializer.verifyEndOfContent(this.in);
            }
            finally {
                this.in = null;
            }
        }
    }

    @Override
    public void close() throws IOException {
        if (this.in != null) {
            try {
                this.in.close();
            }
            finally {
                this.in = null;
            }
        }
    }

    private InputStream getInputStream() throws FileNotFoundException {
        if (this.in == null) {
            this.in = new BufferedInputStream(new FileInputStream(this.file));
        }
        return this.in;
    }
}

