/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.logging;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.morimekta.providence.PEnumValue;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageOrBuilder;
import net.morimekta.providence.PType;
import net.morimekta.providence.PUnion;
import net.morimekta.providence.descriptor.PContainer;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PMap;
import net.morimekta.providence.descriptor.PMessageDescriptor;
import net.morimekta.providence.descriptor.PPrimitive;
import net.morimekta.util.Binary;
import net.morimekta.util.Strings;
import net.morimekta.util.collect.UnmodifiableList;
import net.morimekta.util.io.IndentedPrintWriter;

public class LogFormatter {
    private static final String INDENT = "  ";
    private static final String SPACE = " ";
    private static final String NEWLINE = "\n";
    private static final String LIST_SEP = ",";
    private final String indent;
    private final String space;
    private final String newline;
    private final String entrySep;
    private final List<FieldHandler> fieldHandlers;

    public LogFormatter(FieldHandler ... fieldHandlers) {
        this(false, (Collection<FieldHandler>)UnmodifiableList.copyOf((Object[])fieldHandlers));
    }

    public LogFormatter(boolean pretty, FieldHandler ... fieldHandlers) {
        this(pretty, (Collection<FieldHandler>)UnmodifiableList.copyOf((Object[])fieldHandlers));
    }

    public LogFormatter(boolean pretty, Collection<FieldHandler> fieldHandlers) {
        this.indent = pretty ? INDENT : "";
        this.space = pretty ? SPACE : "";
        this.newline = pretty ? NEWLINE : "";
        this.entrySep = pretty ? "" : LIST_SEP;
        this.fieldHandlers = UnmodifiableList.copyOf(fieldHandlers);
    }

    public <Message extends PMessage<Message>> void formatTo(OutputStream out, PMessageOrBuilder<Message> message) {
        IndentedPrintWriter builder = new IndentedPrintWriter(out, this.indent, this.newline);
        if (message == null) {
            builder.append(null);
        } else {
            builder.append((CharSequence)message.descriptor().getQualifiedName()).append((CharSequence)this.space);
            this.appendMessage(builder, message);
        }
        builder.flush();
    }

    public <Message extends PMessage<Message>> String format(PMessageOrBuilder<Message> message) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.formatTo(out, message);
        return new String(out.toByteArray(), StandardCharsets.UTF_8);
    }

    private void appendMessage(IndentedPrintWriter writer, PMessageOrBuilder<?> message) {
        PMessageDescriptor type = message.descriptor();
        writer.append('{').begin();
        if (message instanceof PUnion) {
            if (((PUnion)message).unionFieldIsSet()) {
                PField field = ((PUnion)message).unionField();
                Object o = message.get(field.getId());
                writer.appendln().append((CharSequence)field.getName()).append((CharSequence)this.space).append('=').append((CharSequence)this.space);
                this.appendFieldValue(writer, field, o);
            }
        } else {
            boolean first = true;
            for (PField field : type.getFields()) {
                if (!message.has(field.getId())) continue;
                if (first) {
                    first = false;
                } else {
                    writer.append((CharSequence)this.entrySep);
                }
                Object o = message.get(field.getId());
                writer.appendln().append((CharSequence)field.getName()).append((CharSequence)this.space).append('=').append((CharSequence)this.space);
                this.appendFieldValue(writer, field, o);
            }
        }
        writer.end().appendln('}');
    }

    private void appendFieldValue(IndentedPrintWriter writer, PField field, Object value) {
        if (field.getType() != PType.MESSAGE) {
            for (FieldHandler handler : this.fieldHandlers) {
                if (!handler.appendFieldValue(writer, field, value)) continue;
                return;
            }
        }
        this.appendTypedValue(writer, field.getDescriptor(), value);
    }

    private void appendTypedValue(IndentedPrintWriter writer, PDescriptor descriptor, Object o) {
        switch (descriptor.getType()) {
            case LIST: 
            case SET: {
                PContainer containerType = (PContainer)descriptor;
                PDescriptor itemType = containerType.itemDescriptor();
                Collection collection = (Collection)o;
                PPrimitive primitive = PPrimitive.findByName((String)itemType.getName());
                if (primitive != null && primitive != PPrimitive.STRING && primitive != PPrimitive.BINARY && collection.size() <= 10) {
                    writer.append('[');
                    boolean first = true;
                    for (Object i : collection) {
                        if (first) {
                            first = false;
                        } else {
                            writer.append(',').append((CharSequence)this.space);
                        }
                        this.appendTypedValue(writer, containerType.itemDescriptor(), i);
                    }
                    writer.append(']');
                    break;
                }
                writer.append('[').begin();
                boolean first = true;
                for (Object i : collection) {
                    if (first) {
                        first = false;
                    } else {
                        writer.append(',');
                    }
                    writer.appendln();
                    this.appendTypedValue(writer, containerType.itemDescriptor(), i);
                }
                writer.end().appendln(']');
                break;
            }
            case MAP: {
                PMap mapType = (PMap)descriptor;
                Map map = (Map)o;
                writer.append('{').begin();
                boolean first = true;
                for (Map.Entry entry : map.entrySet()) {
                    if (first) {
                        first = false;
                    } else {
                        writer.append((CharSequence)this.entrySep);
                    }
                    writer.appendln();
                    this.appendTypedValue(writer, mapType.keyDescriptor(), entry.getKey());
                    writer.append(':').append((CharSequence)this.space);
                    this.appendTypedValue(writer, mapType.itemDescriptor(), entry.getValue());
                }
                writer.end().appendln('}');
                break;
            }
            case VOID: {
                writer.print(true);
                break;
            }
            case MESSAGE: {
                PMessage message = (PMessage)o;
                this.appendMessage(writer, (PMessageOrBuilder<?>)message);
                break;
            }
            default: {
                this.appendPrimitive(writer, o);
            }
        }
    }

    private void appendPrimitive(IndentedPrintWriter writer, Object o) {
        if (o instanceof PEnumValue) {
            writer.print(((PEnumValue)o).asString());
        } else if (o instanceof CharSequence) {
            writer.print('\"');
            writer.print(Strings.escape((CharSequence)((CharSequence)o)));
            writer.print('\"');
        } else if (o instanceof Binary) {
            Binary b = (Binary)o;
            writer.append((CharSequence)"b64").append('(').append((CharSequence)b.toBase64()).append(')');
        } else if (o instanceof Boolean) {
            writer.print(((Boolean)o).booleanValue());
        } else if (o instanceof Byte || o instanceof Short || o instanceof Integer || o instanceof Long) {
            writer.print(o.toString());
        } else if (o instanceof Double) {
            Double d = (Double)o;
            if (d.equals(d.longValue())) {
                writer.print(d.longValue());
            } else {
                writer.print(d.doubleValue());
            }
        } else {
            throw new IllegalArgumentException("Unknown primitive type class " + o.getClass().getSimpleName());
        }
    }

    @FunctionalInterface
    public static interface FieldHandler {
        public boolean appendFieldValue(IndentedPrintWriter var1, PField var2, Object var3);
    }
}

