/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.logging;

import java.io.IOException;
import java.io.InputStream;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PServiceCall;
import net.morimekta.providence.descriptor.PMessageDescriptor;
import net.morimekta.providence.descriptor.PService;
import net.morimekta.providence.logging.MessageReader;
import net.morimekta.providence.serializer.Serializer;

public class IOMessageReader
implements MessageReader {
    private final Serializer serializer;
    private final InputStream in;

    public IOMessageReader(InputStream in, Serializer serializer) {
        this.in = in;
        this.serializer = serializer;
    }

    @Override
    public <Message extends PMessage<Message>> Message read(PMessageDescriptor<Message> descriptor) throws IOException {
        return (Message)this.serializer.deserialize(this.in, descriptor);
    }

    @Override
    public <Message extends PMessage<Message>> PServiceCall<Message> read(PService service) throws IOException {
        return this.serializer.deserialize(this.in, service);
    }

    @Override
    public void verifyEndOfContent() throws IOException {
        this.serializer.verifyEndOfContent(this.in);
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }
}

