/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.jdbi.v3;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Objects;
import java.util.TimeZone;
import javax.annotation.Nonnull;
import net.morimekta.providence.PEnumValue;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageOrBuilder;
import net.morimekta.providence.PType;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.serializer.BinarySerializer;
import net.morimekta.providence.serializer.JsonSerializer;
import net.morimekta.util.Binary;
import net.morimekta.util.Strings;
import org.jdbi.v3.core.argument.Argument;
import org.jdbi.v3.core.result.ResultSetException;
import org.jdbi.v3.core.statement.StatementContext;

public class MessageFieldArgument<M extends PMessage<M>>
implements Argument {
    private static final BinarySerializer BINARY = new BinarySerializer();
    private static final JsonSerializer JSON = new JsonSerializer().named();
    private static final Calendar UTC = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
    private final PMessageOrBuilder<M> message;
    private final PField<M> field;
    private final int type;

    public MessageFieldArgument(@Nonnull PMessageOrBuilder<M> message, @Nonnull PField<M> field) {
        this(message, field, MessageFieldArgument.getDefaultColumnType(field));
    }

    public MessageFieldArgument(@Nonnull PMessageOrBuilder<M> message, @Nonnull PField<M> field, int type) {
        this.message = message;
        this.field = field;
        this.type = type;
    }

    public String toString() {
        if (this.message.has(this.field)) {
            if (this.field.getType() == PType.STRING) {
                return "'" + this.message.get(this.field) + "'";
            }
            if (this.field.getType() == PType.BINARY) {
                Binary binary = (Binary)this.message.get(this.field);
                return "b64(" + binary.toBase64() + ")";
            }
            if (this.field.getType() == PType.MESSAGE) {
                return ((PMessage)this.message.get(this.field)).asString();
            }
            return Strings.asString((Object)this.message.get(this.field));
        }
        return "null";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MessageFieldArgument)) {
            return false;
        }
        MessageFieldArgument other = (MessageFieldArgument)o;
        return Objects.equals(this.message, other.message) && Objects.equals(this.field, other.field) && this.type == other.type;
    }

    public int hashCode() {
        return Objects.hash(this.getClass(), this.message, this.field, this.type);
    }

    public void apply(int position, PreparedStatement statement, StatementContext ctx) throws SQLException {
        block45: {
            block46: {
                if (!this.message.has(this.field)) break block46;
                switch (this.field.getType()) {
                    case BOOL: {
                        boolean value = (Boolean)this.message.get(this.field);
                        if (this.type == 16 || this.type == -7) {
                            statement.setBoolean(position, value);
                        } else {
                            statement.setInt(position, value ? 1 : 0);
                        }
                        break block45;
                    }
                    case BYTE: {
                        statement.setByte(position, (Byte)this.message.get(this.field));
                        break block45;
                    }
                    case I16: {
                        statement.setShort(position, (Short)this.message.get(this.field));
                        break block45;
                    }
                    case I32: {
                        if (this.type == 93 || this.type == 2014) {
                            Timestamp timestamp = new Timestamp(1000L * (long)((Integer)this.message.get(this.field)).intValue());
                            statement.setTimestamp(position, timestamp, UTC);
                        } else if (this.type == 91) {
                            Date date = new Date(1000L * (long)((Integer)this.message.get(this.field)).intValue());
                            statement.setDate(position, date);
                        } else {
                            statement.setInt(position, (Integer)this.message.get(this.field));
                        }
                        break block45;
                    }
                    case I64: {
                        if (this.type == 93 || this.type == 2014) {
                            Timestamp timestamp = new Timestamp((Long)this.message.get(this.field));
                            statement.setTimestamp(position, timestamp, UTC);
                        } else if (this.type == 91) {
                            Date date = new Date((Long)this.message.get(this.field));
                            statement.setDate(position, date);
                        } else {
                            statement.setLong(position, (Long)this.message.get(this.field));
                        }
                        break block45;
                    }
                    case DOUBLE: {
                        statement.setDouble(position, (Double)this.message.get(this.field));
                        break block45;
                    }
                    case STRING: {
                        switch (this.type) {
                            case 2005: 
                            case 2011: {
                                StringReader reader = new StringReader((String)this.message.get(this.field));
                                statement.setClob(position, reader);
                                break;
                            }
                            default: {
                                statement.setString(position, (String)this.message.get(this.field));
                                break;
                            }
                        }
                        break block45;
                    }
                    case BINARY: {
                        Binary binary = (Binary)this.message.get(this.field);
                        switch (this.type) {
                            case -3: 
                            case -2: {
                                statement.setBytes(position, binary.get());
                                break block45;
                            }
                            case -4: {
                                statement.setBinaryStream(position, binary.getInputStream());
                                break block45;
                            }
                            case 2004: {
                                statement.setBlob(position, binary.getInputStream());
                                break block45;
                            }
                            case -15: 
                            case -9: 
                            case -1: 
                            case 1: 
                            case 12: {
                                statement.setString(position, binary.toBase64());
                                break block45;
                            }
                            default: {
                                throw new ResultSetException("Unknown binary field type: " + this.type + " for " + this.field, null, ctx);
                            }
                        }
                    }
                    case ENUM: {
                        PEnumValue value = (PEnumValue)this.message.get(this.field);
                        statement.setInt(position, value.asInteger());
                        break block45;
                    }
                    case MESSAGE: {
                        PMessage value = (PMessage)this.message.get(this.field);
                        switch (this.type) {
                            case -4: 
                            case -3: 
                            case -2: {
                                ByteArrayOutputStream out = new ByteArrayOutputStream();
                                try {
                                    BINARY.serialize((OutputStream)out, (PMessageOrBuilder)value);
                                    statement.setBytes(position, out.toByteArray());
                                    break block45;
                                }
                                catch (IOException e) {
                                    throw new ResultSetException(e.getMessage(), (Exception)e, ctx);
                                }
                            }
                            case 2004: {
                                ByteArrayOutputStream out = new ByteArrayOutputStream();
                                try {
                                    BINARY.serialize((OutputStream)out, (PMessageOrBuilder)value);
                                    statement.setBlob(position, new ByteArrayInputStream(out.toByteArray()));
                                    break block45;
                                }
                                catch (IOException e) {
                                    throw new ResultSetException(e.getMessage(), (Exception)e, ctx);
                                }
                            }
                            case -15: 
                            case -9: 
                            case -1: 
                            case 1: 
                            case 12: {
                                StringWriter writer = new StringWriter();
                                try {
                                    JSON.serialize(new PrintWriter(writer), (PMessageOrBuilder)value);
                                    statement.setString(position, writer.getBuffer().toString());
                                    break block45;
                                }
                                catch (IOException e) {
                                    throw new ResultSetException(e.getMessage(), (Exception)e, ctx);
                                }
                            }
                            case 2005: 
                            case 2011: {
                                StringWriter writer = new StringWriter();
                                try {
                                    JSON.serialize(new PrintWriter(writer), (PMessageOrBuilder)value);
                                    statement.setClob(position, new StringReader(writer.getBuffer().toString()));
                                    break block45;
                                }
                                catch (IOException e) {
                                    throw new ResultSetException(e.getMessage(), (Exception)e, ctx);
                                }
                            }
                            default: {
                                throw new ResultSetException("Unknown message field type: " + this.type + " for " + this.field, null, ctx);
                            }
                        }
                    }
                    default: {
                        throw new ResultSetException("Unhandled field type in SQL: " + this.field, null, ctx);
                    }
                }
            }
            statement.setNull(position, this.type);
        }
    }

    static int getDefaultColumnType(PField field) {
        switch (field.getType()) {
            case BOOL: {
                return -7;
            }
            case BYTE: {
                return -6;
            }
            case I16: {
                return 5;
            }
            case I32: 
            case ENUM: {
                return 4;
            }
            case I64: {
                return -5;
            }
            case DOUBLE: {
                return 8;
            }
            case STRING: 
            case MESSAGE: {
                return 12;
            }
            case BINARY: {
                return -3;
            }
            case SET: 
            case LIST: {
                return 2003;
            }
        }
        throw new IllegalArgumentException("No default column type for " + field.toString());
    }
}

